# Features
* [wpmlcore-6850] Changed all occurrences of the "Gutenberg editor" name into "Block editor".
* [wpmlcore-6686] Improved the dependency check between different versions of WPML plugins.
* [wpmlcore-6679] Implemented a custom library for Collections to ensure compatibility with other plugins.
* [wpmlcore-6527] Added a warning in the Reset WPML functionality, informing Advanced Translation Editor users that will lose the in-progress translations
* [wpmlcore-6471] Allow Gutenberg block fields to be specified as links and replace any links with translations if they are available.

# Fixes
* [wpmlcore-6844] Prevented attempt to sync non-hierarchical taxonomies.
* [wpmlcore-6834] Fixed block attribute encoding.
* [wpmlcore-6827] Fixed an issue where target links were not automatically translated in image and button blocks.
* [wpmlcore-6813] Fixed the "Uncaught Error: Call to undefined function icl_xml2array()" fatal error that happened when using wp-cli.
* [wpmlcore-6759] Fixed an issue to prevent WPML from overriding the page metadata when WPML media is active and a page created with Beaver Builder is published.
* [wpmlcore-6730] Fixed an issue with too big flags shown in the admin panel when custom flag image of a large size is used.
* [wpmlcore-6682] Fixed an error thrown when saving a Gutenberg translation job with a string containing a slash.
* [wpmlcore-6673] Fixed bug when editor was not able to edit translations.

# Compatibility
* [wpmlcore-6867] Change the language switcher type string in the Language Switcher Elementor widget.
* [wpmlcore-6847] Fixed an issue where post tags were converted to IDs when saving a page created using a page builder and the WPML Media Translation plugin was active.
* [wpmlcore-6832] Fixed an issue where adding a booking to the cart was too slow.
* [wpmlcore-6831] Added a fix to prevent long code execution when saving the taxonomy settings.
* [wpmlcore-6825] Fixed an error that happened when Elementor JSON data was invalid.
* [wpmlcore-6817] Fixed a problem with inaccessible REST Endpoints when a site is installed in a subdirectory and the "Use directory for default language" option is enabled.
* [wpmlcore-6805] Improved the Language Switcher accessibility for screen readers.
* [wpmlcore-6797] Fixed a fatal error related to running the troubleshooting action to assign translation status to duplicates.
* [wpmlcore-6787] Changed the "wpml_collect" vendor path to "wpml/collect" to avoid conflicts.
* [wpmlcore-6781] Added a check to prevent the "wordpress-seo" compatibility classes from loading if the Yoast SEO Multilingual plugin is active.
* [wpmlcore-6691] Optimized usage of the "debug_backtrace" function which improves performance by up to 7% in some cases.
* [wpmlcore-6669] Introduced the "wpml_custom_language_switcher_is_enabled" filter hook.
* [wpmlcore-6636] Fixed an issue where some Elementor Templates were not displayed on translated pages.
* [wpmlcore-6553] Added a language switcher widget for the Elementor page builder.

# Performances
* [wpmlcore-6858] Added a fix that lowers the database usage by preventing some resource-intensive options from autoloading.
* [wpmlcore-6809] Added the "wp_" prefix to all cookies so that hosting and caching layers can properly handle them.
* [wpmlcore-6795] Significantly improved the site performance on when updating the page, post, or a WooCommerce product page in the admin.
* [wpmlcore-6775] Improved the performance on sites with big number of translated taxonomies (for example, product categories).
* [wpmlcore-6766] Improved the performance when saving the post with a big number of custom fields.
* [wpmlcore-6749] Improved the performance when WooCommerce and/or Query Monitor are active.
* [wpmlcore-6694] Improved performance of database requests by adding two indexes to the "icl_translations" table.

# API
* [wpmlcore-6765] Added a filter that allows filtering the post meta values before they are copied to the translation.
* [wpmlcore-6681] Added the "wpml_post_edit_meta_box_context" filter to allow changing WPML's post edit meta box context.