"use strict";function _typeof(e){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof(e)}function geocluster(e,t,a,o){return t=parseFloat(t),this instanceof geocluster?this._cluster(e,t,a,o):new geocluster(e,t,a,o)}geocluster.prototype._toRad=function(e){return e*Math.PI/180},geocluster.prototype._dist=function(e,t,a,o){var i=this._toRad(a-e),r=this._toRad(o-t),n=Math.sin(i/2)*Math.sin(i/2)+Math.sin(r/2)*Math.sin(r/2)*Math.cos(this._toRad(e))*Math.cos(this._toRad(a));return Math.round(2*Math.atan2(Math.sqrt(n),Math.sqrt(1-n))*6371*100)/100},geocluster.prototype._centroid=function(e){var t=Object.values(e).reduce(function(e,t){return{latitude:e.latitude+t.latitude,longitude:e.longitude+t.longitude}},{latitude:0,longitude:0});return t=Object.values(t).map(function(t){return t/Object.keys(e).length}),t},geocluster.prototype._clean=function(e){return e.map(function(e){return[e.centroid,e.elements]})},geocluster.prototype._cluster=function(e,t,a,o){var i,r=this,n=[];("number"!=typeof t||isNaN(t))&&(t=1);for(var l,s=0,d=[],p=1;p<e.length;p++)l=r._dist(e[p].latitude,e[p].longitude,e[p-1].latitude,e[p-1].longitude),s+=l,d.push(l);var u=s/d.length,c=0;d.forEach(function(e){c+=Math.pow(e-u,2)});Math.sqrt(c/d.length);var m=1e4*t,g=[];g.push({centroid:e[Math.floor(.5*e.length)],elements:[],fill:a.fill,hover:a.hover,radius:a.radius});for(var h=!0;!0===h;){var M=!1,v=!1;e.forEach(function(e,t){var a=1/0,o=null;g.forEach(function(t,i){var n=r._dist(e.latitude,e.longitude,g[i].centroid.latitude,g[i].centroid.longitude);n<a&&(a=n,o=i)}),a<m||0===a?g[o].elements.push(e):(g.push({centroid:e,elements:[e]}),M=!0)}),g=g.filter(function(e){return e.elements.length>0}),g.forEach(function(e,t){var a=r._centroid(e.elements);h=!1,a.latitude===e.centroid.latitude&&a.longitude===e.centroid.longitude||(g[t].centroid=a,v=!0)}),v||M?h&&(g=g.map(function(e){return e.elements=[],e})):h=!1}return g=g.map(function(e){1===e.elements.length?n.push(e.elements[0]):(i={id:"",label:e.elements.length,name:"",value:e.elements.length,cluster:!0,latitude:e.centroid[0],longitude:e.centroid[1],elements:e.elements,content:"",fill:a.fill,hover:a.hover,radius:a.radius,action:""},o&&(i.tooltipTemplate=o),n.push(i))}),n};var iMapsRouter={getGeoFiles:function(e){var t,a,o=e.id.toString(),i=e.name,r={},n=["southAmerica","northAmerica","europe","middleEast","asia","oceania","africa","antarctica"];return n.includes(o)?(t="region/world/",a="_region_world_"):o.includes("US-")?(t="region/usa/",a="_region_usa_",o=o.substr(-2).toLowerCase()):(t="",a="_",o=i.toLowerCase().replace("united states","usa")),r.src="https://cdn.amcharts.com/lib/4/geodata/"+t+o+"Low.js",r.map="am4geodata"+a+o+"Low",r.title=i,r},getAllSrc:function(){var e={},t={main:"../../vendor/geodata",usa:"../../vendor/geodata/region/usa",world:"../../vendor/geodata/region/world"},a=require("fs");return Object.keys(t).forEach(function(o){e[o]=[],a.readdir(t[o],function(t,a){a.forEach(function(t){e[o].push(t)})})}),e},getVarByName:function(e){return void 0===e?"am4geodata_worldLow":e.includes("custom")?e:(e=e.replace(/\//g,"_"),"am4geodata_"+e)},getCleanMapName:function(e,t){return void 0!==e&&(e=e.replace("Low",""),e=e.replace("High",""),"custom"===e&&(e+=t),e)},iso2cleanName:function(e,t){var a,o=iMapsRouter.getCountries(),i=["africa","antarctiva","asia","europe","middleEast","northAmerica","oceania","southAmerica","centralAmerica"],r=iMapsManager.maps[t].seriesIndex,n=!1;if(console.log("ISO: "+e),"VA"===e)return"vatican";if("US"===e)return"usa";if(e.includes("CA-"))return"region/canada/"+e.replace("CA-","").toLowerCase();if(e.includes("MX-"))return"region/mexico/"+e.replace("MX-","").toLowerCase();if(i.includes(e))return"region/world/"+e;if(e.includes("US-")?a=["region/usa/"+e.replace("US-","").toLowerCase(),"region/usa/congressional/"+e.replace("US-","").toLowerCase()]:"GB"===e?a=["uk","ukCountries","ukCounties"]:"BA"===e?a=["bosniaHerzegovinaCantons","bosniaHerzegovina"]:"IL"===e?a=["israel","israelPalestine"]:"SI"===e?a=["sloveniaRegions","slovenia"]:"IN"===e?a=["india2019","india","india2020"]:"AE"===e?a=["unitedArabEmirates","uae"]:"FR"===e?a=["franceDepartments","france"]:"MG"===e?a=["madagascarProvince","madagascarRegion"]:"PT"===e?a=["portugal","portugalRegions"]:"RS"===e?a=["serbia","serbiaNoKosovo"]:"CD"===e?a=["congoDR"]:"CG"===e?a=["congo"]:"CZ"===e&&(a=["czechRepublic","czechia"]),Array.isArray(a)){if(a.forEach(function(e,t){r.hasOwnProperty(e)&&(n=e)}),n)return n}else if(o.hasOwnProperty(e))return iMapsRouter.camelize(o[e]);return!1},getCountries:function(){var e='{"AF":"Afghanistan","AX":"Åland Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua & Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AC":"Ascension Island","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BA":"Bosnia & Herzegovina","BW":"Botswana","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","IC":"Canary Islands","CV":"Cape Verde","BQ":"Caribbean Netherlands","KY":"Cayman Islands","CF":"Central African Republic","EA":"Ceuta & Melilla","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo - Brazzaville","CD":"Congo - Kinshasa","CK":"Cook Islands","CR":"Costa Rica","CI":"Côte d’Ivoire","HR":"Croatia","CU":"Cuba","CW":"Curaçao","CY":"Cyprus","CZ":"Czechia","DK":"Denmark","DG":"Diego Garcia","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","SZ":"Eswatini","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HN":"Honduras","HK":"Hong Kong SAR China","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","XK":"Kosovo","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao SAR China","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar (Burma)","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","KP":"North Korea","MK":"North Macedonia","MP":"Northern Mariana Islands","NO":"Norway","OM":"Oman","PK":"Pakistan","PW":"Palau","PS":"Palestinian Territories","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn Islands","PL":"Poland","PT":"Portugal","XA":"Pseudo-Accents","XB":"Pseudo-Bidi","PR":"Puerto Rico","QA":"Qatar","RE":"Réunion","RO":"Romania","RU":"Russia","RW":"Rwanda","WS":"Samoa","SM":"San Marino","ST":"São Tomé & Príncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SX":"Sint Maarten","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia & South Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","BL":"St Barthélemy","SH":"St Helena","KN":"St Kitts & Nevis","LC":"St Lucia","MF":"St Martin","PM":"St Pierre & Miquelon","VC":"St Vincent & Grenadines","SD":"Sudan","SR":"Suriname","SJ":"Svalbard & Jan Mayen","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad & Tobago","TA":"Tristan da Cunha","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks & Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom","US":"United States","UY":"Uruguay","UM":"US Outlying Islands","VI":"US Virgin Islands","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican City","VE":"Venezuela","VN":"Vietnam","WF":"Wallis & Futuna","EH":"Western Sahara","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"}';return JSON.parse(e)},camelize:function(e){return e.replace(/(?:^\w|[A-Z]|\b\w)/g,function(e,t){return 0==t?e.toLowerCase():e.toUpperCase()}).replace(/\s+/g,"")}},iMapsModel={prepareData:function(e){return e&&Array.isArray(e)?(e.forEach(function(t,a){e[a]=iMapsModel.iterateData(t),Array.isArray(e[a].overlay)&&e[a].overlay.length>0&&e[a].overlay.forEach(function(t,o){e[a].overlay[o].map===e[a].map&&(e[a].overlay[o].include=iMapsModel.prepareOverlayInclude(t)),e[a].overlay[o]=iMapsModel.iterateData(t)})}),e):e},prepareOverlayInclude:function(e){var t=e.includes||"";return e.regions&&e.regions.forEach(function(e,a){t+=","+e.id}),t},iterateData:function(e){"function"==typeof igm_custom_filter&&(e=igm_custom_filter(e));var t="igm_custom_filter_"+e.id;return"function"==typeof window[t]&&(e=window[t](e)),e=iMapsModel.prepareColor(e),e=iMapsModel.prepareExcludeIncludes(e),e=iMapsModel.coordinatesToInt(e),e=iMapsModel.prepareEntriesData(e),e=iMapsModel.prepareGroupedRegions(e),e=iMapsModel.prepareImageFields(e),e=iMapsModel.prepareMultiGeoLine(e),e},prepareMultiGeoLine:function(e){return Array.isArray(e.lines)&&e.lines.length&&e.lines.map(function(e){e.multiGeoLine.map(function(e){Object.assign(e,e.coordinates),delete e.coordinates})}),e},prepareImageFields:function(e){return Array.isArray(e.imageMarkers)&&Array.isArray(e.imageMarkers)&&e.imageMarkers.map(function(e){return void 0===e.href&&e.image&&(Array.isArray(e.image)||"object"==typeof e.image)&&(e.href=e.image.url),e}),e},prepareGroupedRegions:function(e){var t,a,o;return Array.isArray(e.regions)&&e.regions.length&&e.regions.map(function(i,r){if(!i.id||!String(i.id).includes(","))return i;o=[],t=i.id.split(","),t.forEach(function(e,t){a=Object.assign({},i),a.id=e.trim(),a.originalID=i.id,isNaN(a.id),o.push(a)}),void 0===e.regionGroups&&(e.regionGroups=[]),e.regionGroups.push(o),e.regions.splice(r,-1)}),e},prepareTooltip:function(e,t){var a,o,i,r,n,l;return void 0===t||void 0===e?e:(a=void 0!==t.maxWidth&&""!==t.maxWidth&&parseInt(t.maxWidth),o=iMapsModel.isMSIE(),o?iMapsModel.removeHTMLtags(e):(e&&e.includes("<img")&&(n=document.createRange(),n.selectNode(document.getElementsByTagName("div").item(0)),r=n.createContextualFragment(e),i=r.querySelectorAll("img"),i.length>0&&(i.forEach(function(e){0!==e.width&&""===e.style.width&&(e.style.width=e.width+"px"),0!==e.height&&""===e.style.height&&(e.style.height=e.height+"px")}),l=document.createElement("div"),l.appendChild(r.cloneNode(!0)),e=l.innerHTML)),a&&""!==e&&!o&&(e='<div class="imapsInnerTooltip" style="max-width:'+a+'px">'+e+"</div>"),e))},isMSIE:function(){return window.navigator.userAgent.match(/(MSIE|Trident)/)},removeHTMLtags:function(e){return null===e||""===e?"":(e=e.toString(),e.replace(/<[^>]*>/g,""))},prepareEntriesData:function(e){e.heatMapMarkers&&"1"===e.heatMapMarkers.enabled&&(e.heatMapMarkers.minRadius=parseInt(e.heatMapMarkers.minRadius),e.heatMapMarkers.maxRadius=parseInt(e.heatMapMarkers.maxRadius));var t=e.id;return Array.isArray(e.regions)&&e.regions.length&&(e.regions.map(function(a){return void 0!==a.useDefaults&&"1"!==a.useDefaults||Object.assign(a,e.regionDefaults),void 0!==a.action&&"default"===a.action&&(a.action=e.regionDefaults.action),void 0!==e.regionDefaults.triggerClickOnHover&&"1"===e.regionDefaults.triggerClickOnHover&&(a.triggerClickOnHover=!0),void 0!==e.regionActiveState&&"1"===e.regionActiveState.enabled&&(a.activeState=!0),e.regionLabels&&"custom"===e.regionLabels.source&&void 0!==e.regionLabels.customSource&&(e.regionLabels.customSource.includes(".")?a.autoLabel=e.regionLabels.customSource.split(".").reduce(function(e,t){return e[t]?e[t]:0},a):a.autoLabel=a[e.regionLabels.customSource]),e.heatMapRegions&&"1"===e.heatMapRegions.enabled&&(e.heatMapRegions.source.includes(".")&&(a.heatMapRegionRef=e.heatMapRegions.source.split(".").reduce(function(e,t){return e[t]?e[t]:0},a)),delete a.fill),void 0!==e.visual.borderColorHover&&e.visual.borderColorHover!==e.visual.borderColor&&(a.borderColorHover=e.visual.borderColorHover),void 0!==e.visual.borderWidthHover&&e.visual.borderWidthHover!==e.visual.borderWidth&&(a.borderWidthHover=e.visual.borderWidthHover),a.tooltipContent=iMapsModel.prepareTooltip(a.tooltipContent,e.tooltip),a.mapID=t,a.value&&void 0!==_typeof(a.value)&&""!==a.value&&(a.val=a.value,a.value=parseFloat(a.value)),a}),e.heatMapRegions&&e.heatMapRegions.source.includes(".")&&(e.heatMapRegions.source="heatMapRegionRef")),Array.isArray(e.roundMarkers)&&e.roundMarkers.length&&(e.roundMarkers.map(function(a){return void 0!==a.useDefaults&&"1"!==a.useDefaults||Object.assign(a,e.markerDefaults),a.coordinates&&(a.latitude=a.coordinates.latitude,a.longitude=a.coordinates.longitude),void 0===a.name&&(a.name=a.id),e.roundMarkersMobileSize&&100!==parseInt(e.roundMarkersMobileSize)&&window.innerWidth<=780&&(a.radius=parseFloat(a.radius)*parseFloat(e.roundMarkersMobileSize)/100),e.heatMapMarkers&&"1"===e.heatMapMarkers.enabled&&(isNaN(a.value)||(a.value=parseFloat(a.value)),e.heatMapMarkers.source.includes(".")&&(a.heatMapMarkerRef=e.heatMapMarkers.source.split(".").reduce(function(e,t){return e[t]?e[t]:0},a)),delete a.fill,delete a.radius),a.value&&void 0!==_typeof(a.value)&&""!==a.value&&(a.val=a.value,a.value=parseFloat(a.value)),"default"===a.action&&(a.action=e.markerDefaults.action),void 0!==e.markerDefaults.triggerClickOnHover&&"1"===e.markerDefaults.triggerClickOnHover&&(a.triggerClickOnHover=!0),void 0!==e.triggerRegionHover&&"1"===e.triggerRegionHover.enabled&&(a.triggerRegionHover=!0),a.tooltipContent=iMapsModel.prepareTooltip(a.tooltipContent,e.tooltip),a.mapID=t,a}),e.roundMarkers=e.roundMarkers.filter(function(e){return void 0!==e.latitude&&""!==e.latitude&&""!==e.name}),e.heatMapMarkers&&e.heatMapMarkers.source.includes(".")&&(e.heatMapMarkers.source="heatMapMarkerRef")),Array.isArray(e.iconMarkers)&&e.iconMarkers.length&&e.iconMarkers.map(function(a){return void 0!==a.useDefaults&&"1"!==a.useDefaults||Object.assign(a,e.iconMarkerDefaults),a.coordinates&&(a.latitude=a.coordinates.latitude,a.longitude=a.coordinates.longitude),void 0===a.name&&(a.name=a.id),"default"===a.action&&(a.action=e.iconMarkerDefaults.action),void 0!==e.iconMarkerDefaults.triggerClickOnHover&&"1"===e.iconMarkerDefaults.triggerClickOnHover&&(a.triggerClickOnHover=!0),e.iconMarkersMobileSize&&100!==parseInt(e.iconMarkersMobileSize)&&window.innerWidth<=780&&(a.scale=parseFloat(a.scale)*parseFloat(e.iconMarkersMobileSize)/100),a.val=a.value,a.value=parseFloat(a.value),a.tooltipContent=iMapsModel.prepareTooltip(a.tooltipContent,e.tooltip),a.mapID=t,a}),Array.isArray(e.imageMarkers)&&e.imageMarkers.length&&e.imageMarkers.map(function(a){return void 0!==a.useDefaults&&"1"!==a.useDefaults||Object.assign(a,e.imageMarkerDefaults),a.coordinates&&(a.latitude=a.coordinates.latitude,a.longitude=a.coordinates.longitude),void 0!==a.nonScaling&&(a.nonScaling=iMapsManager.bool(a.nonScaling)),void 0===a.size&&(a.size=e.imageMarkerDefaults.size),void 0===a.horizontalCenter&&(a.horizontalCenter=e.imageMarkerDefaults.horizontalCenter),void 0===a.verticalCenter&&(a.verticalCenter=e.imageMarkerDefaults.verticalCenter),void 0===a.name&&(a.name=a.id),"default"!==a.action&&void 0!==a.action||(a.action=e.imageMarkerDefaults.action),void 0!==e.imageMarkerDefaults.triggerClickOnHover&&"1"===e.imageMarkerDefaults.triggerClickOnHover&&(a.triggerClickOnHover=!0),e.imageMarkersMobileSize&&100!==parseInt(e.imageMarkersMobileSize)&&window.innerWidth<=780&&(a.size=parseFloat(a.size)*parseFloat(e.imageMarkersMobileSize)/100),a.val=a.value,a.value=parseFloat(a.value),a.tooltipContent=iMapsModel.prepareTooltip(a.tooltipContent,e.tooltip),a.mapID=t,a}),Array.isArray(e.labels)&&e.labels.length&&e.labels.map(function(a){return void 0!==a.useDefaults&&"1"!==a.useDefaults||(Object.assign(a,e.labelDefaults),Object.assign(a,e.labelPosition)),a.coordinates&&(Object.assign(a,a.coordinates),delete a.coordinates),"default"===a.action&&(a.action=e.labelDefaults.action),void 0!==e.labelDefaults.triggerClickOnHover&&"1"===e.labelDefaults.triggerClickOnHover&&(a.triggerClickOnHover=!0),void 0!==a.size&&(a.fontSize=a.size),e.labelsMobileSize&&100!==parseInt(e.labelsMobileSize)&&window.innerWidth<=780&&(a.fontSize=parseInt(a.fontSize)*parseInt(e.labelsMobileSize)/100,a.size=a.fontSize),a.tooltipContent=iMapsModel.prepareTooltip(a.tooltipContent,e.tooltip),a.mapID=t,a}),Array.isArray(e.lines)&&e.lines.length&&e.lines.map(function(t){return void 0!==t.useDefaults&&"1"!==t.useDefaults||Object.assign(t,e.lineDefaults),t.curvature=parseFloat(t.curvature),t}),e},prepareExcludeIncludes:function(e){return void 0!==e.onlyIncludeActive&&1===parseInt(e.onlyIncludeActive)?(e.include=[],e.exclude=[],e.regions&&e.regions.forEach(function(t,a){e.include.push(t.id),isNaN(t.id)||e.include.push(parseInt(t.id))}),e):(e.exclude&&"string"==typeof e.exclude&&e.exclude.trim().length&&(e.exclude=e.exclude.split(",").map(function(e){return e.trim()})),e.include&&e.include.trim().length&&(e.include=e.include.split(",").map(function(e){return e.trim()}),e.include.map(function(t){isNaN(t)||e.include.push(parseInt(t))})),e)},coordinatesToInt:function(e){var t=function(e,t){t[e].latitude=Number(t[e].latitude),t[e].longitude=Number(t[e].longitude)},a=function e(a){"object"===_typeof(a)&&null!==a&&Object.keys(a).map(function(o,i){if("object"===_typeof(a[o]))if("coordinates"===o||"homeGeoPoint"===o)t(o,a);else{if(void 0!==a.className)return;e(a[o])}})};return a(e),e},prepareColor:function(e){var t=["inactiveColor","activeColor","hoverColor","hover","inactiveHoverColor","backgroundColor","color","minColor","maxColor","fill","projectionBackgroundColor","borderColor","borderColorHover"],a=function(e){var t,a,o,i=e.split("|");return a="undefined"!=typeof igmGradientType?igmGradientType:"LinearGradient",o="undefined"!=typeof igmGradientOffset&&Array.isArray(igmGradientOffset)?igmGradientOffset:null,t=new am4core[a],i.forEach(function(e,a){t.addColor(am4core.color(e),1,o[a])}),t.rotation="undefined"!=typeof igmGradientRotation?igmGradientRotation:0,t},o=function(e){var t=e,a=new am4core.Pattern;a.width=150,a.height=150,a.strokeWidth=0,a.stroke=am4core.color("#6699cc");var o=new am4core.Image;return o.href=t,o.width=150,o.height=150,o.x=0,o.y=0,o.verticalCenter="middle",o.valign="middle",a.addElement(o.element),a.addElement(o.element),a.addElement(o.element),a},i=function(e,i){t.includes(e)&&(i[e].includes("|")?i[e]=a(i[e]):i[e].startsWith("http")?i[e]=o(i[e]):"transparent"===i[e]?i[e]=am4core.color("#f00",0):i[e]=am4core.color(i[e]))},r=function e(t){"object"===_typeof(t)&&null!==t&&Object.keys(t).map(function(a,o){if("object"===_typeof(t[a]))e(t[a]);else{if(void 0!==t.className)return;i(a,t)}})};return r(e),e},extractCodes:function(e){for(var t={},a=0;a<e.features.length;a++)t[e.features[a].properties.id]=e.features[a].properties.name;return t}},iMapsManager={maps:{},init:function(e){var t=this;t.addMap(e)},addMap:function(e){var t,a,o,i,r,n,l,s,d,p,u,c,m,g=this,h=iMapsData.data[e],M=h.id,v=document.getElementById(h.container),f=v.closest(".map_aspect_ratio");if(!h.disabled&&null!==v){if(void 0!==g.maps[M]&&g.maps[M].map.dispose(),window.innerWidth<=780&&void 0!==f.dataset.paddingTopMobile&&""!==f.dataset.paddingTopMobile?f.style.paddingTop=String(f.dataset.paddingTopMobile)+"%":f.style.paddingTop=String(h.visual.paddingTop)+"%",h.visual.maxWidth,""!==h.visual.fontFamily&&"inherit"!==h.visual.fontFamily&&(v.closest(".map_box").style.fontFamily=h.visual.fontFamily),g.maps[M]={map:am4core.create(h.container,am4maps.MapChart),series:[],clusterSeries:{},seriesIndex:{},seriesById:{},data:h,allBaseSeries:[],labelSeries:[],baseRegionSeries:{},groupedBaseRegionSeries:[]},t=g.maps[M].map,t.readerTitle="Interactive Map",p=g.maps[M].clusterSeries,t.events.on("ready",function(e){var t=new Event("mapready");v.dispatchEvent(t),g.triggerOnReady(M,h)}),t.events.on("appeared",function(e){var t=new Event("mapappeared");v.dispatchEvent(t),g.triggerOnAppeared(M,h),v.classList.remove("map_loading")}),void 0!==iMapsData.options&&void 0!==iMapsData.options.locale&&iMapsData.options.locale&&void 0!==window["am4lang_"+iMapsData.options.locale]&&(t.language.locale=window["am4lang_"+iMapsData.options.locale]),h.zoom&&h.zoom.smallMap&&g.bool(h.zoom.smallMap)&&(t.smallMap=new am4maps.SmallMap),"custom"===h.map||g.bool(h.useGeojson)?t.geodataSource.url=h.mapURL:(u=iMapsRouter.getVarByName(h.map),t.geodata=window[u]),t.projection=new am4maps.projections[h.projection],h.map.startsWith("usaTerritories")&&t.events.on("ready",function(e){t.projection=new am4maps.projections[h.projection]}),t.fontFamily=h.visual.fontFamily,h.exportMenu&&g.bool(h.exportMenu.enable)&&(t.exporting.menu=new am4core.ExportMenu,t.exporting.menu.items[0].icon="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CiA8Zz4KICA8dGl0bGU+YmFja2dyb3VuZDwvdGl0bGU+CiAgPHJlY3QgeD0iLTEiIHk9Ii0xIiB3aWR0aD0iNS45NDQ3NzMiIGhlaWdodD0iNS45NDQ3NzMiIGlkPSJjYW52YXNfYmFja2dyb3VuZCIgZmlsbD0ibm9uZSIvPgogPC9nPgoKIDxnPgogIDx0aXRsZT5MYXllciAxPC90aXRsZT4KICA8cGF0aCBzdHJva2U9Im51bGwiIGQ9Im0xNC40MjcwMzEsMTUuNzQwNDAxcTAsLTAuMjU3NjQzIC0wLjE4ODI3NCwtMC40NDU5MTd0LTAuNDQ1OTE3LC0wLjE4ODI3NHQtMC40NDU5MTcsMC4xODgyNzR0LTAuMTg4Mjc0LDAuNDQ1OTE3dDAuMTg4Mjc0LDAuNDQ1OTE3dDAuNDQ1OTE3LDAuMTg4Mjc0dDAuNDQ1OTE3LC0wLjE4ODI3NHQwLjE4ODI3NCwtMC40NDU5MTd6bTIuNTM2NzgsMHEwLC0wLjI1NzY0MyAtMC4xODgyNzQsLTAuNDQ1OTE3dC0wLjQ0NTkxNywtMC4xODgyNzR0LTAuNDQ1OTE3LDAuMTg4Mjc0dC0wLjE4ODI3NCwwLjQ0NTkxN3QwLjE4ODI3NCwwLjQ0NTkxN3QwLjQ0NTkxNywwLjE4ODI3NHQwLjQ0NTkxNywtMC4xODgyNzR0MC4xODgyNzQsLTAuNDQ1OTE3em0xLjI2ODM5LC0yLjIxOTY4NWwwLDMuMTcwOTdxMCwwLjM5NjM3NCAtMC4yNzc0NjEsMC42NzM4MzR0LTAuNjczODM0LDAuMjc3NDYxbC0xNC41ODY0NywwcS0wLjM5NjM3NCwwIC0wLjY3MzgzNCwtMC4yNzc0NjF0LTAuMjc3NDYxLC0wLjY3MzgzNGwwLC0zLjE3MDk3cTAsLTAuMzk2Mzc0IDAuMjc3NDYxLC0wLjY3MzgzNHQwLjY3MzgzNCwtMC4yNzc0NjFsNC42MDc4MTYsMGwxLjMzNzc1MSwxLjM0NzY1OXEwLjU3NDczOCwwLjU1NDkyMSAxLjM0NzY1OSwwLjU1NDkyMXQxLjM0NzY1OSwtMC41NTQ5MjFsMS4zNDc2NTksLTEuMzQ3NjU5bDQuNTk3OTA4LDBxMC4zOTYzNzQsMCAwLjY3MzgzNCwwLjI3NzQ2MXQwLjI3NzQ2MSwwLjY3MzgzNGwwLjAwMDAxOCwwem0tMy4yMjA1MjMsLTUuNjM4MzlxMC4xNjg0NTYsMC40MDYyODIgLTAuMTM4NzMsMC42OTM2NTFsLTQuNDM5MzYsNC40MzkzNnEtMC4xNzgzNjUsMC4xODgyNzQgLTAuNDQ1OTE3LDAuMTg4Mjc0dC0wLjQ0NTkxNywtMC4xODgyNzRsLTQuNDM5MzYsLTQuNDM5MzZxLTAuMzA3MTg3LC0wLjI4NzM2OSAtMC4xMzg3MywtMC42OTM2NTFxMC4xNjg0NTYsLTAuMzg2NDY1IDAuNTg0NjQ3LC0wLjM4NjQ2NWwyLjUzNjc4LDBsMCwtNC40MzkzNnEwLC0wLjI1NzY0MyAwLjE4ODI3NCwtMC40NDU5MTd0MC40NDU5MTcsLTAuMTg4Mjc0bDIuNTM2NzgsMHEwLjI1NzY0MywwIDAuNDQ1OTE3LDAuMTg4Mjc0dDAuMTg4Mjc0LDAuNDQ1OTE3bDAsNC40MzkzNmwyLjUzNjc4LDBxMC40MTYxOTEsMCAwLjU4NDY0NywwLjM4NjQ2NXoiIGlkPSJzdmdfMSIvPgogPC9nPgo8L3N2Zz4=",t.exporting.menu.align=h.exportMenu.align?h.exportMenu.align:"right",t.exporting.menu.verticalAlign=h.exportMenu.verticalAlign?h.exportMenu.verticalAlign:"top"),h.touchInterface&&(g.bool(h.touchInterface.tapToActivate)&&(t.tapToActivate=!0,t.tapTimeout=h.touchInterface.tapTimeout),g.bool(h.touchInterface.dragGrip)&&(t.dragGrip.disabled=!1,t.dragGrip.autoHideDelay=h.touchInterface.dragGripAutoHideDelay)),t.background.fill=h.visual.backgroundColor,t.background.fillOpacity=h.visual.backgroundOpacity,t.backgroundSeries.mapPolygons.template.focusable=!1,t.background.focusable=!1,t.backgroundSeries.focusable=!1,void 0!==h.visual.bgImage&&void 0!==h.visual.bgImage.url&&""!==h.visual.bgImage.url&&(c=t.series.push(new am4maps.MapImageSeries),c.toBack(),m=c.mapImages.template.createChild(am4core.Image),m.propertyFields.href="src",m.width=t.width,m.height=t.height,c.data=[{src:h.visual.bgImage.url}]),t.exporting.backgroundColor=h.visual.backgroundColor,t.exporting.filePrefix="interactive_map",t.exporting.useWebFonts=!1,"Orthographic"===h.projection&&h.grid&&(d=t.series.push(new am4maps.GraticuleSeries),d.mapLines.template.line.stroke=h.grid.color,d.mapLines.template.line.strokeOpacity=1,d.fitExtent=!1,t.backgroundSeries.mapPolygons.template.polygon.fillOpacity=1,t.backgroundSeries.mapPolygons.template.polygon.fill=h.grid.projectionBackgroundColor),g.handleZoom(M),h.legend&&g.bool(h.legend.enabled)&&(t.legend=new am4maps.Legend,"top"===h.legend.position||"bottom"===h.legend.position?(t.legend.contentAlign=h.legend.align,t.legend.valign=h.legend.position):(t.legend.position=h.legend.position,t.legend.align=h.legend.position,t.legend.valign=h.legend.valign),void 0!==h.legend.style&&"default"!==h.legend.style&&g.setLegendStyle(M,t.legend,h.legend.style),void 0!==_typeof(h.legend.fill)&&(t.legend.labels.template.fill=h.legend.fill),"false"===h.legend.clickable&&(t.legend.itemContainers.template.interactionsEnabled=!1),"toggle"===h.legend.clickable&&t.legend.itemContainers.template.events.on("hit",function(e){iMapsManager.clearSelected(M)}),"select"===h.legend.clickable&&(t.legend.itemContainers.template.togglable=!1,t.legend.itemContainers.template.events.on("hit",function(e){iMapsManager.clearSelected(M);var t=[],a=g.getTargetSeriesType(e.target.dataItem.dataContext);"MapPolygonSeries"===a&&(e.target.dataItem.dataContext.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||(e.setState("active"),e.isActive=!0,e.isHover=!1,t.push(e))}),g.maps[M].selected=t)}),t.legend.itemContainers.template.events.on("over",function(e){var t=g.getTargetSeriesType(e.target.dataItem.dataContext),a="";if("MapImageSeries"===t)a=e.target.dataItem.dataContext.mapImages,a.each(function(e){e.setState("highlight")});else{if("MapPolygonSeries"!==t)return;a=e.target.dataItem.dataContext.mapPolygons,a.each(function(e){e.dataItem.dataContext.madeFromGeoData||e.setState("highlight")})}}),t.legend.itemContainers.template.events.on("out",function(e){var t=g.getTargetSeriesType(e.target.dataItem.dataContext),a="";if("MapImageSeries"===t)a=e.target.dataItem.dataContext.mapImages,a.each(function(e){e.setState("default")});else{if("MapPolygonSeries"!==t)return;a=e.target.dataItem.dataContext.mapPolygons,a.each(function(e){e.dataItem.dataContext.madeFromGeoData||e.setState("default")})}}))),h.customLegend&&g.bool(h.customLegend.enabled)){var b=void 0!==h.customLegend.type?h.customLegend.type:"internal";h.customLegend.data&&Array.isArray(h.customLegend.data)&&"internal"===b&&(n=new am4maps.Legend,n.parent=t.chartContainer,n.data=h.customLegend.data,void 0!==h.customLegend.style&&"default"!==h.customLegend.style&&g.setLegendStyle(M,n,h.customLegend.style),n.itemContainers.template.clickable=!1,n.itemContainers.template.focusable=!1,n.itemContainers.template.hoverable=!1,n.itemContainers.template.cursorOverStyle=am4core.MouseCursorStyle.default,n.labels.template.truncate=!1,n.labels.template.wrap=!0,"top"===h.customLegend.position||"bottom"===h.customLegend.position?(n.contentAlign=h.customLegend.align,n.valign=h.customLegend.position):(n.position=h.customLegend.position,n.align=h.customLegend.position,n.valign=h.customLegend.valign),void 0!==_typeof(h.customLegend.fill)&&(n.labels.template.fill=h.customLegend.fill))}a=g.pushRegionSeries(M,h),g.maps[M].baseRegionSeries=a,Array.isArray(h.regionGroups)&&h.regionGroups.length&&(o=g.pushGroupSeries(M,h),g.maps[M].groupedBaseRegionSeries=o),Array.isArray(h.overlay)&&h.overlay.length&&h.overlay.forEach(function(e){g.pushSeries(M,e)}),Array.isArray(h.lines)&&h.lines.length&&g.pushLineSeries(M,h),Array.isArray(h.roundMarkers)&&h.roundMarkers.length&&(i=g.pushRoundMarkerSeries(M,h),h.clusterMarkers&&g.bool(h.clusterMarkers.enabled)&&(i.hidden=!0,g.setupClusters(h,M),p[M].zoomLevels[h.clusterMarkers.zoomLevel]=i,p[M].zoomLevels[1]&&(p[M].zoomLevels[1].hidden=!1,g.maps[M].allBaseSeries.push(p[M].zoomLevels[1])))),Array.isArray(h.imageMarkers)&&h.imageMarkers.length&&(l=g.pushImageMarkerSeries(M,h),g.maps[M].allBaseSeries.push(l)),Array.isArray(h.iconMarkers)&&h.iconMarkers.length&&(s=g.pushIconMarkerSeries(M,h),g.maps[M].allBaseSeries.push(s)),Array.isArray(h.labels)&&h.labels.length&&(r=g.pushLabelSeries(M,h),g.maps[M].allBaseSeries.push(r)),g.handleInfoBox(M)}},setLegendStyle:function(e,t,a){var o={xsmall:10,small:13,regular:16,large:19,larger:23},i=o[a],r=t.markers.template;t.labels.template.fontSize=i,t.useDefaultMarker=!0,r.width=i,r.height=i},handleZoom:function(e){var t=this,a=t.maps[e].map,o=t.maps[e].data,i=t.maps[e].series,r=t.maps[e].allBaseSeries,n=!0,l=!0;if(void 0!==o.viewport&&parseFloat(o.viewport.zoomLevel)>=1&&(a.homeZoomLevel=parseFloat(o.viewport.zoomLevel),l=!1,a.seriesContainer.resizable=!1,a.seriesContainer.draggable=!1,a.chartContainer.wheelable=!1),void 0!==o.viewport&&o.viewport.homeGeoPoint&&0!==o.viewport.homeGeoPoint.latitude&&0!==o.viewport.homeGeoPoint.longitude&&(a.homeGeoPoint=o.viewport.homeGeoPoint),void 0!==o.viewport&&o.viewport.offset&&(""!==o.viewport.offset.longitude&&"0"!==o.viewport.offset.longitude&&(n=!1,a.deltaLongitude=o.viewport.offset.longitude),""!==o.viewport.offset.latitude&&"0"!==o.viewport.offset.latitude&&(n=!1,a.deltaLatitude=o.viewport.offset.latitude),n&&iMapsManager.latlongOffsetFix(o,a,l)),void 0===o.viewport&&iMapsManager.latlongOffsetFix(o,a,l),void 0===o.zoom)return void 0!==o.zoomMaster&&t.bool(o.zoomMaster)?(a.seriesContainer.draggable=!0,a.seriesContainer.resizable=!0,a.zoomControl=new am4maps.ZoomControl,a.zoomControl.focusable=!1,a.zoomControl.exportable=!1,a.zoomControl.children&&a.zoomControl.children.values&&a.zoomControl.children.values.forEach(function(e){e.focusable=!1}),a.zoomControl.align="right",a.zoomControl.valign="bottom"):(a.seriesContainer.resizable=!1,a.seriesContainer.draggable=!1),a.seriesContainer.events.disableType("doublehit"),a.chartContainer.background.events.disableType("doublehit"),void(a.chartContainer.wheelable=!1);if("Orthographic"!==o.projection?(a.seriesContainer.draggable=!!o.zoom&&t.bool(o.zoom.draggable),a.seriesContainer.resizable=!!o.zoom&&t.bool(o.zoom.draggable),a.centerMapOnZoomOut=!1,a.maxPanOut=0,t.bool(o.zoom.enabled)&&!t.bool(o.zoom.draggable)&&t.bool(o.zoom.mobileResizable)&&/Mobi|Android/i.test(navigator.userAgent)&&(a.seriesContainer.draggable=!0,a.seriesContainer.resizable=!0)):(a.seriesContainer.draggable=!1,a.seriesContainer.resizable=!1,a.panBehavior="rotateLongLat"),t.bool(o.zoom.enabled)){if(a.chartContainer.wheelable=t.bool(o.zoom.wheelable),t.bool(o.zoom.doubleHitZoom)||(a.seriesContainer.events.disableType("doublehit"),a.chartContainer.background.events.disableType("doublehit")),void 0!==o.zoom.maxZoomLevel&&(a.maxZoomLevel=parseInt(o.zoom.maxZoomLevel)),t.bool(o.zoom.controls)&&(a.zoomControl=new am4maps.ZoomControl,a.zoomControl.exportable=!1,a.zoomControl.children&&a.zoomControl.children.values&&a.zoomControl.children.values.forEach(function(e){e.focusable=!1}),a.zoomControl.exportable=!1,a.zoomControl.align=o.zoom.controlsPositions?o.zoom.controlsPositions.align:"right",
a.zoomControl.valign=o.zoom.controlsPositions?o.zoom.controlsPositions.valign:"bottom",void 0===o.zoom.homeButton||t.bool(o.zoom.homeButton))){var s=new am4core.Button;s.focusable=!1,s.events.on("hit",function(){if(a.goHome(),t.bool(o.drillDownOnClick)){for(var n=0,l=i.length;n<l;n++)i[n].hide();for(var s=0,d=r.length;s<d;s++)r[s].show();iMapsManager.maps[e].drilledTo=!1,iMapsManager.maps[e].isDrilling=!1}"undefined"!=typeof iMapsActions&&void 0!==iMapsActions.resetActions&&iMapsActions.resetActions(e)}),s.icon=new am4core.Sprite,s.padding(7,5,7,5),s.width=30,s.icon.path="M16,8 L14,8 L14,16 L10,16 L10,10 L6,10 L6,16 L2,16 L2,8 L0,8 L8,0 L16,8 Z M16,8",s.marginBottom=3,s.parent=a.zoomControl,s.insertBefore(a.zoomControl.plusButton),a.events.on("inited",function(){s.deepInvalidate()})}t.bool(o.zoom.externalControls)&&iMapsManager.handleExternalZoom(o.id)}else a.maxZoomLevel=parseFloat(o.viewport.zoomLevel),a.seriesContainer.events.disableType("doublehit"),a.chartContainer.background.events.disableType("doublehit"),a.seriesContainer.draggable=!1,a.seriesContainer.resizable=!1,a.chartContainer.wheelable=!1;if(void 0!==o.fullScreen&&t.bool(o.fullScreen.enabled)){var d=a.chartContainer.createChild(am4core.Button);d.events.on("hit",function(e){var t=document.querySelector("#map_"+e.target.icon.mapID),a=t.closest(".map_wrapper");iMapsManager.openFullscreen(a),iMapsManager.isFullScreen=e.target}),d.align=o.fullScreen.align,d.valign=o.fullScreen.valign,d.margin(5,5,5,5),d.padding(5,0,5,0),d.width=30,d.icon=new am4core.Sprite,d.icon.path=iMapsManager.library.icons.goFullIconPath,d.icon.isFullScreen=!1,d.icon.mapID=e,t.bool(o.fullScreen.mobileOnly)?d.id="_fullscreen_button_only_mobile":d.id="_fullscreen_button"}a.events.on("mappositionchanged",function(e){}),a.events.on("zoomlevelchanged",function(a){var o,i=t.maps[e].clusterSeries,r=a.target.zoomLevel,n=t.bool(t.maps[e].data.drillDownOnClick),l=t.maps[e].isDrilling,s=t.maps[e].drilledTo,d=t.filteredMap;i&&Object.keys(i).length&&Object.keys(i).forEach(function(e){n&&i[e].overlay||d?l&&s&&parseInt(s)===parseInt(i[e].overlay)||d===parseInt(i[e].overlay)?(o=t.getClosest(i[e].zoomLevels,r),Object.keys(i[e].zoomLevels).forEach(function(t){i[e].zoomLevels[t].hide(),parseFloat(t)===o?i[e].zoomLevels[t].show():i[e].zoomLevels[t].hide()})):Object.keys(i[e].zoomLevels).forEach(function(t){i[e].zoomLevels[t].hide()}):(o=t.getClosest(i[e].zoomLevels,r),Object.keys(i[e].zoomLevels).forEach(function(t){i[e].zoomLevels[t].hide(),parseFloat(t)===o?i[e].zoomLevels[t].show():i[e].zoomLevels[t].hide()}))})})},getClosest:function(e,t){var a=Object.keys(e).reduce(function(e,a){return e=parseInt(e),a=parseInt(a),Math.abs(a-t)<Math.abs(e-t)?a:e});return a},latlongOffsetFix:function(e,t,a){var o=e.map,i=["russiaLow","russiaHigh","russiaCrimeaLow","russiaCrimeaHigh","region/world/asiaLow","region/world/asiaHigh","region/world/asiaUltra","region/world/asiaIndiaLow","region/world/asiaIndiaHigh","region/world/asiaIndiaUltra"];i.includes(o)&&e.exclude&&!e.exclude.includes("RU")&&(t.deltaLongitude=-100,a&&(t.homeZoomLevel=1.5)),"newZealandLow"!==o&&"newZealandHigh"!=o||(t.deltaLongitude=20)},pushGroupSeries:function(e,t){var a,o=[];return t.regionGroups.forEach(function(i){var r={},n=i.map(function(e){return e.id});r=Object.assign({},t),r.regionsGroupHover=!0,r.regions=i,r.include=n,a=iMapsManager.pushRegionSeries(e,r,!0),o.push(a)}),o},pushSeries:function(e,t){var a,o,i,r,n,l,s,d=this,p=d.maps[e].clusterSeries,u=d.maps[e].data,c=d.maps[e].seriesIndex,m=d.maps[e].seriesById,g=d.bool(d.maps[e].data.drillDownOnClick),h=iMapsRouter.getCleanMapName(t.map,t.id),M=!1;!1!==h&&void 0!==t.id&&(m[t.id]=[],void 0!==u.liveFilter&&u.liveFilter.default!==u.id&&(M=u.liveFilter.default),Array.isArray(d.maps[e].seriesIndex[t.map])||(d.maps[e].seriesIndex[h]=[]),Array.isArray(t.regions)||(t.regions=[]),void 0===u.allowEmpty&&(u.allowEmpty=0),(t.regions.length||d.bool(u.allowEmpty))&&(d.bool(u.allowEmpty)||(t.include=[],t.regions.forEach(function(e,a){t.include.push(e.id),isNaN(e.id)||t.include.push(parseInt(e.id))})),a=iMapsManager.pushRegionSeries(e,t),c[h].push(a),m[t.id].push(a),g&&(a.hidden=!0,a.mapID=t.id),u.liveFilter&&d.bool(u.liveFilter.enabled)&&M&&M!==t.id&&(a.hidden=!0)),Array.isArray(t.regionGroups)&&t.regionGroups.length&&(s=d.pushGroupSeries(e,t),s.forEach(function(e){c[h].push(e),m[t.id].push(e),g&&(e.hidden=!0,e.mapID=t.id)})),Array.isArray(t.lines)&&t.lines.length&&(r=iMapsManager.pushLineSeries(e,t),c[h].push(r),m[t.id].push(r),g&&(r.hidden=!0),u.liveFilter&&d.bool(u.liveFilter.enabled)&&M&&M!==t.id&&(r.hidden=!0)),Array.isArray(t.roundMarkers)&&t.roundMarkers.length&&(o=iMapsManager.pushRoundMarkerSeries(e,t),c[h].push(o),m[t.id].push(o),g&&(o.hidden=!0,o.mapID=t.id),u.liveFilter&&d.bool(u.liveFilter.enabled)&&M&&M!==t.id&&(o.hidden=!0),t.clusterMarkers&&d.bool(t.clusterMarkers.enabled)&&(o.hidden=!0,d.setupClusters(t,e,t.id),p[t.id].zoomLevels[t.clusterMarkers.zoomLevel]=o,!g&&p[t.id].zoomLevels[1]&&(p[t.id].zoomLevels[1].hidden=!1))),Array.isArray(t.iconMarkers)&&t.iconMarkers.length&&(n=iMapsManager.pushIconMarkerSeries(e,t),c[h].push(n),m[t.id].push(n),g&&(n.hidden=!0),u.liveFilter&&d.bool(u.liveFilter.enabled)&&M&&M!==t.id&&(n.hidden=!0)),Array.isArray(t.imageMarkers)&&t.imageMarkers.length&&(l=iMapsManager.pushImageMarkerSeries(e,t),c[h].push(l),m[t.id].push(l),g&&(l.hidden=!0),u.liveFilter&&d.bool(u.liveFilter.enabled)&&M&&M!==t.id&&(l.hidden=!0)),Array.isArray(t.labels)&&t.labels.length&&(i=iMapsManager.pushLabelSeries(e,t),c[h].push(i),m[t.id].push(i),g&&(i.hidden=!0),u.liveFilter&&d.bool(u.liveFilter.enabled)&&M&&M!==t.id&&(i.hidden=!0)))},pushRegionSeries:function(e,t,a){var o,i,r,n,l,s,d,p=this,u=p.maps[e].map,c=t.tooltip||{};a=a||!1;if(t=t||{},o=u.series.push(new am4maps.MapPolygonSeries),"custom"===t.map||p.bool(t.useGeojson)?o.geodataSource.url=t.mapURL:(s=iMapsRouter.getVarByName(t.map),o.geodata=window[s]),o.name=t.regionLegend&&""!==t.regionLegend.title?t.regionLegend.title:t.title,o.hiddenInLegend=!t.regionLegend||!p.bool(t.regionLegend.enabled),e===t.id&&(void 0===p.maps[e].baseSeries&&(p.maps[e].baseSeries=[]),p.maps[e].baseSeries.push(o),p.maps[e].allBaseSeries.push(o)),o.useGeodata=!0,Array.isArray(t.exclude)&&t.exclude.length&&(o.exclude=t.exclude),Array.isArray(t.include)&&t.include.length&&(o.include=t.include),t.heatMapRegions&&p.bool(t.heatMapRegions.enabled)&&p.setupHeatMap(o,e,t),o.data=t.regions,a&&(o.groupHover=!0),i=o.mapPolygons.template,p.setupTooltip(e,o,t),void 0!==t.regionsTooltipTemplate&&""!==t.regionsTooltipTemplate.trim()?(i.tooltipText=t.regionsTooltipTemplate,i.tooltipHTML=t.regionsTooltipTemplate):(i.tooltipText=c.template?c.template:"{tooltipContent}",i.tooltipHTML=c.template?c.template:"{tooltipContent}"),i.adapter.add("tooltipHTML",function(e,t,a){return"object"===_typeof(t.dataItem.dataContext)&&void 0!==c.onlyWithData&&p.bool(c.onlyWithData)&&!0===t.dataItem.dataContext.madeFromGeoData?(t.tooltip.tooltipText=void 0,t.tooltip.tooltipHTML=void 0,""):""===e?e:e.replace(/\\/g,"")}),i.adapter.add("tooltipText",function(e,t,a){return"object"===_typeof(t.dataItem.dataContext)&&void 0!==c.onlyWithData&&p.bool(c.onlyWithData)&&!0===t.dataItem.dataContext.madeFromGeoData?(t.tooltip.tooltipText=void 0,t.tooltip.tooltipHTML=void 0,""):""===e?e:e.replace(/\\/g,"")}),o.fill=t.regionDefaults.fill,i.fill=t.regionDefaults.inactiveColor,i.stroke=t.visual.borderColor,i.strokeWidth=t.visual.borderWidth,i.propertyFields.fill="fill",a||void 0!==t.heatMapRegions&&p.bool(t.heatMapRegions.enabled)&&p.bool(t.heatMapRegions.noHover)||(r=i.states.create("hover"),r.propertyFields.fill="hover"),t.regionActiveState&&p.bool(t.regionActiveState.enabled)&&(n=i.states.create("active"),"custom"===t.regionActiveState.source?n.properties.fill=t.regionActiveState.fill:n.propertyFields.fill="hover"),l=i.states.create("highlight"),l.propertyFields.fill="hover",a?(i.events.on("out",function(t){p.groupHoverOut(e,t)}),i.events.on("over",function(t){p.groupHover(e,t)}),i.events.on("hit",function(t){p.groupHit(e,t)})):(i.events.on("hit",function(t){p.singleHit(e,t)}),i.events.on("over",function(t){p.setupHoverEvents(e,t)})),i.focusable=!1,i.events.on("hit",function(t){p.setupHitEvents(e,t)}),p.bool(t.smallMap)&&u.smallMap.series.push(o),t.regionLabels&&p.bool(t.regionLabels.source)){o.calculateVisualCenter=!0;var m=u.series.push(new am4maps.MapImageSeries),g=m.mapImages.template.createChild(am4core.Label),h="undefined"!=typeof igmLabelsBackground&&igmLabelsBackground;"object"==typeof h&&(g.background=new am4core.RoundedRectangle,g.background.cornerRadius(...h.cornerRadius),g.background.fill=am4core.color(h.color),g.padding(...h.padding),g.background.stroke=am4core.color(h.stroke)),p.maps[e].labelSeries.push(m),g.horizontalCenter=t.regionLabels.horizontalCenter,g.verticalCenter=t.regionLabels.verticalCenter,g.fontSize=t.regionLabels.fontSize,g.fill=t.regionLabels.fill,t.regionLabels.mobileFontSize&&100!==parseInt(t.regionLabels.mobileFontSize)&&window.innerWidth<=780&&(g.fontSize=parseInt(g.fontSize)*parseInt(t.regionLabels.mobileFontSize)/100,g.size=g.fontSize),o.events.on("hidden",function(e){m.hide()}),o.events.on("shown",function(e){m.show()}),g.events.on("hit",function(e){d=o.getPolygonById(e.target.parent.LabelForRegion),d.dispatchImmediately("hit")}),g.events.on("over",function(t){iMapsManager.hover(e,t.target.parent.LabelForRegion,!1)}),g.events.on("out",function(t){iMapsManager.clearHovered(e,t.target.parent.LabelForRegion)}),p.setupTooltip(e,m,t,g),g.interactionsEnabled=!0,g.nonScaling=p.bool(t.regionLabels.nonScaling),m.hiddenInLegend=!0,o.events.on("inited",function(){o.hidden&&(m.hide(),m.hidden=!0)}),p.bool(t.admin)&&(g.draggable=!0,g.cursorOverStyle=am4core.MouseCursorStyle.grab,g.events.on("dragstop",function(e){var a=am4core.utils.spritePointToSvg({x:0,y:0},e.target);a=am4core.utils.spritePointToSvg({x:0-e.target.maxLeft,y:0-e.target.maxTop},e.target);var o,i=u.svgPointToGeo(a),r=document.querySelector("[data-depend-id="+t.regionLabelCustomCoordinates+"]");r&&(o=iMapsManager.isJSON(r.value)?JSON.parse(r.value):{},o[e.target.parent.LabelForRegion]={latitude:i.latitude,longitude:i.longitude},r.value=JSON.stringify(o));u.seriesContainer.draggable=p.bool(t.zoom.draggable),e.target.cursorOverStyle=am4core.MouseCursorStyle.grab}),g.events.on("down",function(e){u.seriesContainer.draggable=!1,e.target.cursorOverStyle=am4core.MouseCursorStyle.grabbing}));var M=!!p.isJSON(t.regionLabels.regionLabelCustomCoordinates)&&JSON.parse(t.regionLabels.regionLabelCustomCoordinates);o.events.on("inited",function(){o.mapPolygons.each(function(e){var a,o=m.mapImages.create();p.bool(t.regionLabels.activeOnly)&&e.dataItem.dataContext&&void 0===e.dataItem.dataContext.tooltipContent||e.dataItem.dataContext.id.includes(",")||("code"===t.regionLabels.source&&(a=e.dataItem.dataContext.id.split("-").pop()),"{name}"===t.regionLabels.source&&(a=e.dataItem.dataContext.name),"{id}"===t.regionLabels.source&&(a=e.dataItem.dataContext.id),"custom"===t.regionLabels.source&&void 0!==t.regionLabels.customSource&&(a=e.dataItem.dataContext.autoLabel),o.LabelForRegion=e.dataItem.dataContext.id,void 0!==e.dataItem.dataContext.originalID&&(o.groupRegion=e.dataItem.dataContext.originalID),o.tooltipDataItem=e.tooltipDataItem,o.tooltip=e.tooltip,o.tooltipHTML=e.tooltipHTML,o.tooltipPosition=p.bool(t.tooltip.fixed)?"fixed":"pointer",e.dataItem.dataContext.action&&"none"!==e.dataItem.dataContext.action&&(o.cursorOverStyle=am4core.MouseCursorStyle.pointer),M&&M.hasOwnProperty(e.dataItem.dataContext.id)?(o.latitude=M[e.dataItem.dataContext.id].latitude,o.longitude=M[e.dataItem.dataContext.id].longitude):(o.latitude=e.visualLatitude,o.longitude=e.visualLongitude),o.children.getIndex(0)&&(o.children.getIndex(0).text=a))})})}return void 0!==t.externalDropdown&&p.bool(t.externalDropdown.enabled)&&(o.calculateVisualCenter=!0),p.maps[e].series.push(o),o},pushRoundMarkerSeries:function(e,t){var a,o,i,r,n,l,s,d=this,p=d.maps[e].map;if(Array.isArray(t.roundMarkers)&&t.roundMarkers.length){if(a=p.series.push(new am4maps.MapImageSeries),a.name=t.roundMarkersLegend&&""!==t.roundMarkersLegend.title?t.roundMarkersLegend.title:t.title,a.hiddenInLegend=!!t.roundMarkersLegend&&!d.bool(t.roundMarkersLegend.enabled),o=a.mapImages.template,i=o.createChild(am4core.Circle),d.setupTooltip(e,a,t,i),o.focusable=!1,i.radius=t.markerDefaults.radius,i.fill=t.markerDefaults.fill,i.stroke=am4core.color("#FFFFFF"),i.strokeWidth=1,i.nonScaling=!0,r=o.createChild(am4core.Label),r.text="{label}",r.fill=am4core.color("#fff"),r.verticalCenter="middle",r.horizontalCenter="middle",r.nonScaling=!0,r.fontSize="undefined"!=typeof igmClusterMarkerFontSize?igmClusterMarkerFontSize:t.markerDefaults.radius,r.clickable=!1,r.focusable=!1,r.hoverable=!1,void 0!==t.roundMarkersTooltipTemplate&&""!==t.roundMarkersTooltipTemplate.trim()?(i.tooltipText=t.roundMarkersTooltipTemplate,i.tooltipHTML=t.roundMarkersTooltipTemplate):(i.tooltipText=t.tooltip&&t.tooltip.template?t.tooltip.template:"{tooltipContent}",i.tooltipHTML=t.tooltip&&t.tooltip.template?t.tooltip.template:"{tooltipContent}"),i.propertyFields.tooltipText="tooltipTemplate",i.propertyFields.tooltipHTML="tooltipTemplate",t.heatMapMarkers&&d.bool(t.heatMapMarkers.enabled)?(d.setupHeatMap(a,e,t),void 0!==t.heatMapMarkers.type&&"range"===t.heatMapMarkers.type&&(i.propertyFields.radius="radius",i.propertyFields.fill="fill")):(i.propertyFields.radius="radius",i.propertyFields.fill="fill"),i.propertyFields.userClassName="customClass",o.propertyFields.radius="radius",o.propertyFields.latitude="latitude",o.propertyFields.longitude="longitude",o.setStateOnChildren=!0,s=i.states.create("hover"),s.properties.fill=t.hover,s.propertyFields.fill="hover",n=i.states.create("active"),n.properties.fill=t.hover,n.propertyFields.fill="hover",l=i.states.create("highlight"),l.properties.fill=t.hover,l.propertyFields.fill="hover",t.roundMarkerLabels&&d.bool(t.roundMarkerLabels.enabled)){var u=o.createChild(am4core.Label);u.text=void 0!==t.roundMarkerLabels.source&&""!==t.roundMarkerLabels.source?t.roundMarkerLabels.source:"{name}",u.horizontalCenter="middle",u.fontSize=t.roundMarkerLabels.fontSize,t.roundMarkerLabels.mobileSize&&100!==parseInt(t.roundMarkerLabels.mobileSize)&&window.innerWidth<=780&&(u.fontSize=parseInt(t.roundMarkerLabels.fontSize)*parseInt(t.roundMarkerLabels.mobileSize)/100),u.nonScaling=!0,u.fill=t.roundMarkerLabels.fill,u.clickable=!1,u.focusable=!1,u.hoverable=!1,u.padding(0,0,0,0),u.propertyFields.paddingTop="radius"}a.data=t.roundMarkers,a.fill=t.markerDefaults.fill,o.events.on("hit",function(t){d.singleHit(e,t),d.setupHitEvents(e,t)}),o.events.on("over",function(t){d.setupHoverEvents(e,t)})}return t.zoom&&t.zoom.smallMap&&d.bool(t.zoom.smallMap)&&p.smallMap.series.push(a),d.maps[e].series.push(a),e===t.id&&(t.clusterMarkers&&!d.bool(t.clusterMarkers.enabled)?d.maps[e].allBaseSeries.push(a):t.clusterMarkers&&d.bool(t.clusterMarkers.enabled)),a},pushImageMarkerSeries:function(e,t){var a,o,i,r=this,n=r.maps[e].map;return Array.isArray(t.imageMarkers)&&t.imageMarkers.length&&(a=n.series.push(new am4maps.MapImageSeries),a.name=t.imageMarkersLegend&&""!==t.imageMarkersLegend.title?t.imageMarkersLegend.title:t.title,a.hiddenInLegend=!!t.imageMarkersLegend&&!r.bool(t.imageMarkersLegend.enabled),o=a.mapImages.template,o.focusable=!1,i=o.createChild(am4core.Image),i.propertyFields.href="href",i.propertyFields.width="size",i.propertyFields.height="size",i.propertyFields.userClassName="customClass",i.propertyFields.horizontalCenter="horizontalCenter",i.propertyFields.verticalCenter="verticalCenter",i.nonScaling=!0,i.propertyFields.nonScaling="nonScaling",r.setupTooltip(e,a,t,i),void 0!==t.imageMarkersTooltipTemplate&&""!==t.imageMarkersTooltipTemplate.trim()?(i.tooltipText=t.imageMarkersTooltipTemplate,i.tooltipHTML=t.imageMarkersTooltipTemplate):(i.tooltipText=t.tooltip.template?t.tooltip.template:"{tooltipContent}",i.tooltipHTML=t.tooltip.template?t.tooltip.template:"{tooltipContent}"),o.propertyFields.latitude="latitude",o.propertyFields.longitude="longitude",a.data=t.imageMarkers,o.events.on("hit",function(t){r.singleHit(e,t),r.setupHitEvents(e,t)}),o.events.on("over",function(t){r.setupHoverEvents(e,t)})),t.zoom&&t.zoom.smallMap&&r.bool(t.zoom.smallMap)&&n.smallMap.series.push(a),r.maps[e].series.push(a),a},pushIconMarkerSeries:function(e,t){var a,o,i,r,n,l,s,d=this,p=d.maps[e].map;if(Array.isArray(t.iconMarkers)&&t.iconMarkers.length){if(a=p.series.push(new am4maps.MapImageSeries),a.hiddenInLegend=!!t.iconMarkersLegend&&!d.bool(t.iconMarkersLegend.enabled),a.name=t.iconMarkersLegend&&""!==t.iconMarkersLegend.title?t.iconMarkersLegend.title:t.title,o=a.mapImages.template,o.nonScaling=!0,o.setStateOnChildren=!0,o.focusable=!1,o.states.create("hover"),i=o.createChild(am4core.Sprite),i.propertyFields.scale="scale",i.propertyFields.path="path",i.propertyFields.rotation="rotation",i.propertyFields.horizontalCenter="horizontalCenter",i.propertyFields.verticalCenter="verticalCenter",i.propertyFields.fill="fill",a.fill=t.iconMarkerDefaults.fill,s=o.createChild(am4core.Sprite),s.propertyFields.scale="scale",s.path="M-10,0a10,10 0 1,0 20,0a10,10 0 1,0 -20,0",s.opacity=0,s.propertyFields.horizontalCenter="horizontalCenter",s.propertyFields.verticalCenter="verticalCenter",s.tooltipText=t.tooltip.template?t.tooltip.template:"{tooltipContent}",s.tooltipHTML=t.tooltip.template?t.tooltip.template:"{tooltipContent}",d.setupTooltip(e,a,t,s),t.iconMarkerLabels&&d.bool(t.iconMarkerLabels.enabled)){var u=o.createChild(am4core.Label);u.text=void 0!==t.iconMarkerLabels.source&&""!==t.iconMarkerLabels.source?t.iconMarkerLabels.source:"{name}",u.horizontalCenter="middle",u.verticalCenter="top",u.fontSize=t.iconMarkerLabels.fontSize,u.nonScaling=!1,u.fill=t.iconMarkerLabels.fill,u.clickable=!1,u.focusable=!1,u.hoverable=!1,u.padding(0,0,0,0),u.adapter.add("dy",function(e,t){var a,o=t.parent.children.getIndex(0),i=o.scale;return"middle"===o.verticalCenter&&(a=10*i),"bottom"===o.verticalCenter&&(a=0),"top"===o.verticalCenter&&(a=20*i+5),a})}r=i.states.create("hover"),r.propertyFields.fill="hover",n=i.states.create("active"),n.propertyFields.fill="hover",l=i.states.create("highlight"),l.properties.fill=t.hover,l.propertyFields.fill="hover",o.propertyFields.latitude="latitude",o.propertyFields.longitude="longitude",a.data=t.iconMarkers,o.events.on("hit",function(t){d.singleHit(e,t),d.setupHitEvents(e,t)}),o.events.on("over",function(t){d.setupHoverEvents(e,t)})}return t.zoom&&t.zoom.smallMap&&d.bool(t.zoom.smallMap)&&p.smallMap.series.push(a),d.maps[e].series.push(a),a},pushLineSeries:function(e,t){var a=this,o=a.maps[e].map,i={},r=[];return Array.isArray(t.lines)&&t.lines.length&&("Orthographic"===t.projection?(i=o.series.push(new am4maps.MapLineSeries),i.mapLines.template.propertyFields.shortestDistance=!0):(i=o.series.push(new am4maps.MapArcSeries),i.mapLines.template.line.propertyFields.controlPointDistance="curvature",i.mapLines.template.line.controlPointPosition=.5),i.name=t.linesLegend&&""!==t.linesLegend.title?t.linesLegend.title:t.title,i.hiddenInLegend=!!t.linesLegend&&!a.bool(t.linesLegend.enabled),i.mapLines.template.nonScalingStroke=!0,i.mapLines.template.propertyFields.strokeWidth="strokeWidth",i.mapLines.template.propertyFields.strokeDasharray="strokeDash",i.mapLines.template.propertyFields.stroke="stroke",t.lines.forEach(function(e){e.multiGeoLine=[e.multiGeoLine],r.push(e)}),i.mapLines.template.events.on("hit",function(t){a.singleHit(e,t),a.setupHitEvents(e,t)}),i.mapLines.template.events.on("over",function(t){a.setupHoverEvents(e,t)}),i.data=r,t.zoom&&t.zoom.smallMap&&a.bool(t.zoom.smallMap)&&o.smallMap.series.push(i),a.maps[e].series.push(i),i.fill=t.lineDefaults.stroke,e===t.id&&a.maps[e].allBaseSeries.push(i)),i},createArrow:function(e,t){var a=e.createChild(am4maps.MapLineObject);a.shouldClone=!1,a.width=8,a.height=10,a.mapLine=e,a.position=.5,a.adjustRotation=!0;var o=a.createChild(am4core.Triangle);return o.fillOpacity=1,o.width=am4core.percent(100),o.height=am4core.percent(100),o.rotation=90,o.horizontalCenter="middle",o.verticalCenter="middle",t&&(o.direction="bottom"),a},pushLabelSeries:function(e,t){var a,o,i,r,n,l,s=this,d=s.maps[e].map,p=!1;return Array.isArray(t.labels)&&t.labels.length&&(a=d.series.push(new am4maps.MapImageSeries),a.name=t.roundMarkersLegend&&""!==t.roundMarkersLegend.title?t.roundMarkersLegend.title:t.title,a.hiddenInLegend=!!t.roundMarkersLegend&&!s.bool(t.roundMarkersLegend.enabled),o=a.mapImages.template,o.setStateOnChildren=!0,i=o.createChild(am4core.Label),i.text="{id}",i.nonScaling=!0,t.labelStyle&&(i.fontFamily=t.labelStyle.fontFamily,i.fontWeight=t.labelStyle.fontWeight),i.horizontalCenter=t.labelPosition.horizontalCenter,i.verticalCenter=t.labelPosition.verticalCenter,i.propertyFields.fill="fill",i.propertyFields.fontSize="fontSize",s.setupTooltip(e,a,t,i),void 0!==t.labelsTooltipTemplate&&""!==t.labelsTooltipTemplate.trim()?(i.tooltipText=t.labelsTooltipTemplate,i.tooltipHTML=t.labelsTooltipTemplate):(i.tooltipText=t.tooltip&&t.tooltip.template?t.tooltip.template:"{tooltipContent}",i.tooltipHTML=t.tooltip&&t.tooltip.template?t.tooltip.template:"{tooltipContent}"),o.propertyFields.latitude="latitude",o.propertyFields.longitude="longitude",o.propertyFields.fill="fill",o.propertyFields.fontSize="fontSize",i.propertyFields.verticalCenter="verticalCenter",i.propertyFields.horizontalCenter="horizontalCenter",p="undefined"!=typeof igmLabelsBackground&&igmLabelsBackground,"object"==typeof p&&(i.background=new am4core.RoundedRectangle,i.background.cornerRadius(...p.cornerRadius),i.background.fill=am4core.color(p.color),i.padding(...p.padding),i.background.stroke=am4core.color(p.stroke)),l=i.states.create("hover"),l.properties.fill=t.hover,l.propertyFields.fill="hover",r=i.states.create("active"),r.properties.fill=t.hover,r.propertyFields.fill="hover",n=i.states.create("highlight"),n.properties.fill=t.hover,n.propertyFields.fill="hover",a.data=t.labels,a.fill=t.labelDefaults.fill,o.events.on("hit",function(t){s.singleHit(e,t),s.setupHitEvents(e,t)}),o.events.on("over",function(t){s.setupHoverEvents(e,t)})),t.zoom&&t.zoom.smallMap&&s.bool(t.zoom.smallMap)&&d.smallMap.series.push(a),s.maps[e].labelSeries.push(a),s.maps[e].series.push(a),e===t.id&&s.maps[e].allBaseSeries.push(a),a},setupTooltip:function(e,t,a,o){var i,r=this,n=a.tooltip,l=r.maps[e].map;return o=o||!1,void 0===a.tooltip?(t.tooltip.disabled=!1,t.tooltip.getFillFromObject=!1,t.tooltip.getStrokeFromObject=!1,t.tooltip.label.fill=am4core.color("#000000"),void(t.tooltip.background.fill=am4core.color("#FFFFFF"))):r.bool(a.tooltip.enabled)?void 0!==_typeof(a.tooltip.disableMobile)&&r.bool(a.tooltip.disableMobile)&&window.innerWidth<=780?(t.tooltip.disabled=!0,t):(t.tooltip.label.interactionsEnabled=r.bool(n.fixed),t.tooltip.background.cornerRadius=n.cornerRadius,n.pointerLength&&(t.tooltip.background.pointerLength=parseInt(n.pointerLength)),t.tooltip.getFillFromObject=!1,t.tooltip.getStrokeFromObject=!1,t.tooltip.label.fill=n.color,t.tooltip.background.fill=n.backgroundColor,t.tooltip.fontFamily=n.fontFamily,t.tooltip.fontSize=n.fontSize,t.tooltip.fontWeight=n.fontWeight,t.tooltip.animationDuration=0,"undefined"!==n.borderColor&&(t.tooltip.background.stroke=n.borderColor,t.tooltip.background.strokeWidth=n.borderWidth),void 0!==n.maxWidth&&""!==n.maxWidth&&(t.tooltip.maxWidth=parseInt(n.maxWidth),t.tooltip.contentWidth=parseInt(n.maxWidth)),void 0!==n.customShadow&&r.bool(n.customShadow)&&(i=t.tooltip.background.filters.getIndex(0),i.dx=n.customShadowOpts.dx,i.dy=n.customShadowOpts.dy,i.blur=n.customShadowOpts.blur,i.opacity=n.customShadowOpts.opacity,i.color=n.customShadowOpts.color),r.bool(n.fixed)&&(t.mapPolygons?(t.calculateVisualCenter=!0,t.mapPolygons.template.tooltipPosition="fixed",t.groupHover&&(t.tooltip.getFillFromObject=!1,t.tooltip.events.on("over",function(e){e.target.dataItem.component.mapPolygons.each(function(e){e.setState("highlight")})}),t.tooltip.events.on("out",function(e){e.target.dataItem.component.mapPolygons.each(function(e){e.setState("default")})})),t.tooltip.keepTargetHover=!0,n.showTooltipOn&&(t.mapPolygons.template.showTooltipOn=n.showTooltipOn,"hit"===n.showTooltipOn&&(t.tooltip.keepTargetHover=!1))):(t.mapImages.template.tooltipPosition="fixed",t.tooltip.keepTargetHover=!0,n.showTooltipOn&&o&&(t.mapImages.template.showTooltipOn=n.showTooltipOn,o.showTooltipOn=n.showTooltipOn,"hit"===n.showTooltipOn&&(t.tooltip.keepTargetHover=!1),"always"===n.showTooltipOn&&(l.events.on("appeared",function(){o.clones.each(function(e){e.showTooltip()})}),l.events.on("mappositionchanged",function(e){o.clones.each(function(e){e.showTooltip()})}))))),t):(t.tooltip.disabled=!0,t)},parseHtmlEntities:function(e){return"string"!=typeof e?e:(e=e.replace(/&amp;/gi,"&"),e.replace(/&#(\d+);/g,function(e,t){return String.fromCharCode(t)}))},setupHitEvents:function(e,t){var a,o,i,r,n=this,l=n.maps[e].data,s=n.maps[e].map,d=n.getTargetSeriesType(t.target),p=n.maps[e].clicked||!1,u=l.clusterMarkers?parseFloat(l.clusterMarkers.zoomLevel):1;if(a=t.target.isLabels?t.target.dataItems.first.dataContext:t.target.dataItem.dataContext,"MapImage"===d&&a.cluster&&(u-parseInt(s.zoomLevel)>5&&(u=parseInt(s.zoomLevel)+u/2),t.target.series.chart.zoomToMapObject(t.target,u)),n.populateClickInfo(a),console.log(a),l.zoom&&n.bool(l.zoom.enabled)&&n.bool(l.zoom.zoomOnClick)&&(t.zooming=!0,n.zoomToRegion(t,e)),"MapPolygon"===d&&n.bool(l.drillDownOnClick)&&n.drillDown(e,t),a.madeFromGeoData)return r="igm_inactive_"+l.id,void("function"==typeof window[r]&&(l=window[r](l)));if("MapImage"===d&&void 0!==_typeof(a.action)&&"igm_display_map"===a.action&&Array.isArray(iMapsManager.maps[e].seriesById[parseInt(a.content)])&&(i=iMapsManager.maps[e].seriesById[parseInt(a.content)],n.drillTo(e,t,i,!0)),!n.bool(l.admin)){if(l.tooltip&&void 0!==_typeof(l.tooltip.enabled)&&n.bool(l.tooltip.enabled)&&void 0!==_typeof(l.tooltip.disableMobile)&&!n.bool(l.tooltip.disableMobile)&&void 0!==_typeof(l.tooltip.holdAction)&&n.bool(l.tooltip.holdAction)&&window.innerWidth<=780){if(!p||p!=a)return console.log("Holding action for second tap."),void(n.maps[e].clicked=a);n.maps[e].clicked=p!==a&&a}"none"===a.action||("open_url"===a.action&&""!==a.content?(a.content=iMapsManager.parseHtmlEntities(a.content),document.location=a.content):"open_url_new"===a.action&&""!==a.content?(a.content=iMapsManager.parseHtmlEntities(a.content),window.open(a.content)):a.action&&a.action.includes("custom")?(o=a.action+"_"+a.mapID,void 0!==window[o]&&window[o](a)):void 0!==window[a.action]&&window[a.action](e,a))}},zoomToMap:function(e,t,a){var o=this,i=!1;if(t.forEach(function(e){"MapPolygonSeries"!=o.getTargetSeriesType(e)||(i=e)}),i)return e.target.series.chart.zoomToRectangle(i.north,i.east,i.south,i.west,1,!0),void console.log("zoomed to specific map");console.log("failed to zoom to specific map")},zoomToRegion:function(e,t){var a,o,i=this,r=i.getTargetSeriesType(e.target),n=i.maps[t].data;i.maps[t].map;e.target.isLabels||(o=e.target.dataItem.dataContext,"MapImage"==r?o.cluster||(a="undefined"!=typeof igmMarkerZoomLevelOnClick?igmMarkerZoomLevelOnClick:2*e.target.parent.chart.zoomLevel,e.target.series.chart.zoomToMapObject(e.target,a,!0)):"asia"===o.id?(e.target.series.chart.deltaLongitudeOriginal=e.target.series.chart.deltaLongitude,e.target.series.chart.deltaLongitude=-10,e.target.series.chart.zoomToGeoPoint({latitude:34.076842,longitude:100.693068},1.7,!0)):"northAmerica"===o.id&&n.map.startsWith("region/world/worldRegion")?e.target.series.chart.zoomToGeoPoint({latitude:55.5,longitude:-105.5},3,!0):"ZA"===o.id&&n.map.startsWith("world")?e.target.series.chart.zoomToGeoPoint({latitude:-28.6,longitude:24.7},12.2,!0):(void 0!==e.target.series.chart.deltaLongitudeOriginal&&(e.target.series.chart.deltaLongitude=e.target.series.chart.deltaLongitude),e.target.series.chart.zoomToMapObject(e.target,2*e.target.zoomLevel)))},setupHoverEvents:function(e,t){var a,o=this,i=o.maps[e].selected||!1;a=t.target.isLabels?t.target.dataItems.first.dataContext:t.target.dataItem.dataContext,"MapImage"!==t.target.className&&"fixed"===t.target.tooltipPosition&&(Array.isArray(o.tempHover)&&o.tempHover.length>=0&&(o.tempHover[0].setState("default"),o.tempHover=[]),o.tempHover=[t.target]),a.action&&"none"!==a.action&&(t.target.cursorOverStyle=am4core.MouseCursorStyle.pointer),Array.isArray(i)&&!i.includes(t.target)&&t.target.dataItem&&void 0===t.target.dataItem.dataContext.madeFromGeoData&&i.forEach(function(e,t){"object"==typeof e&&void 0!==e.isHover&&(e.isHover=!1)}),!o.bool(a.triggerClickOnHover)||iMapsManager.isTouchScreendevice()&&"over"!==t.type||void 0!==iMaps.maps[e].mapClicked&&!1!==iMaps.maps[e].mapClicked||iMapsManager.select(e,a.id,!1,!0,a.mapID,!1),o.bool(a.triggerRegionHover)&&a.val&&""!==a.val&&(iMapsManager.hover(e,a.val),t.target.events.on("out",function(t){iMapsManager.clearHovered(e)}))},singleHit:function(e,t){var a,o=this;a=t.target.isLabels?t.target.dataItems.first.dataContext:t.target.dataItem.dataContext,a.madeFromGeoData||(!0===iMaps.maps[e].activeStateControl&&a.activeState&&(iMaps.maps[e].mapClicked=!0),iMapsManager.clearSelected(e,t.target,!0),t.target.isActive=!0,t.target.isHover=!0,t.target.setState("active"),o.maps[e].selected=[t.target])},groupHit:function(e,t){var a=this,o=a.maps[e].selected||!1;console.log("group hit"),t.target.dataItem.dataContext.madeFromGeoData||(!0===iMaps.maps[e].activeStateControl&&t.target.dataItem.dataContext.activeState&&(iMaps.maps[e].mapClicked=!0),iMapsManager.clearSelected(e),o=[],t.target.parent.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||void 0!==e.dataItem.dataContext.originalID||(e.setState("active"),e.isActive=!0,e.isGroupActive=!0,e.isHover=!0,o.push(e))}),a.maps[e].selected=o)},groupHover:function(e,t){var a,o=this;a=t.target.isLabels?t.target.dataItems.first.dataContext:t.target.dataItem.dataContext,t.target.dataItem.dataContext.madeFromGeoData||(!o.bool(a.triggerClickOnHover)||void 0!==iMaps.maps[e].mapClicked&&!1!==iMaps.maps[e].mapClicked||iMapsManager.select(e,a.id,!1,!0,a.mapID,!1),t.target.dataItem.dataContext.action&&"none"!=t.target.dataItem.dataContext.action&&(t.target.cursorOverStyle=am4core.MouseCursorStyle.pointer),t.target.parent.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||e.isActive||e.setState("highlight")}))},groupHoverOut:function(e,t){t.target.dataItem.dataContext.madeFromGeoData||t.target.parent.mapPolygons.each(function(e){e.isGroupActive||(e.setState("default"),e.isActive=!1,e.isHover=!1)})},getRegionsByValue:function(e,t,a){var o=this,i=o.maps[e],r=i.series,n=!1,l=[];return t=t||"*",a=a||"val",r.forEach(function(e){n=o.getTargetSeriesType(e),"MapPolygonSeries"===n&&(e.mapImages.values.filter(function(e){if(e.dataItem.dataContext[a]===t||"*"===t)return!0}),l=l.concat(l))}),l},getMarkersByValue:function(e,t,a){var o,i=this,r=i.maps[e],n=r.series,l=!1,s=[];return t=t||"*",a=a||"val",n.forEach(function(e){l=i.getTargetSeriesType(e),"MapImageSeries"===l&&(o=e.mapImages.values.filter(function(e){if(e.dataItem.dataContext[a]===t||"*"===t)return!0}),s=s.concat(o))}),s},select:function(e,t,a,o,i,r){var n,l,s,d,p=this,u=p.maps[e],c=p.maps[e].data,m=u.series,g=[],h=iMaps.maps[e].seriesById,M=!1,v=!0,f=!1;if(Number.isInteger(t)&&(t=t.toString()),t,void 0===a&&(a=!0),void 0===o&&(o=!0),void 0===i&&(i=e),h.hasOwnProperty(i)&&(M=h[i]),r=void 0===r,iMapsManager.clearSelected(e,!0,!r),iMaps.maps[e].activeStateControl=!!r,M&&(m=M),Array.isArray(m))for(var b=0,y=m.length;b<y&&!f;b++)if(void 0===m[b].isCluster||!m[b].isCluster){if(m[b].mapPolygons)if(n=m[b].getPolygonById(t),n&&void 0!==n.dataItem.dataContext.originalID&&n.dataItem.dataContext.originalID.includes(",")&&(t=n.dataItem.dataContext.originalID),t.includes(","))void 0!==n&&n&&(n.tooltip=!1,n.dispatchImmediately("hit"),
n.hideTooltip(),v=!1,iMaps.maps[e].activeStateControl=!0),l=t.split(","),l.forEach(function(i,r){if(n=m[b].getPolygonById(i.trim()),void 0!==n&&n){if(n.dataItem.dataContext.madeFromGeoData)return;if(n.dataItem.dataContext.originalID!==t&&!v)return;0===r&&o&&(f=!0,a?(s=void 0!==n&&void 0!==n.tooltipPosition?n.tooltipPosition:"hover",n.tooltipPosition="fixed",d=n.showTooltipOn,n.showTooltipOn="always",iMaps.maps[e].activeStateControl=!0,n.tooltipPosition=s,n.showTooltipOn=d):n.isHover=!0),c.regionActiveState&&p.bool(c.regionActiveState.enabled)?n.setState("active"):n.setState("highlight"),g.push(n)}});else if(n=m[b].getPolygonById(t),void 0!==n&&n){let t=0;if("Orthographic"===c.projection){let a=iMaps.maps[e].map;a.animate({property:"deltaLongitude",to:-n.longitude},500,am4core.ease.linear),a.animate({property:"deltaLatitude",to:-n.latitude},550,am4core.ease.linear),t=550}setTimeout(function(e){console.log(e.dataItem.dataContext),a&&e.dataItem.dataContext&&"igm_display_map"!==e.dataItem.dataContext.action?(s=void 0!==e&&void 0!==e.tooltipPosition?e.tooltipPosition:"hover",e.tooltipPosition="fixed",d=e.showTooltipOn,e.showTooltipOn="always",e.dispatchImmediately("hit"),f=!0,e.tooltipPosition=s,e.showTooltipOn=d,g.push(e)):e.dataItem.dataContext&&"igm_display_map"===e.dataItem.dataContext.action?(e.dispatchImmediately("hit"),e.hideTooltip(),f=!0,g.push(e)):(e.dispatchImmediately("hit"),f=!0,g.push(e))},t,n)}if(m[b].mapImages)if(t.includes(","))l=t.split(","),l.forEach(function(e,t){n=m[b].getImageById(e),void 0!==n&&n&&(a?(d=n.showTooltipOn,n.showTooltipOn="always",s=void 0!==n.tooltipPosition?n.tooltipPosition:"hover",n.tooltipPosition="fixed",n.dispatchImmediately("hit"),f=!0,n.tooltipPosition=s,n.showTooltipOn=d,g.push(n)):(n.dispatchImmediately("hit"),f=!0,g.push(n)))});else{let o=m[b].getImageById(t);if(o){let t=0;if("Orthographic"===c.projection){let a=iMaps.maps[e].map;a.animate({property:"deltaLongitude",to:-o.longitude},500,am4core.ease.linear),a.animate({property:"deltaLatitude",to:-o.latitude},550,am4core.ease.linear),t=550}setTimeout(function(){a?(s=o.tooltipPosition,d=o.showTooltipOn,o.tooltipPosition="fixed",o.showTooltipOn="always",o.isHover=!0,o.isActive=!0,o.dispatchImmediately("hit"),o.setState("active"),o.children.each(function(e){e.showTooltip(0)}),f=!0,o.tooltipPosition=s,o.showTooltipOn=d,g.push(o)):(o.dispatchImmediately("hit"),f=!0,g.push(o))},t)}}}return p.maps[e].selected=g,n},setupRangeHeatMap:function(e,t,a){var o,i=this,r=a.regions,n=a.roundMarkers,l=i.getTargetSeriesType(e);if("MapImageSeries"===l){if(!Array.isArray(a.heatMapMarkers.range)||0===a.heatMapMarkers.range.length)return;o=a.heatMapMarkers.range.slice(0),o.sort(function(e,t){if(isNaN(e.rule)){var a=e.rule.toLowerCase(),o=t.rule.toLowerCase();return a<o?-1:a>o?1:0}return parseFloat(e.rule)-parseFloat(t.rule)}),Array.isArray(n)&&n.length>0&&n.forEach(function(e,t){if(void 0!==e[a.heatMapMarkers.source]){"value"===a.heatMapMarkers.source&&(a.heatMapMarkers.source="val");var i,r=e[a.heatMapMarkers.source];isNaN(r)||(r=parseFloat(r)),o.forEach(function(t,a){isNaN(t.rule)?(i=t.rule.trim(),r==i&&(e.fill=t.fill,e.radius=parseFloat(t.radius))):(i=parseFloat(t.rule),r>=i&&(e.fill=t.fill,e.radius=parseFloat(t.radius)))})}})}else if("MapPolygonSeries"===l){if(!Array.isArray(a.heatMapRegions.range)||0===a.heatMapRegions.range.length)return;o=a.heatMapRegions.range.slice(0),o.sort(function(e,t){if(isNaN(e.rule)){var a=e.rule.toLowerCase(),o=t.rule.toLowerCase();return a<o?-1:a>o?1:0}return parseFloat(e.rule)-parseFloat(t.rule)}),Array.isArray(r)&&r.length>0&&(isNaN(a.heatMapRegions.source)||(a.heatMapRegions.source=parseInt(a.heatMapRegions.source)),r.forEach(function(e,t){if(void 0!==e[a.heatMapRegions.source]){"value"===a.heatMapRegions.source&&(a.heatMapRegions.source="val");var i,r=e[a.heatMapRegions.source];isNaN(r)||(r=parseFloat(r)),o.forEach(function(t,a){isNaN(t.rule)?(i=t.rule.trim(),r==i&&(e.fill=t.fill)):(i=parseFloat(t.rule),r>=i&&(e.fill=t.fill))})}}))}},setupHeatMap:function(e,t,a){var o,i,r,n,l,s,d,p,u,c,m=this,g=m.maps[t].map,h=m.getTargetSeriesType(e);if("MapImageSeries"===h){if(void 0!==a.heatMapMarkers.type&&"range"===a.heatMapMarkers.type)return void m.setupRangeHeatMap(e,a.id,a);s=e.mapImages.template.children.values[0],u=["fill","radius"],c=a.heatMapMarkers}else{if("MapPolygonSeries"!==h)return;if(void 0!==a.heatMapRegions.type&&"range"===a.heatMapRegions.type)return void m.setupRangeHeatMap(e,a.id,a);s=e.mapPolygons.template,u=["fill"],c=a.heatMapRegions}e.dataFields.value=c.source,Array.isArray(u)||(u=[u]),u.map(function(t){"fill"===t?(d=c.minColor,p=c.maxColor):"radius"===t&&(d=c.minRadius,p=c.maxRadius),e.heatRules.push({property:t,target:s,min:d,max:p})}),m.bool(c.legend)&&(r=g.createChild(am4core.Container),r.align=void 0!==c.legendAlign?c.legendAlign:"right",r.valign=void 0!==c.legendValign?c.legendValign:"bottom",r.userClassName="mapLegendContainer",r.marginRight=am4core.percent(4),window.innerWidth<=780?r.width=am4core.percent(40):r.width=am4core.percent(25),void 0!==c.label&&""!==c.label&&(i=r.createChild(am4core.Label),i.text=c.label,i.horizontalCenter="left",i.verticalCenter="top",i.fontSize=12,i.paddingBottom=40,window.innerWidth<=780?(i.fontSize=10,i.paddingBottom=48):(i.fontSize=12,i.paddingBottom=48),i.nonScaling=!1,i.clickable=!1,i.focusable=!1,i.hoverable=!1),o=r.createChild(am4maps.HeatLegend),o.series=e,o.align="right",o.valign="bottom",o.width=am4core.percent(100),o.minValue=0,o.maxValue=99999999999999,n=o.valueAxis.axisRanges.create(),n.value=o.minValue,n.label.text=c.minLabel,l=o.valueAxis.axisRanges.create(),l.value=o.maxValue,l.label.text=c.maxLabel,n.label.fontSize=12,l.label.fontSize=12,window.innerWidth<=780?(n.label.fontSize=10,l.label.fontSize=10):(n.label.fontSize=12,l.label.fontSize=12),o.valueAxis.renderer.labels.template.adapter.add("text",function(){return""}))},drillTo:function(e,t,a,o){var i,r,n,l=iMapsManager,s=(l.maps[e].map,l.maps[e].data),d=iMapsManager.maps[e].series,p=iMapsManager.maps[e].baseSeries,u=iMapsManager.maps[e].allBaseSeries;for(i="undefined"!=typeof igmDrilldownBaseMapOpacity?igmDrilldownBaseMapOpacity:.3,o=o||!1,r=0,n=d.length;r<n;r++)p.includes(d[r])?void 0!==s.alwaysKeepBase&&l.bool(s.alwaysKeepBase)||(d[r].opacity=i):u.includes(d[r])&&void 0!==s.alwaysKeepBase&&l.bool(s.alwaysKeepBase)||d[r].hide();for(r=0,n=a.length;r<n;r++)a[r].show();if(iMapsManager.maps[e].isDrilling=!0,!t.zooming){if(o)return console.log("drill to specific map"),void l.zoomToMap(t,a,e);l.zoomToRegion(t,e)}},drillDown:function(e,t){var a,o,i,r=iMapsRouter.iso2cleanName(t.target.dataItem.dataContext.id,e),n=t.target.dataItem.dataContext.id,l=iMapsManager.maps[e].series,s=t.target.dataItem.dataContext,d=!1,p=iMapsManager.maps[e].baseSeries,u=iMapsManager.maps[e].allBaseSeries,c=[],m=!1;if(console.log("Map Name:",r),console.log("Available Series:",iMapsManager.maps[e].seriesIndex),console.log("Available Series by ID: ",iMapsManager.maps[e].seriesById),!(r&&isNaN(n)||void 0!==_typeof(s)&&"igm_display_map"==s.action))return!1;if(t.target.polygon)if(c.push(r),c.forEach(function(t){void 0!==_typeof(s)&&"igm_display_map"==s.action?(console.log("Display custom map "+s.content),Array.isArray(iMapsManager.maps[e].seriesById[parseInt(s.content)])&&(m=!0,a=iMapsManager.maps[e].seriesById[parseInt(s.content)],d=!0)):Array.isArray(iMapsManager.maps[e].seriesIndex[t])&&(m=!0,a=iMapsManager.maps[e].seriesIndex[t])}),m)iMapsManager.drillTo(e,t,a,d),iMapsManager.maps[e].drilledTo=a[0].mapID;else{if(a===t.target.series)return void(iMapsManager.maps[e].isDrilling=!1);if(p.includes(t.target.series))for(iMapsManager.maps[e].isDrilling=!1,iMapsManager.maps[e].drilledTo=!1,o=0,i=l.length;o<i;o++)u.includes(l[o])?l[o].show():l[o].hide()}},getSelected:function(e){var t=this,a=t.maps[e],o=a.selected||!1,i=[];return!!o&&(Array.isArray(o)?(o.forEach(function(e){i.push(e.dataItem.dataContext)}),i):o.dataItem.dataContext)},getHovered:function(e){var t=this,a=t.maps[e],o=a.hovered||!1,i=[];return!!o&&(Array.isArray(o)?(o.forEach(function(e){i.push(e.dataItem.dataContext)}),i):void 0)},getHighlighted:function(e){var t=this,a=t.maps[e],o=a.highlighted||!1,i=[];return!!o&&(Array.isArray(o)?(o.forEach(function(e){i.push(e.dataItem.dataContext)}),i):o.dataItem.dataContext)},clearSelected:function(e,t,a){var o=this,i=o.maps[e],r=i.selected||[];return t=t||!1,a=a||!1,Array.isArray(r)&&r.length>0&&(r.forEach(function(e,a){e!==t&&"object"==typeof e&&void 0!==e.isHover&&(e.isHover=!1,e.isActive=!1,e.isGroupActive=!1,t||e.hideTooltip(0),e.setState("default"))}),r=[]),t||"undefined"==typeof iMapsActions?i.selected=[t]:i.selected=[],i.selected},clearHighlighted:function(e){var t=this,a=t.maps[e],o=a.highlighted||[];return Array.isArray(o)&&o.length>0&&(o.forEach(function(e,t){e.isHover=!1,e.isActive=!1,e.setState("default")}),o=[]),o},hover:function(e,t,a){var o,i,r,n,l=this,s=l.maps[e],d=(s.data,s.series),p=s.hovered||[];if(Number.isInteger(t)&&(t=t.toString()),void 0===a&&(a=!0),iMapsManager.clearHovered(e),p=[],Array.isArray(d))for(var u=0,c=d.length;u<c;u++)d[u].mapPolygons&&(t.includes(",")?(i=t.split(","),i.forEach(function(e,t){o=d[u].getPolygonById(e.trim()),o&&(a?(n=void 0!==o.tooltipPosition?o.tooltipPosition:"fixed",r=void 0!==o.showTooltipOn?o.showTooltipOn:"hover",o.tooltipPosition="fixed",o.showTooltipOn="always",p.push(o),o.dispatchImmediately("over"),o.isHover=!0,o.tooltipPosition=n,o.showTooltipOn=r):(p.push(o),o.dispatchImmediately("over"),o.isHover=!0))})):(o=d[u].getPolygonById(t),o&&(a?(n=o.tooltipPosition,o.tooltipPosition="fixed",p=[o],o.dispatchImmediately("over"),o.isHover=!0,o.tooltipPosition=n):(p=[o],o.dispatchImmediately("over"),o.isHover=!0)))),d[u].mapImages&&(t.includes(",")?(i=t.split(","),i.forEach(function(e,t){o=d[u].getImageById(e),o&&(a?(n=o.tooltipPosition,r=o.showTooltipOn,o.tooltipPosition="fixed",o.showTooltipOn="always",p=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover"),o.children.each(function(e){"Circle"===e.className&&e.showTooltip(0)}),o.tooltipPosition=n,o.showTooltipOn=r):(p=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover")))})):(o=d[u].getImageById(t),o&&(a?(n=o.tooltipPosition,o.tooltipPosition="fixed",p=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover"),o.children.each(function(e){"Circle"===e.className&&e.showTooltip(0)}),o.tooltipPosition=n):(p=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover")))));return s.hovered=p,o},clearHovered:function(e,t){var a,o=this,i=o.maps[e],r=i.hovered||!1,n=i.series;if(t=t||!1,t){if(Array.isArray(n))for(var l=0,s=n.length;l<s;l++)n[l].mapPolygons&&(a=n[l].getPolygonById(t),a&&(a.dispatchImmediately("out"),a.isHover=!1)),n[l].mapImages&&(a=n[l].getImageById(t),a&&(a.isHover=!1,a.setState("default"),a.dispatchImmediately("out")))}else if(r)return r.forEach(function(e){e.dispatchImmediately("out"),e.setState("default"),e.isHover=!1,void 0!==e.children&&e.children.each(function(e){"Circle"===e.className&&e.hideTooltip(0)})}),i.hovered=[],!0;return!1},highlight:function(e,t){var a,o,i=this,r=i.maps[e],n=r.series,l=r.highlighted||[];if(Number.isInteger(t)&&(t=t.toString()),Array.isArray(n))for(var s=0,d=n.length;s<d;s++)n[s].mapPolygons&&(t.includes(",")?(o=t.split(","),o.forEach(function(e,t){if(a=n[s].getPolygonById(e.trim()),void 0!==a&&a){if(a.dataItem.dataContext.madeFromGeoData)return;a.setState("highlight"),l.push(a)}})):(a=n[s].getPolygonById(t),void 0!==a&&a&&(a.setState("highlight"),l.push(a)))),n[s].mapImages&&(t.includes(",")?(o=t.split(","),o.forEach(function(e,t){a=n[s].getImageById(e),void 0!==a&&a&&(a.setStateOnChildren=!0,a.setState("highlight"),l.push(a))})):(a=n[s].getImageById(t),void 0!==a&&a&&(a.setStateOnChildren=!0,a.setState("highlight"),l.push(a))));return r.highlighted=l,a},getTargetSeriesType:function(e){var t=e.className;return t},setupClusters:function(e,t,a){var o,i=this,r=i.maps[t],n=[],l={},s=[],d=[],p=4,u=0,c=parseFloat(e.clusterMarkers.maxBias),m=parseFloat(e.clusterMarkers.zoomLevel)||20,g=void 0!==e.clusterMarkers.tooltipTemplate&&e.clusterMarkers.tooltipTemplate;a=a||!1;for(var h=a||t;u<=p;)s.push(c),c/=2,d.push(m),m=3==u?1:Math.ceil(m/2),u++;return d.reverse().pop(),s.pop(),void 0===r.clusterSeries[h]&&(r.clusterSeries[h]={zoomLevels:{},overlay:a}),Array.isArray(e.roundMarkers)&&s.forEach(function(a,s){n=geocluster(e.roundMarkers,a,e.markerDefaults,g),l=Object.assign({},e),l.roundMarkers=n,o=i.pushRoundMarkerSeries(t,l),o.name=l.title||"Map",o.hiddenInLegend=!0,o.isCluster=!0,r.clusterSeries[h].zoomLevels[d[s]]=o,o.hidden=!0}),!0},triggerOnReady:function(e,t){let a="custom"==t.map,o=new URLSearchParams(window.location.search),i=o.get("mregion");i&&(a||iMapsManager.select(e,i))},triggerOnAppeared:function(e,t){let a="custom"==t.map,o=new URLSearchParams(window.location.search),i=o.get("mregion");i&&a&&setTimeout(function(){iMapsManager.select(e,i)},500)},addGeoFileSeries:function(e,t,a){var o,i=iMapsRouter.getGeoFiles(t),r=new Promise(function(e,t){var a=document.createElement("script");document.body.appendChild(a),a.onload=e,a.onerror=t,a.async=!0,a.src=i.src});return r.then(function(){var t={title:i.title,map:i.map,regions:[],config:t};return iMapsManager.maps[e].seriesIndex[i.map]=[],o=iMapsManager.pushRegionSeries(e,t),iMapsManager.maps[e].seriesIndex[i.map].push(o),o}),!1},handleInfoBox:function(e){var t=this,a=t.maps[e].map,o=["ready","mappositionchanged","zoomlevelchanged"],i=document.getElementById("map_visual_info"),r=document.getElementById("map_click_events_coordinates");t.maps[e].series;i&&(iMapsManager.populateInfo(e,i),o.forEach(function(t){a.events.on(t,function(t){iMapsManager.populateInfo(e,i)},this)})),r&&a.events.on("hit",function(e){var t=a.svgPointToGeo(e.svgPoint),o=Number(t.latitude).toFixed(6),i=Number(t.longitude).toFixed(6),n=document.createElement("div"),l=document.createElement("span"),s=document.createElement("span");s.classList.add("map_clicked_lat"),l.innerHTML="LAT: ",s.innerHTML=o,n.appendChild(l),n.appendChild(s);var d=document.createElement("div"),p=document.createElement("span"),u=document.createElement("span");u.classList.add("map_clicked_long"),p.innerHTML="LON: ",u.innerHTML=i,d.appendChild(p),d.appendChild(u),r.innerHTML="",r.appendChild(n),r.appendChild(d),r.parentElement.style.display="block";var c=new CustomEvent("mapPointClicked",{detail:{latitude:o,longitude:i}});document.dispatchEvent(c)},this)},populateInfo:function(e,t){var a=this,o=a.maps[e].map,i="";i+="Zoom Level: "+parseFloat(Number(o.zoomLevel).toFixed(2))+"<br>",i+="Center Coordinates: <br>LAT "+Number(o.zoomGeoPoint.latitude).toFixed(6)+"<br>LONG "+Number(o.zoomGeoPoint.longitude).toFixed(6)+"<br>",t.innerHTML=i;let r={zoom:parseFloat(Number(o.zoomLevel).toFixed(2)),lat:Number(o.zoomGeoPoint.latitude).toFixed(6),long:Number(o.zoomGeoPoint.longitude).toFixed(6)};t.setAttribute("data-visual",JSON.stringify(r))},populateClickInfo:function(e){var t=document.getElementById("map_click_events_info"),a="";t&&e&&(a+="ID: "+e.id+"<br>",e.name&&(a+="Name: "+e.name+"<br>"),e.madeFromGeoData&&(a+=""),e.latitude&&(a+="LAT: "+Number(e.latitude).toFixed(6)+"<br>",a+="LONG: "+Number(e.longitude).toFixed(6)+"<br>"),e.action&&(a+="Action: "+e.action.replace("igm_","")+"<br>"),t.parentElement.style.display="block",t.innerHTML=a)},hideAllSeries:function(e,t){if(e=parseInt(e),e){t=t||!1;for(var a=iMaps.maps[e],o=(a.baseRegionSeries,a.groupedBaseRegionSeries),i=a.allBaseSeries,r=0;r<a.series.length;r++){var n=a.series[r];o.includes(n)||(!t||t&&!i.includes(n))&&n.hide()}}},showAllSeries:function(e){if(e=parseInt(e),e)for(var t=iMaps.maps[e],a=0;a<t.series.length;a++){var o=t.series[a];void 0!==o.isCluster&&!1!==o.isCluster||o.show()}},bool:function(e){var t=0!==Number(e)&&"false"!==e&&void 0!==e;return t},isJSON:function(e){try{JSON.parse(e)}catch(e){return!1}return!0}};Element.prototype.matches||(Element.prototype.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector),Element.prototype.closest||(Element.prototype.closest=function(e){var t=this;do{if(t.matches(e))return t;t=t.parentElement||t.parentNode}while(null!==t&&1===t.nodeType);return null}),iMapsManager.library={icons:{goFullIconPath:"m15.78742,5.93715l-3.95414,3.95414l3.95414,3.95414l1.60393,-1.60393q0.32301,-0.34529 0.77969,-0.15594q0.4344,0.18935 0.4344,0.65717l0,4.99002q0,0.2896 -0.21163,0.50123t-0.50123,0.21163l-4.99002,0q-0.46781,0 -0.65717,-0.44554q-0.18935,-0.4344 0.15594,-0.76855l1.60393,-1.60393l-3.95414,-3.95414l-3.95414,3.95414l1.60393,1.60393q0.34529,0.33415 0.15594,0.76855q-0.18935,0.44554 -0.65717,0.44554l-4.99002,0q-0.2896,0 -0.50123,-0.21163t-0.21163,-0.50123l0,-4.99002q0,-0.46781 0.44554,-0.65717q0.4344,-0.18935 0.76855,0.15594l1.60393,1.60393l3.95414,-3.95414l-3.95414,-3.95414l-1.60393,1.60393q-0.21163,0.21163 -0.50123,0.21163q-0.13366,0 -0.26732,-0.05569q-0.44554,-0.18935 -0.44554,-0.65717l0,-4.99002q0,-0.2896 0.21163,-0.50123t0.50123,-0.21163l4.99002,0q0.46781,0 0.65717,0.44554q0.18935,0.4344 -0.15594,0.76855l-1.60393,1.60393l3.95414,3.95414l3.95414,-3.95414l-1.60393,-1.60393q-0.34529,-0.33415 -0.15594,-0.76855q0.18935,-0.44554 0.65717,-0.44554l4.99002,0q0.2896,0 0.50123,0.21163t0.21163,0.50123l0,4.99002q0,0.46781 -0.4344,0.65717q-0.1448,0.05569 -0.27846,0.05569q-0.2896,0 -0.50123,-0.21163l-1.60393,-1.60393z",exitFullIconPath:"m10.04411,10.81638l0,5.40556q0,0.31372 -0.22925,0.54297t-0.54297,0.22925t-0.54297,-0.22925l-1.7375,-1.7375l-4.00591,4.00591q-0.12066,0.12066 -0.27752,0.12066t-0.27752,-0.12066l-1.37552,-1.37552q-0.12066,-0.12066 -0.12066,-0.27752t0.12066,-0.27752l4.00591,-4.00591l-1.7375,-1.7375q-0.22925,-0.22925 -0.22925,-0.54297t0.22925,-0.54297t0.54297,-0.22925l5.40556,0q0.31372,0 0.54297,0.22925t0.22925,0.54297zm9.10982,-8.10834q0,0.15686 -0.12066,0.27752l-4.00591,4.00591l1.7375,1.7375q0.22925,0.22925 0.22925,0.54297t-0.22925,0.54297t-0.54297,0.22925l-5.40556,0q-0.31372,0 -0.54297,-0.22925t-0.22925,-0.54297l0,-5.40556q0,-0.31372 0.22925,-0.54297t0.54297,-0.22925t0.54297,0.22925l1.7375,1.7375l4.00591,-4.00591q0.12066,-0.12066 0.27752,-0.12066t0.27752,0.12066l1.37552,1.37552q0.12066,0.12066 0.12066,0.27752z"}},iMapsManager.handleExternalZoom=function(e){var t,a,o,i,r,n;t=document.getElementById("map_wrapper_"+e);var l=this,s=l.maps[e].data,d=l.maps[e].series,p=l.maps[e].allBaseSeries;t&&(a=t.querySelector(".map_box"),t.classList.add("map_has_external_controls"),i=document.createElement("div"),i.setAttribute("id","map_home_buttom_"+e),i.setAttribute("data-map-id",e),i.classList.add("map_home_button"),i.innerHTML='<svg height="20" width="20"><path d="M16,8 L14,8 L14,16 L10,16 L10,10 L6,10 L6,16 L2,16 L2,8 L0,8 L8,0 L16,8 Z M16,8" /></svg>',i.addEventListener("click",function(e){var t=this.getAttribute("data-map-id");if(iMaps.maps[t].map.goHome(),l.bool(s.drillDownOnClick)){for(var a=0,o=d.length;a<o;a++)d[a].hide();for(var i=0,r=p.length;i<r;i++)p[i].show();iMapsManager.maps[t].drilledTo=!1,iMapsManager.maps[t].isDrilling=!1}"undefined"!=typeof iMapsActions&&void 0!==iMapsActions.resetActions&&iMapsActions.resetActions(t)}),r=document.createElement("div"),r.setAttribute("id","map_zoomin_buttom_"+e),r.setAttribute("data-map-id",e),r.classList.add("map_zoomin_button"),r.innerHTML="+",r.addEventListener("click",function(e){var t=this.getAttribute("data-map-id");iMaps.maps[t].map.zoomIn()}),n=document.createElement("div"),n.setAttribute("id","map_zoomout_buttom_"+e),n.setAttribute("data-map-id",e),n.classList.add("map_zoomout_button"),n.innerHTML="-",n.addEventListener("click",function(e){var t=this.getAttribute("data-map-id");iMaps.maps[t].map.zoomOut()}),o=document.createElement("div"),o.setAttribute("id","map_controls_"+e),o.classList.add("map_controls"),o.appendChild(i),o.appendChild(r),o.appendChild(n),a.parentNode.insertBefore(o,a.nextSibling))},iMapsManager.openFullscreen=function(e){e.requestFullscreen?e.requestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen?e.webkitRequestFullscreen():e.msRequestFullscreen&&e.msRequestFullscreen()},iMapsManager.closeFullScreen=function(){document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen?document.webkitExitFullscreen():document.msExitFullscreen&&document.msExitFullscreen(),iMapsManager.isFullScreen=!1},iMapsManager.isTouchScreendevice=function(){return"ontouchstart"in window||navigator.maxTouchPoints>0||navigator.msMaxTouchPoints>0},iMapsManager.nl2br=function(e){var t="HI<br>HI";return(e+"").replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g,t)},iMapsManager.isFullScreen=!1;var iMaps={originalData:JSON.parse(JSON.stringify(iMapsData)),reset:function(){iMaps.maps&&Object.keys(iMaps.maps).forEach(function(e){iMaps.maps[e].map.dispose()}),iMapsData=iMaps.originalData,iMaps.init()},init:function(e){if(void 0===e&&void 0!==iMapsData.options&&void 0!==iMapsData.options.hold&&"1"===iMapsData.options.hold&&(e=!0),!e)if("undefined"!=typeof am4core)am4core.ready(function(){var e;am4core.options.autoSetClassName=!0,am4core.options.classNamePrefix="imaps",am4core.options.commercialLicense=!0,am4core.options.queue=!0,void 0!==iMapsData.options&&void 0!==iMapsData.options.lazyLoad&&"1"===iMapsData.options.lazyLoad&&(am4core.options.onlyShowOnViewport=!0),void 0===iMapsData.options||void 0===iMapsData.options.animations||"1"!==iMapsData.options.animations&&!0!==iMapsData.options.animations||am4core.useTheme(am4themes_animated),e=iMapsModel.prepareData(iMapsData.data),e.forEach(function(e,t){t.disabled||iMapsManager.init(t)}),iMaps.maps=iMapsManager.maps});else{console.log("Map files not loaded properly.");let e=document.querySelector(".oxygen-body .map_wrapper .map_render");e&&(e.innerHTML='Map Container. <br> Map will not render in Oxygen preview, but will render in live page.<br>Consider enabling the "Async Loading" option in the Settings > Performance page.')}},loadScript:function(e,t){var a=document.createElement("script");a.type="text/javascript",a.src=e,a.onreadystatechange=t,a.onload=t,document.head.appendChild(a)},loadScripts:function(e,t){var a=0,o=function(){a++,a>=e.length&&t.call(this,arguments)};e.forEach(function(e,t){iMaps.loadScript(e,o)})}};void 0!==iMapsData.async&&Array.isArray(iMapsData.async)&&iMapsData.async.length>0?iMaps.loadScript(iMapsData.async[0],function(){iMapsData.async.shift(),iMaps.loadScripts(iMapsData.async,function(){iMaps.init()})}):iMaps.init();