<?php
/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  				     Copyright (C) Themify
 * 
 *	----------------------------------------------------------------------
 *
 * Shortcodes:
 * 		button
 * 		col
 * 		img
 * 		hr
 * 		quote
 * 		is_logged_in
 * 		is_guest
 * 		map
 * 		video
 * 		twitter
 * 		instagram
 * 		post_slider
 * 		slider
 * 		list_posts
 * 		box
 * 		author-box
 *		icon
 * 
 * Functions:
 *		themify_shortcode_list
 * 		themify_shortcodes_js_css
 * 		themify_shortcode
 * 		themify_shortcode_list_posts
 *		themify_shortcode_twitter
 *		themify_shortcode_instagram
 * 		themify_shortcode_slide
 * 		themify_shortcode_slider
 * 		themify_shortcode_post_slider
 * 		themify_shortcode_author_box
 * 		themify_shortcode_box
 * 
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Creates shortcodes
 * @param Object $atts
 * @param String $content
 * @param String $code
 * @return String
 */
function themify_shortcode( $atts = array(), $content = null, $code = '' ) {
	switch ( $code ) {
		case 'is_logged_in':
		case 'themify_is_logged_in':
			if ( is_user_logged_in() ) {
				return do_shortcode( $content );
			}
		break;
		case 'is_guest':
		case 'themify_is_guest':
			if ( ! is_user_logged_in() ) {
				return do_shortcode( $content );
			}
		break;
		case 'button':
		case 'themify_button':
			$atts = shortcode_atts( array(
				'bgcolor' => '',
				'size' 	=> '',
				'block' => false,
				'style'	=> '',
				'link' 	=> '#',
				'target'=> '',
				'onclick'=> '',
				'color' => '',
				'text'	=> ''
			), $atts, 'themify_button' );
			$style = implode( ' ', array( $atts['bgcolor'],$atts['size'] , ( $atts['block'] ? 'block' : '' ), $atts['style'] ) );

			$html = '<a href="' . esc_url( $atts['link'] ) . '" class="shortcode button '. esc_attr( $style ) . '"';
			if($atts['color']!=='' || $atts['text']!=='' ){
			    $html.=' style="';
			    if($atts['color']!=='' ){
				$html.= 'background-color: ' . esc_attr( $atts['color'] ) . ';';
			    }
			    if( $atts['text']!=='' ) {
				$html.= 'color: ' . esc_attr( $atts['text'] ) . ';';
			    }
			    $html.='"';
			}
			if( $atts['target']!=='' ) {
				$html.=' target="'.esc_attr( $atts['target'] ).'"';
			}
			if( $atts['onclick']!=='' ) {
				$html.=' onclick="' . esc_attr( $atts['onclick'] ) . '"';
			}
			$html.='>'.do_shortcode( $content ).'</a>';
			return $html;
		break;
		case 'quote':
		case 'themify_quote':
		case 'col':
		case 'themify_col':
		case 'sub_col':
		case 'themify_sub_col':
			$content = do_shortcode( preg_replace( array( '#<p>\s*+(<br\s*/*>)?\s*</p>#i', '~\s?<p>(\s|&nbsp;)+</p>\s?~' ), '', force_balance_tags( $content ) ) ) ;
			if($code==='quote' || $code==='themify_quote'){
				$content = '<blockquote class="shortcode quote">' . $content . '</blockquote>';
			}
			else{
				$type = $code ==='col' || $code==='themify_col'?'themify_col':'themify_sub_col';
				$atts= shortcode_atts( array( 'grid' => '' ), $atts, $type ) ;
				$content = '<div class="shortcode col' . esc_attr( $atts['grid'] ) . '">' . $content. '</div>';
			}
			return $content;
		break;
		case 'img':
		case 'themify_img':
			$atts = shortcode_atts( array(
				'class' => '',
				'src' 	=> '',
				'id'	=> '',
				'h'		=> '',
				'w'		=> '',
				'crop'	=> true,
				), $atts, 'themify_img' );
			$image = themify_shortcodes_do_img( $atts['src'], $atts['w'], $atts['h'], $atts['crop'] );
			return '<img src="' . esc_attr( $image['url'] ) . '" width="' . esc_attr( $image['width'] ) . '" height="' . esc_attr( $image['height'] ) . '" class="' . esc_attr( $atts['class'] ) . '" id="' . esc_attr( $atts['id'] ) . '" />';
		break;
		case 'hr':
		case 'themify_hr':
			$atts = shortcode_atts( array(
				'color' => '',
				'width' => '',
				'border_width' => ''
			), $atts, 'themify_hr' );
			if( '' !== $atts['width'] || '' !==$atts['border_width']){
				$hrstyle = 'style="';
				if( '' !== $atts['width']  ){
					$hrstyle .= 'width:' . esc_attr( $atts['width'] ) . ';';
				}
				if( '' !== $atts['border_width']  ){
					if( strpos('/MSIE 7/i', $_SERVER['HTTP_USER_AGENT'] )!==false ){
						$hrstyle .= 'height:' . esc_attr( $atts['border_width'] ) . ';';
					}
					$hrstyle .= 'border-width:' . esc_attr( $atts['border_width'] ) . ';';
				}
				$hrstyle .= '"';
			} else {
				$hrstyle = '';
			}
			return '<hr class="shortcode hr ' . esc_attr( $atts['color'] ) . '" ' . $hrstyle . ' />';
		break;
		case 'map':
		case 'themify_map':

			wp_enqueue_script( 'themify-shortcodes' );

			$atts= shortcode_atts(
				array(
					'address' => '99 Blue Jays Way, Toronto, Ontario, Canada',
					'width' => '500px',
					'height' => '300px',
					'zoom' => 15,
					'type' => 'ROADMAP',
					'scroll_wheel' => 'yes',
					'draggable_disable_mobile_map' => 'yes',
					'draggable' => 'yes',
				),
				$atts,
				'themify_map'
			);

			/* if no unit is provided for width and height, use "px" */
			if( ! preg_match( '/[px|%]$/', $atts['width'] ) ) {
				 $atts['width'] =  $atts['width'] . 'px';
			}
			if( ! preg_match( '/[px|%]$/',  $atts['height'] ) ) {
				$atts['height'] = $atts['height'] . 'px';
			}

			if ( 'yes' === $atts['draggable'] && 'yes' === $atts['draggable_disable_mobile_map'] && wp_is_mobile() ) {
				$atts['draggable'] = 'disable';
			}
			$atts['draggable'] = $atts['draggable'] === 'yes';
			$atts['scroll'] = $atts['scroll_wheel'] === 'yes';
			return '
			<div class="themify-shortcodes-map-wrap">
				<div
					data-address="' . esc_attr( $atts['address'] ) . '"
					data-zoom="' . esc_attr( $atts['zoom'] )  . '"
					data-type="' . esc_attr( $atts['type'] ) . '"
					data-scroll="' . esc_attr( $atts['scroll'] ) . '"
					data-drag="' . esc_attr( $atts['draggable'] ) . '"
					id="' . uniqid( 'themify_map_canvas_' ) . '"
					style="display: block; width:' .  esc_attr( $atts['width'] ) . '; height:' . esc_attr( $atts['height'] ) . ';" class="themify-shortcodes-map"
				></div>
			</div>';
		break;
		case 'themify_video':
			global $wp_embed;

			if ( isset( $atts['src'] ) ) {
				return do_shortcode( '[video src="' . esc_attr( $atts['src'] ) . '"]' );
			}
		break;
	}
	return '';
}

/**
 * Get a WP_Query parameters from the shortcode attributes
 *
 * @param $atts the array of shortcode parameters supplied by user
 * @param $shortcode the name of shortcode calling, provides "shortcode_atts_$shortcode" filter
 * @param $defaults allows overriding the default shortcode atts, before being replaced by $atts
 *
 * @return array
 */
function themify_parse_shortcode_ids( $category ) {
	if ( ! is_array( $category ) ) {
		$category = array_map( 'trim', explode( ',', $category ) );
	}

	$ids_in = $ids_not_in = $slugs_in = $slugs_not_in = array();
	foreach ( $category as $v ) {
		$v = trim( $v );
		$except = '-' !== $v[0];
		if ( is_numeric( $v ) ) {
			if ( $except === true ) {
				$ids_in[] = $v;
			} else {
				$ids_not_in[] = abs( $v );
			}
		} else {
			if ( $except === true ) {
				$slugs_in[] = $v;
			} else {
				$slugs_not_in[] = substr( $v, 1 );
			}
		}
	}

	return array( $ids_in, $ids_not_in, $slugs_in, $slugs_not_in );
}

function themify_parse_shortcode_query_atts( $atts = array(), $shortcode = '', $defaults = array() ) {

	$atts= shortcode_atts( wp_parse_args( $defaults, array(
		'category' => '0',
		'limit' => '5',
		'offset' => '0',
		'post_type' => 'post',
		/**
		 * backward compatibility fix
		 * get terms from proper taxonomy for post types registered by Themify themes
		 */
		'taxonomy' => ( isset( $atts['post_type'] ) && 'post' !== $atts['post_type'] ) ? $atts['post_type'] . '-category' : 'category',
		'order' => 'DESC',
		'orderby' => 'date',
		'taxonomy_relation' => 'AND',
	) ), $atts, $shortcode );

	$query_args = array(
		'posts_per_page' => $atts['limit'],
		'offset' => $atts['offset'],
		'post_type' =>$atts['post_type'] ,
		'taxonomy' => $atts['taxonomy'],
		'order' => $atts['order'],
		'orderby' => $atts['orderby'],
		'suppress_filters' => false,
		'post__not_in' => is_singular() ? array( get_the_id() ) : array(),
	);

	if ( '0' !== $atts['category'] ) {
		list($ids_in,$ids_not_in,$slugs_in,$slugs_not_in)= themify_parse_shortcode_ids($atts['category'],$query_args['taxonomy']);
		if ( ! empty( $ids_in ) ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => $atts['taxonomy'],
				'field' => 'id',
				'terms' => $ids_in
			);
		}
		if ( ! empty( $ids_not_in ) ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => $atts['taxonomy'],
				'field' => 'id',
				'terms' => $ids_not_in,
				'operator' => 'NOT IN'
			);
		}
		if ( ! empty( $slugs_in ) ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => $atts['taxonomy'],
				'field' => 'slug',
				'terms' => $slugs_in
			);
		}
		if ( ! empty( $slugs_not_in ) ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => $atts['taxonomy'],
				'field' => 'slug',
				'terms' => $slugs_not_in, // remove the minus sign (first character)
				'operator' => 'NOT IN'
			);
		}
		$query_args['tax_query']['relation'] = $atts['taxonomy_relation'];
	}

	return $query_args;
}

/**
 * List posts using get_posts
 * @param Object $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_list_posts( $atts = array(), $content = null ) {
	global $themify;
	
	// Set defaults for featured image in different layouts
	$default_size = array(
		'image_w' => 1160,
		'image_h' => 665
	);
	
	if ( isset( $atts['style'] ) ) {
		switch ( $atts['style'] ) {
			case 'grid4':
				$default_size['image_w'] = 260;
				$default_size['image_h'] = 150;
			break;
			case 'grid3':
				$default_size['image_w'] = 360;
				$default_size['image_h'] = 205;
			break;
			case 'grid2':
				$default_size['image_w'] = 561;
				$default_size['image_h'] = 321;
			break;
			case 'list-thumb-image':
				$default_size['image_w'] = 260;
				$default_size['image_h'] = 150;
			break;
			case 'grid2-thumb':
				$default_size['image_w'] = 160;
				$default_size['image_h'] = 95;
			break;
			case 'list-post':
			default:
				$default_size['image_w'] = 1160;
				$default_size['image_h'] = 665;
			break;
		}
	}

	$query_args = themify_parse_shortcode_query_atts( $atts, 'themify_list_posts' );

	$atts=shortcode_atts( array(
		'title' => 'yes',
		'more_text' => __('More...', 'themify'),
		'excerpt_length' => '',
		'image' => 'yes',
		'image_w' => $default_size['image_w'],
		'image_h' => $default_size['image_h'],
		'display' => 'none',
		'style' => 'list-post',
		'post_date' => 'no',
		'post_meta' => 'no',
		'unlink_title' => 'no',
		'unlink_image' => 'no',
		'image_size' => 'medium',
		'post_type' => 'post',
	), $atts, 'themify_list_posts' );

	$atts['image_w'] = (int) $atts['image_w'];
	$atts['image_h'] = (int) $atts['image_h'];

	$the_query = new WP_Query();
	$posts = $the_query->query( apply_filters( 'themify_list_posts_shortcode_query_args', $query_args, $atts ) );
	// save a copy
	$themify_save = clone $themify;
	// override $themify object
	$themify->hide_image = 'yes' === $atts['image']? 'no' : 'yes';
	$themify->unlink_image =$atts['unlink_image'] ;
	$themify->hide_title = 'yes' === $atts['title']? 'no' : 'yes';
	$themify->width = $atts['image_w'];
	$themify->height =$atts['image_h'];
	$themify->is_shortcode=true;
	$themify->unlink_title = $atts['unlink_title'];
	$themify->display_content = $atts['display'];
	$themify->hide_date = 'yes' === $atts['post_date']? 'no' : 'yes';
	$themify->hide_meta = 'yes' ===$atts['post_meta'] ? 'no' : 'yes';
	$themify->post_layout = $atts['style'];
	$themify->image_size =$atts['image_size'];

	$out = '';
	if ( $posts ) {

		if ( method_exists( 'Themify_Enqueue_Assets', 'loadGridCss' ) ) {
			Themify_Enqueue_Assets::loadGridCss( $themify->post_layout );
		}

		$out = '<!-- shortcode list_posts -->';
		$out.='<div class="loops-wrapper shortcode tf_clearfix list-posts layout ' . esc_attr( $themify->post_layout ) . ' tf_clear">';
		$out .= themify_shortcodes_get_loop_template( $posts, 'includes/loop', $atts['post_type'] );
		$out .= '</div>';
		$out.='<!-- /shortcode list_posts -->';
	}
	
	// revert to original $themify state
	$themify = clone $themify_save;
	$themify_save=null;
	return $out;
}

/**
 * Creates one slide for the slider shortcode
 * @param Object $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_slide( $atts, $content = null ) {
	return '<li><div class="slide-wrap">' . do_shortcode( $content ) . '</div></li>';
}

/**
 * Creates a slider using the slide shortcode
 * @param Object $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_slider( $atts = array(), $content = null ){
	wp_enqueue_script( 'themify-shortcodes' );

	extract( shortcode_atts( array(
		'wrap' => 'yes',
		'visible' => '1',
		'scroll' => '1',
		'auto' => '0',
		'pause_hover' => 'no',
		'speed' => 'normal',
		'slider_nav' => 'yes',
		'pager' => 'yes',
		'effect' => 'scroll',
		'class' => '',
		'height' => 'auto', // [auto / variable]
	), $atts, 'themify_slider' ) );
	$numsldrtemp = rand( 0, 10000 );
	$content = do_shortcode( shortcode_unautop( $content ) );
		
	$class .= ' effect-' . $effect;
	if($speed==='fast'){
	    $speed = '.5';
	}
	elseif($speed==='normal'){
	    $speed = '1';
	}
	elseif($speed==='slow'){
	    $speed = '4';
	}
	$js_data['slider_nav'] = $slider_nav==='yes'?1:0;
	$js_data['pager'] = $pager==='yes'?1:0;
	$js_data['wrapvar'] = $wrap === 'yes'?1:0;
	$js_data['auto'] =  (int) $auto;
	$js_data['pause_hover'] = $pause_hover === 'yes'?1:0;
	$js_data['speed'] = $speed;
	$js_data['scroll'] = $scroll;
	$js_data['effect'] = $effect;
	$js_data['visible'] = (int)$visible;
	$js_data['numsldr'] = rand( 0, 1011 ).uniqid();
	$js_data['height'] = $height;

	$strsldr = '<!-- shortcode slider --><div id="slider-' . esc_attr( $js_data['numsldr'] ) . '" class="themify-shortcodes-slider shortcode tf_clearfix slider ' . esc_attr( $class ) . '">
	<ul data-slider=\''.esc_attr( base64_encode( json_encode( $js_data ) ) ). '\' class="slides">' . $content . '</ul>';	
	$strsldr .= '</div>
		<!-- /shortcode slider -->';
	return $strsldr;
}

/**
 * Create a slider with posts retrieved through get_posts
 * @param Object $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_post_slider( $atts = array(), $content = null ) {
	global $post, $themify;

	wp_enqueue_script( 'themify-shortcodes' );

	extract( shortcode_atts( array(
		'visible' => '1',
		'scroll' => '1',
		'auto' => '0',
		'pause_hover' => 'no',
		'wrap' => 'yes',
		'excerpt_length' => '20',
		'speed' => 'normal',
		'slider_nav' => 'yes',
		'pager' => 'yes',
		'image' => 'yes',
		'image_w' => '240px',
		'image_h' => '180px',
		'more_text' => __('More...', 'themify'),
		'title' => 'yes',
		'display' => 'none',
		'post_meta' => 'no',
		'post_date' => 'no',
		'width' => '100%',
		'height' => 'auto',
		'class' => '',
		'unlink_title' => 'no',
		'unlink_image' => 'no',
		'image_size' => 'medium',
		'effect' => 'scroll',
		'post_type' => 'post',
	), $atts, 'themify_post_slider' ) );

	$postsliderstr = '';

	$query_args = themify_parse_shortcode_query_atts( $atts, 'themify_post_slider' );
	$posts = get_posts( apply_filters( 'themify_post_slider_shortcode_query_args', $query_args, $atts ) );
	if ($posts) {
		if($speed==='fast'){
		    $speed = '.5';
		}
		elseif($speed==='normal'){
		    $speed = '1';
		}
		elseif($speed==='slow'){
		    $speed = '4';
		}
		$class .= ' effect-' . $effect;
		$js_data['slider_nav'] = $slider_nav === 'yes' ? 1 : 0;
		$js_data['pager'] = $pager === 'yes' ? 1 : 0;
		$js_data['wrapvar'] = $wrap === 'yes' ? 1 : 0;
		$js_data['auto'] =  (int)$auto;
		$js_data['pause_hover'] = $pause_hover === 'yes' ? 1 : 0;
		$js_data['speed'] = $speed;
		$js_data['scroll'] = $scroll;
		$js_data['effect'] = $effect;
		$js_data['visible'] = (int)$visible;
		$js_data['height'] = $height;
		$js_data['numsldr'] = rand(0,1011).uniqid();
		$postsliderstr = '<!-- shortcode post_slider --> <div id="slider-' . esc_attr(  $js_data['numsldr'] ) . '" style="width: ' . esc_attr( $width ) . ';" class="themify-shortcodes-slider shortcode tf_clearfix post-slider ' . $class . '">
		<ul class="slides" data-slider=\''.esc_attr( base64_encode( json_encode( $js_data ) ) ).'\'>';
		unset($js_data);

		$themify_save = clone $themify;

		// override $themify object
		$themify->hide_image = 'yes' === $image? 'no' : 'yes';
		$themify->unlink_image = $unlink_image;
		$themify->hide_title = 'yes' === $title? 'no' : 'yes';
		$themify->width = $image_w;
		$themify->height = $image_h;
		$themify->image_setting = 'ignore=true&';
		$themify->unlink_title = $unlink_title;
		$themify->display_content = $display;
		$themify->hide_date = 'yes' === $post_date? 'no' : 'yes';
		$themify->hide_meta = 'yes' === $post_meta? 'no' : 'yes';
		$themify->is_shortcode = true;
		$themify->image_size = $image_size;

		$postsliderstr .= themify_shortcodes_get_loop_template( $posts, 'includes/loop', $post_type, array(
			'before_post' => '<li>',
			'after_post' => '</li>'
		) );

		// revert to original $themify state
		$themify = clone $themify_save;

		$postsliderstr .= '</ul>';
		$postsliderstr .= '</div><!-- /shortcode post_slider -->';
	} //$posts

	return $postsliderstr;
}

/**
 * Creates an author box to display your profile
 * @param Object $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_author_box( $atts = array(), $content = null ) {
	$atts= shortcode_atts( array(
		'avatar' => 'yes',
		'avatar_size' => '48',
		'color' => '',
		'icon' => '',
		'style' => '',
		'author_link' => 'no'
	), $atts, 'themify_author_box' );
	$atts['style'] = implode( ' ', array( $atts['color'], $atts['icon'], $atts['style'] ) );

	/** 
	 * Filtered name of author
	 * @var String */
	$nicename = get_the_author_meta( 'nicename' );
	$authorboxstr = '<!-- shortcode author_box --> <div class="shortcode tf_clearfix author-box ' . esc_attr( $atts['style'] . ' ' . $nicename ) . ' ">';
	if ( 'yes' === $atts['avatar'] ) {
		$authorboxstr .= '<p class="author-avatar">' . get_avatar( get_the_author_meta( 'user_email' ), $atts['avatar_size'], '' ) . '</p>';
	}
	if ( get_the_author_meta( 'user_url' ) ) {
		$authorboxstr .= '<div class="author-bio">
			<h4 class="author-name"><a href="' . esc_url( get_the_author_meta( 'user_url' ) ) . '">' . get_the_author_meta( 'display_name' ) . '</a></h4>
		' . get_the_author_meta( 'description' );
	} else {
		$authorboxstr .= '<div class="author-bio">
		<h4 class="author-name">' . get_the_author_meta( 'display_name' ) . '</h4>
	' . get_the_author_meta( 'description' );
	}
	if ( 'yes' === $atts['author_link'] ) {
                $url = esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );
		if ( $url ) {
			$authorboxstr .= '<p class="author-link"><a href="' . $url . '">&rarr; ' . get_the_author_meta( 'display_name' ) . ' </a></p>';
		} else {
			$authorboxstr .= '<p class="author-link">&rarr; ' . get_the_author_meta( 'display_name' ) . ' </p>';
		}
	}
	$authorboxstr .= '</div></div> <!-- /shortcode author_box -->';
	return $authorboxstr;
}

/**
 * Creates a box to enclose content
 * @param Object $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_box( $atts = array(), $content = null ) {
	$atts = shortcode_atts( array(
		'color' => '',
		'icon' => '',
		'style' => '',
	), $atts, 'themify_box' );

	$atts['style'] = implode( ' ', array( $atts['color'], $atts['style'] ) );

	$icon = '';
	if ( ! empty( $atts['icon'] ) ) {
		/* backward compatibility, map old icon names with new ones */
		$legacy_icons = array(
			'announcement' => 'ti-announcement',
			'comment'      => 'ti-comment',
			'question'     => 'ti-help',
			'upload'       => 'ti-upload',
			'download'     => 'ti-download',
			'highlight'    => 'ti-light-bulb',
			'map'          => 'ti-location-pin',
			'warning'      => 'ti-alert',
			'info'         => 'ti-info',
			'note'         => 'ti-pencil',
			'contact'      => 'ti-email',
		);
		if ( isset( $legacy_icons[ $atts['icon'] ] ) ) {
			$atts['icon'] = $legacy_icons[ $atts['icon'] ];
		}

		$icon = themify_shortcode_icon( array( 'icon' => $atts['icon'] ) );
	}

	return '
	<!-- shortcode box --> <div class="shortcode tf_clearfix box ' . esc_attr($atts['style'] ) . '">'
		. $icon
		. do_shortcode( preg_replace( array( '#<p>\s*+(<br\s*/*>)?\s*</p>#i', '~\s?<p>(\s|&nbsp;)+</p>\s?~' ), '', force_balance_tags( $content ) ) )
	. '</div> <!-- /shortcode box -->';
}

/**
 * Display tweets by user
 * @param array $atts
 * @param String $content
 * @return String
 */
function themify_shortcode_twitter( $atts = array(), $content = null ) {
	 $atts=shortcode_atts( array(
		'username' => '',
		'type' => '',
		'timeline_height' => 400,
		'timeline_width' => 300,
		'show_count' => 5,
		'show_timestamp' => 'true',
		'hide_footer' => false,
		'show_follow' => 'false',
		'embed_code' => '',
		'follow_text' => __('&rarr; Follow me', 'themify'),
		'include_retweets' => 'false',
		'exclude_replies' => 'false',
		'is_widget' => 'false'
	), $atts, 'themify_twitter' );
	
	$is_shortcode =  'false' == $atts['is_widget']?'shortcode':'';
	$screen_name = sanitize_user( $atts['username'] );
	$count = (int)$atts['show_count'];
	if ( ! empty( $atts['type'] ) ) {
		if ( $atts['type'] === 'type-timeline' ) {
			
			$data_chrome = $atts['hide_footer']?'data-chrome="nofooter"':'';
			$show_replies = $atts['exclude_replies'] == 'false';

			$out = "<a class='twitter-timeline' {$data_chrome} data-show-count='{$count}' data-show-replies='{$show_replies}' data-height='" . esc_attr( $atts['timeline_height'] ) . "' data-width='" . esc_attr( $atts['timeline_width'] ) . "'
	  					href='https://twitter.com/{$screen_name}'>
							Tweets by @{$screen_name}
					</a>
					<script async src='//platform.twitter.com/widgets.js' charset='utf-8'></script>";
			
			return $out;
		}

		return $atts['embed_code'];
	}

	$args = array(
		'username' => $screen_name,
		'limit' => $count,
		'include_retweets' => $atts['include_retweets'],
		'exclude_replies' => $atts['exclude_replies']
	);

	$tweets = themify_twitter_get_data( $args );
	if( is_array( $tweets ) && isset( $tweets['error_message'] ) && current_user_can('administrator') ) {
		return $tweets['error_message'];
	}
	$out = '<div class="twitter-list '.$is_shortcode.'">
			<div class="twitter-block">';

	if ( is_array( $tweets ) && !empty( $tweets ) && !isset( $tweets['error_message'] )) {
		$out .= '<ul class="twitter-list">';

		foreach( $tweets as $tweet ) {
			$text = $tweet->text;
			foreach ( $tweet->entities as $entity ) {
				if( 'urls' ===  $atts['type'] ) {
					foreach($entity as  $url) {
						$update_with = '<a href="' . esc_url( $url->url ) . '" target="_blank" title="' . esc_attr( $url->expanded_url ) . '" class="twitter-user">' . $url->display_url . '</a>';
						$text = str_replace($url->url, $update_with, $text);
					}
				} elseif ( 'hashtags' === $atts['type'] ) {
					foreach($entity as $hashtag) {
						$update_with = '<a href="' . esc_url( '//twitter.com/search?q=%23' . $hashtag->text . '&src=hash' ) . '" target="_blank" title="' . esc_attr( $hashtag->text ) . '" class="twitter-user">#' . $hashtag->text . '</a>';
						$text = str_replace('#'.$hashtag->text, $update_with, $text);
					}
				} elseif ( 'user_mentions' ===  $atts['type'] ) {
					foreach($entity as $user) {
						$user->screen_name = str_replace( '@', '', $user->screen_name );
						$update_with = '<a href="' . esc_url( '//twitter.com/' . $user->screen_name ) . '" target="_blank" title="' . esc_attr( $user->name ) . '" class="twitter-user">@' . $user->screen_name . '</a>';
						$text = str_replace('@'.$user->screen_name, $update_with, $text);
					}
				} elseif ( 'media' ===  $atts['type'] ) {
					foreach ( $entity as $media ) {
						$update_with = '<a href="' . esc_url( $media->url ) . '" target="_blank" title="' . esc_attr( $media->expanded_url ) . '" class="twitter-media">' . $media->display_url . '</a>';
						$text = str_replace( $media->url, $update_with, $text );
					}
				}
			}
			$out .= '<li class="twitter-item">'.$text;
			if ( 'false' != $atts['show_timestamp'] ) {
				// hour ago time format
				$time = sprintf( __('%s ago', 'themify'), human_time_diff( strtotime( $tweet->created_at ) ) );
				$out .= '<br /><em class="twitter-timestamp"><small>' . $time. '</small></em>';
			}
			$out .= '</li>';
		}
		$out .= '</ul>';
	}
	$out .= '</div>';
	if ( 'false' != $atts['show_follow'] ) {
		$out .= '<div class="follow-user"><a href="' . esc_url( '//twitter.com/' .  $atts['username'] ) . '">' .  esc_html( $atts['follow_text'] ) . '</a></div>';
	}

	$out .= '</div>';

	return $out;
}

/**
 * Get twitter data store from cache
 * @param $args
 * @return array|mixed
 */
function themify_twitter_get_data( $args ) {
	$data = array();
	$transient_id=md5(implode('',$args));
	$transient_key = 'tf_tweets_'.$transient_id;
	
	$transient = get_transient( $transient_key );

	if ( false === $transient || (class_exists('Themify_Builder') && Themify_Builder::$frontedit_active===true)){
		$response = themify_request_tweets( $args );
		if ( ! is_wp_error( $response ) && is_array( $response ) && ( isset( $response[0]->user->id ) || isset( $response['error_message'] ) ) ) {
			$data = $response;
			set_transient( $transient_key, $data, 10 * 60 ); // 10 min cache
		}
	} else {
		$data = $transient;
	}

	return $data;
}

/**
 * Get request tweets from service api
 * @param $args
 * @return bool|object
 */
function themify_request_tweets($args) {
	$screen_name = urlencode(strip_tags( sanitize_user( str_replace( '@', '', $args['username'] ) ) ));
	$count = 0;
	if ( $args['limit'] != '' ) {
		$count =(int) $args['limit'];
	}
	$include_rts = $args['include_retweets'] == 'true'?'1':'0';
	$exclude_replies = $args['exclude_replies'];

	if ( ! class_exists( 'Themify_Shortcodes_Wp_Twitter_Api' ) ) {
		// Require twitter oauth class
		require THEMIFY_SHORTCODES_DIR . 'includes/class-wp-twitter-api.php';
	}

	$is_themify_theme = Themify_Shortcodes::get_instance()->is_using_themify_theme();
	if ( $is_themify_theme ) {
		$consumer_key = themify_get( 'setting-twitter_settings_consumer_key', '', true );
		$consumer_secret = themify_get( 'setting-twitter_settings_consumer_secret', '', true );
	} else {
		$options = get_option( 'themify_shortcodes' );
		$consumer_key = ! empty( $options['twitter_consumer_key'] ) ? $options['twitter_consumer_key'] : '';
		$consumer_secret = ! empty( $options['twitter_consumer_secret'] ) ? $options['twitter_consumer_secret'] : '';
	}

	$credentials = array(
		'consumer_key' => $consumer_key,
		'consumer_secret' => $consumer_secret,
	);
	$query = 'screen_name='.$screen_name.'&count='.$count.'&include_rts='.$include_rts.'&exclude_replies='.$exclude_replies.'&include_entities=true';
	
	$twitterConnection = new Themify_Shortcodes_Wp_Twitter_Api( $credentials );
	return  $twitterConnection->query($query);
}

/**
 * Flush transient when post is saved.
 * @param $post_id
 */
function themify_twitter_flush_transient( $post_id ) {
	//verify post is not a revision
	if (isset( $_POST['content'] ) && ! wp_is_post_revision( $post_id ) ) {
		// Count unprefixed and/or prefixed shortcode instances
		$post_content = $_POST['content'];
		$count = substr_count($post_content, '[twitter');
		if($count===0){
		    $count = substr_count($post_content, '[themify-twitter');
		}
		if ( $count > 0 ) {
		    // delete transient
		    global $wpdb;
		    $wpdb->get_results( "DELETE FROM $wpdb->options WHERE `option_name` LIKE ('_transient_tf_tweets_%')" );
		}
	}
}

/**
 * Renders a font icon.
 *
 * @since 1.9.1
 *
 * @param array $atts
 * @param null $content
 * @return string
 */
function themify_shortcode_icon( $atts = array(), $content = null ) {
	$atts = shortcode_atts( array(
		'icon'       => '',
		'label'      => '',
		'link'       => '',
		'style'      => '',
		'icon_bg'    => '',
		'icon_color' => '',
		'target'     => '',
	), $atts );

	// Set front and background colors.
	$colors = '';
	$style_attr = '';
	$circle_bg = '';
	if ( ! empty( $atts['icon_bg'] ) ) {
		$circle_bg = ' tf_circle_bg'; /* if background color is used, add as a circle behind the icon */
		$colors .= "background-color: {$atts['icon_bg']};";
	}
	if ( ! empty( $atts['icon_color'] ) ) {
		$colors .= "color: {$atts['icon_color']};";
	}
	if ( ! empty( $colors ) ) {
		$style_attr = 'style="' . esc_attr( $colors ) . '"';
	}

	// Begin building markup for icon.
	$out = '';

	// Build icon
	if ( ! empty( $atts['icon'] ) ) {
		if ( class_exists( 'Themify_Icon_Font' ) ) {
			$atts['icon'] = themify_get_icon( $atts['icon'] );
			$out .= '<i class="themify-icon-icon" ' . $style_attr . '>'.$atts['icon'].'</i>';
		} else {

			if ( strpos( $atts['icon'], 'ti-' ) === 0 ) {
				$prefix = '';
				wp_enqueue_style( 'themify-icons' );
			} else {
				$prefix = 'fa';
				wp_enqueue_style( 'themify-font-icons-css' );
			}

			$out .= "<i class='themify-icon-icon {$prefix} {$atts['icon']}' {$style_attr}></i>";
		}
	}

	// Build label
	if ( ! empty( $atts['label'] ) ) {
		$out .= '<span class="themify-icon-label">' . esc_html( $atts['label'] ) . '</span>';
	}

	// Sanitize link
	$link = $atts['link'];
	if ( '' != $link && '' != $out ) {
		$target = !empty( $atts['target'] )? ' target="' . esc_attr( $atts['target'] ) . '"' : '';
		$out = '<a href="' . esc_url( $link ) . '" class="themify-icon-link"' . $target . '>' . $out . '</a>';
	}

	return '<span class="shortcode themify-icon' . $circle_bg . ' ' . esc_attr( $atts['style'] ) . '">' . $out . '</span>';
}

/**
 * Themify List shortcode
 *
 * @since 2.8.9
 */
function themify_shortcode_icon_list( $atts = array(), $content = null ) {
	$atts = (array) $atts;
	// the list shortcode has the same parameters as [themify_icon]
	$style = isset( $atts['style'] ) ? $atts['style'] : '';
	unset( $atts['style'] );
	$out = str_ireplace( '</li>', ( themify_shortcode_icon( $atts ) . '</li>' ), $content );
	return '<div class="shortcode themify-list '. $style . '">' . do_shortcode( $out ) . '</div>';
}
