"use strict";function _typeof(e){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function geocluster(e,t,a,o){return t=parseFloat(t),this instanceof geocluster?this._cluster(e,t,a,o):new geocluster(e,t,a,o)}geocluster.prototype._toRad=function(e){return e*Math.PI/180},geocluster.prototype._dist=function(e,t,a,o){var i=this._toRad(a-e),o=this._toRad(o-t),t=Math.sin(i/2)*Math.sin(i/2)+Math.sin(o/2)*Math.sin(o/2)*Math.cos(this._toRad(e))*Math.cos(this._toRad(a));return Math.round(2*Math.atan2(Math.sqrt(t),Math.sqrt(1-t))*6371*100)/100},geocluster.prototype._centroid=function(t){var e=Object.values(t).reduce(function(e,t){return{latitude:e.latitude+t.latitude,longitude:e.longitude+t.longitude}},{latitude:0,longitude:0});return Object.values(e).map(function(e){return e/Object.keys(t).length})},geocluster.prototype._clean=function(e){return e.map(function(e){return[e.centroid,e.elements]})},geocluster.prototype._cluster=function(e,t,a,o){for(var i,r,n=this,l=[],s=("number"==typeof t&&!isNaN(t)||(t=1),0),d=[],p=1;p<e.length;p++)s+=r=n._dist(e[p].latitude,e[p].longitude,e[p-1].latitude,e[p-1].longitude),d.push(r);for(var u=s/d.length,c=0,m=(d.forEach(function(e){c+=Math.pow(e-u,2)}),Math.sqrt(c/d.length),1e4*t),g=[],h=(g.push({centroid:e[Math.floor(.5*e.length)],elements:[],fill:a.fill,hover:a.hover,radius:a.radius}),!0);!0===h;){var M=!1,v=!1;e.forEach(function(o,e){var i=1/0,r=null;g.forEach(function(e,t){var a=n._dist(o.latitude,o.longitude,g[t].centroid.latitude,g[t].centroid.longitude);a<i&&(i=a,r=t)}),i<m||0===i?g[r].elements.push(o):(g.push({centroid:o,elements:[o]}),M=!0)}),(g=g.filter(function(e){return 0<e.elements.length})).forEach(function(e,t){var a=n._centroid(e.elements);h=!1,a.latitude===e.centroid.latitude&&a.longitude===e.centroid.longitude||(g[t].centroid=a,v=!0)}),v||M?h&&(g=g.map(function(e){return e.elements=[],e})):h=!1}return g=g.map(function(e){1===e.elements.length?l.push(e.elements[0]):(i={id:"",label:e.elements.length,name:"",value:e.elements.length,cluster:!0,latitude:e.centroid[0],longitude:e.centroid[1],elements:e.elements,content:"",fill:a.fill,hover:a.hover,radius:a.radius,action:""},o&&(i.tooltipTemplate=o),l.push(i))}),l};var iMapsRouter={getGeoFiles:function(e){var t,a,o=e.id.toString(),e=e.name,i={};return["southAmerica","northAmerica","europe","middleEast","asia","oceania","africa","antarctica"].includes(o)?(t="region/world/",a="_region_world_"):o=o.includes("US-")?(t="region/usa/",a="_region_usa_",o.substr(-2).toLowerCase()):(t="",a="_",e.toLowerCase().replace("united states","usa")),i.src="https://cdn.amcharts.com/lib/4/geodata/"+t+o+"Low.js",i.map="am4geodata"+a+o+"Low",i.title=e,i},getAllSrc:function(){var o={},e={main:"../../vendor/geodata",usa:"../../vendor/geodata/region/usa",world:"../../vendor/geodata/region/world"},t=require("fs");return Object.keys(e).forEach(function(a){o[a]=[],t.readdir(e[a],function(e,t){t.forEach(function(e){o[a].push(e)})})}),o},getVarByName:function(e){return void 0===e?"am4geodata_worldLow":e.includes("custom")?e:"am4geodata_"+(e=e.replace(/\//g,"_"))},getCleanMapName:function(e,t){return void 0!==e&&("custom"===(e=(e=e.replace("Low","")).replace("High",""))&&(e+=t),e)},iso2cleanName:function(e,t){var a,o=iMapsRouter.getCountries(),i=iMapsManager.maps[t].seriesIndex,r=!1;return console.log("ISO: "+e),"VA"===e?"vatican":"US"===e?"usa":e.includes("CA-")?"region/canada/"+e.replace("CA-","").toLowerCase():e.includes("MX-")?"region/mexico/"+e.replace("MX-","").toLowerCase():["africa","antarctiva","asia","europe","middleEast","northAmerica","oceania","southAmerica","centralAmerica"].includes(e)?"region/world/"+e:(e.includes("US-")?a=["region/usa/"+e.replace("US-","").toLowerCase(),"region/usa/congressional/"+e.replace("US-","").toLowerCase(),"region/usa/congressional2022/"+e.replace("US-","").toLowerCase()]:"GB"===e?a=["uk","ukCountries","ukCounties"]:"BA"===e?a=["bosniaHerzegovinaCantons","bosniaHerzegovina"]:"IL"===e?a=["israel","israelPalestine"]:"SI"===e?a=["sloveniaRegions","slovenia"]:"IN"===e?a=["india2019","india","india2020"]:"AE"===e?a=["unitedArabEmirates","uae"]:"FR"===e?a=["franceDepartments","france"]:"MG"===e?a=["madagascarProvince","madagascarRegion"]:"PT"===e?a=["portugal","portugalRegions"]:"RS"===e?a=["serbia","serbiaNoKosovo"]:"CD"===e?a=["congoDR"]:"CG"===e?a=["congo"]:"CZ"===e?a=["czechRepublic","czechia"]:"MM"===e&&(a=["myanmar"]),Array.isArray(a)&&(a.forEach(function(e,t){i.hasOwnProperty(e)&&(r=e)}),r)?r:!!o.hasOwnProperty(e)&&iMapsRouter.camelize(o[e]))},getCountries:function(){return JSON.parse('{"AF":"Afghanistan","AX":"Åland Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua & Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AC":"Ascension Island","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BA":"Bosnia & Herzegovina","BW":"Botswana","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","IC":"Canary Islands","CV":"Cape Verde","BQ":"Caribbean Netherlands","KY":"Cayman Islands","CF":"Central African Republic","EA":"Ceuta & Melilla","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo - Brazzaville","CD":"Congo - Kinshasa","CK":"Cook Islands","CR":"Costa Rica","CI":"Côte d’Ivoire","HR":"Croatia","CU":"Cuba","CW":"Curaçao","CY":"Cyprus","CZ":"Czechia","DK":"Denmark","DG":"Diego Garcia","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","SZ":"Eswatini","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HN":"Honduras","HK":"Hong Kong SAR China","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","XK":"Kosovo","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao SAR China","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar (Burma)","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","KP":"North Korea","MK":"North Macedonia","MP":"Northern Mariana Islands","NO":"Norway","OM":"Oman","PK":"Pakistan","PW":"Palau","PS":"Palestinian Territories","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn Islands","PL":"Poland","PT":"Portugal","XA":"Pseudo-Accents","XB":"Pseudo-Bidi","PR":"Puerto Rico","QA":"Qatar","RE":"Réunion","RO":"Romania","RU":"Russia","RW":"Rwanda","WS":"Samoa","SM":"San Marino","ST":"São Tomé & Príncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SX":"Sint Maarten","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia & South Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","BL":"St Barthélemy","SH":"St Helena","KN":"St Kitts & Nevis","LC":"St Lucia","MF":"St Martin","PM":"St Pierre & Miquelon","VC":"St Vincent & Grenadines","SD":"Sudan","SR":"Suriname","SJ":"Svalbard & Jan Mayen","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad & Tobago","TA":"Tristan da Cunha","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks & Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom","US":"United States","UY":"Uruguay","UM":"US Outlying Islands","VI":"US Virgin Islands","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican City","VE":"Venezuela","VN":"Vietnam","WF":"Wallis & Futuna","EH":"Western Sahara","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"}')},camelize:function(e){return e.replace(/(?:^\w|[A-Z]|\b\w)/g,function(e,t){return 0==t?e.toLowerCase():e.toUpperCase()}).replace(/\s+/g,"")}},iMapsModel={prepareData:function(o){return o&&Array.isArray(o)&&o.forEach(function(e,a){o[a]=iMapsModel.iterateData(e),Array.isArray(o[a].overlay)&&0<o[a].overlay.length&&o[a].overlay.forEach(function(e,t){o[a].overlay[t].map!==o[a].map||iMapsManager.bool(o[a].allowEmpty)||(o[a].overlay[t].include=iMapsModel.prepareOverlayInclude(e)),o[a].overlay[t]=iMapsModel.iterateData(e)})}),o},prepareOverlayInclude:function(e){var a=e.includes||"";return e.regions&&e.regions.forEach(function(e,t){a+=","+e.id}),a},iterateData:function(e){var t="igm_custom_filter_"+(e="function"==typeof igm_custom_filter?igm_custom_filter(e):e).id;return"function"==typeof window[t]&&(e=window[t](e)),e=iMapsModel.prepareColor(e),e=iMapsModel.prepareExcludeIncludes(e),e=iMapsModel.coordinatesToInt(e),e=iMapsModel.prepareEntriesData(e),e=iMapsModel.prepareGroupedRegions(e),e=iMapsModel.prepareImageFields(e),e=iMapsModel.prepareMultiGeoLine(e)},prepareMultiGeoLine:function(e){return Array.isArray(e.lines)&&e.lines.length&&(e.lines=e.lines.filter(function(e){if(Array.isArray(e.multiGeoLine)&&e.multiGeoLine.length)return e}),e.lines.map(function(e){e.arrow=void 0!==e.arrow&&iMapsManager.bool(e.arrow),e.arrowDisabled=!e.arrow,e.multiGeoLine.map(function(e){Object.assign(e,e.coordinates),delete e.coordinates})})),e},prepareImageFields:function(e){return Array.isArray(e.imageMarkers)&&Array.isArray(e.imageMarkers)&&e.imageMarkers.map(function(e){return void 0===e.href&&e.image&&(Array.isArray(e.image)||"object"==typeof e.image)&&(e.href=e.image.url),e}),e},prepareGroupedRegions:function(t){var o,i,r;if(Array.isArray(t.regions)&&t.regions.length){if(void 0===t.regionGroups&&(t.regionGroups=[]),iMapsManager.bool(t.regionsGroupHover))return t.regionGroups.push(t.regions),t;t.regions.map(function(a,e){if(!a.id||!String(a.id).includes(","))return a;i=[],r=[],a.id.split(",").forEach(function(e,t){(o=Object.assign({},a)).id=e.trim(),o.originalID=a.id,isNaN(o.id),r.includes(o.id)||(r.push(o.id),i.push(o))}),t.regionGroups.push(i),t.regions.splice(e,-1)})}return t},prepareTooltip:function(e,t){var a,o,i;if(void 0!==t&&void 0!==e){if(t=void 0!==t.maxWidth&&""!==t.maxWidth&&parseInt(t.maxWidth),a=iMapsModel.isMSIE())return iMapsModel.removeHTMLtags(e);e&&e.includes("<img")&&((o=document.createRange()).selectNode(document.getElementsByTagName("div").item(0)),0<(i=(o=o.createContextualFragment(e)).querySelectorAll("img")).length)&&(i.forEach(function(e){0!==e.width&&""===e.style.width&&(e.style.width=e.width+"px"),0!==e.height&&""===e.style.height&&(e.style.height=e.height+"px")}),(i=document.createElement("div")).appendChild(o.cloneNode(!0)),e=i.innerHTML),t&&""!==e&&!a&&(e='<div class="imapsInnerTooltip" style="max-width:'+t+'px">'+e+"</div>")}return e},isMSIE:function(){return window.navigator.userAgent.match(/(MSIE|Trident)/)},removeHTMLtags:function(e){return null===e||""===e?"":(e=e.toString()).replace(/<[^>]*>/g,"")},prepareEntriesData:function(t){t.heatMapMarkers&&"1"===t.heatMapMarkers.enabled&&(t.heatMapMarkers.minRadius=parseInt(t.heatMapMarkers.minRadius),t.heatMapMarkers.maxRadius=parseInt(t.heatMapMarkers.maxRadius));var a=t.id;return Array.isArray(t.regions)&&t.regions.length&&(t.regions.map(function(e){return void 0!==e.useDefaults&&"1"!==e.useDefaults||Object.assign(e,t.regionDefaults),void 0!==e.action&&"default"===e.action&&(e.action=t.regionDefaults.action),void 0!==t.regionDefaults.triggerClickOnHover&&"1"===t.regionDefaults.triggerClickOnHover&&(e.triggerClickOnHover=!0),void 0!==t.regionActiveState&&"1"===t.regionActiveState.enabled&&(e.activeState=!0),t.regionLabels&&"custom"===t.regionLabels.source&&void 0!==t.regionLabels.customSource&&(t.regionLabels.customSource.includes(".")?e.autoLabel=t.regionLabels.customSource.split(".").reduce(function(e,t){return e[t]||0},e):e.autoLabel=e[t.regionLabels.customSource]),t.heatMapRegions&&"1"===t.heatMapRegions.enabled&&(t.heatMapRegions.source.includes(".")&&(e.heatMapRegionRef=t.heatMapRegions.source.split(".").reduce(function(e,t){return e[t]||0},e)),delete e.fill),void 0!==t.visual.borderColorHover&&t.visual.borderColorHover!==t.visual.borderColor&&(e.borderColorHover=t.visual.borderColorHover),void 0!==t.visual.borderWidthHover&&t.visual.borderWidthHover!==t.visual.borderWidth&&(e.borderWidthHover=t.visual.borderWidthHover),e.tooltipContent=iMapsModel.prepareTooltip(e.tooltipContent,t.tooltip),e.mapID=a,e.value&&void 0!==_typeof(e.value)&&""!==e.value&&(e.val=e.value,e.value=parseFloat(e.value)),e}),t.heatMapRegions)&&t.heatMapRegions.source.includes(".")&&(t.heatMapRegions.source="heatMapRegionRef"),Array.isArray(t.roundMarkers)&&t.roundMarkers.length&&(t.roundMarkers.map(function(e){return void 0!==e.useDefaults&&"1"!==e.useDefaults||Object.assign(e,t.markerDefaults),e.coordinates&&(e.latitude=e.coordinates.latitude,e.longitude=e.coordinates.longitude),"string"==typeof e.latitude&&(e.latitude=parseFloat(e.latitude)),"string"==typeof e.longitude&&(e.longitude=parseFloat(e.latitude)),void 0===e.name&&(e.name=e.id),t.roundMarkersMobileSize&&100!==parseInt(t.roundMarkersMobileSize)&&window.innerWidth<=780&&(e.radius=parseFloat(e.radius)*parseFloat(t.roundMarkersMobileSize)/100),t.heatMapMarkers&&"1"===t.heatMapMarkers.enabled&&(isNaN(e.value)||(e.value=parseFloat(e.value)),t.heatMapMarkers.source.includes(".")&&(e.heatMapMarkerRef=t.heatMapMarkers.source.split(".").reduce(function(e,t){return e[t]||0},e)),delete e.fill,delete e.radius),e.value&&void 0!==_typeof(e.value)&&""!==e.value&&(e.val=e.value,e.value=parseFloat(e.value)),"default"===e.action&&(e.action=t.markerDefaults.action),void 0!==t.markerDefaults.triggerClickOnHover&&"1"===t.markerDefaults.triggerClickOnHover&&(e.triggerClickOnHover=!0),void 0!==t.triggerRegionHover&&"1"===t.triggerRegionHover.enabled&&(e.triggerRegionHover=!0),e.tooltipContent=iMapsModel.prepareTooltip(e.tooltipContent,t.tooltip),e.mapID=a,e}),t.roundMarkers=t.roundMarkers.filter(function(e){return void 0!==e.latitude&&""!==e.latitude&&""!==e.name}),t.heatMapMarkers)&&t.heatMapMarkers.source.includes(".")&&(t.heatMapMarkers.source="heatMapMarkerRef"),Array.isArray(t.iconMarkers)&&t.iconMarkers.length&&t.iconMarkers.map(function(e){return void 0!==e.useDefaults&&"1"!==e.useDefaults||Object.assign(e,t.iconMarkerDefaults),e.coordinates&&(e.latitude=e.coordinates.latitude,e.longitude=e.coordinates.longitude),void 0===e.name&&(e.name=e.id),"default"===e.action&&(e.action=t.iconMarkerDefaults.action),void 0!==t.iconMarkerDefaults.triggerClickOnHover&&"1"===t.iconMarkerDefaults.triggerClickOnHover&&(e.triggerClickOnHover=!0),t.iconMarkersMobileSize&&100!==parseInt(t.iconMarkersMobileSize)&&window.innerWidth<=780&&(e.scale=parseFloat(e.scale)*parseFloat(t.iconMarkersMobileSize)/100),e.val=e.value,e.value=parseFloat(e.value),e.tooltipContent=iMapsModel.prepareTooltip(e.tooltipContent,t.tooltip),e.mapID=a,e}),Array.isArray(t.imageMarkers)&&t.imageMarkers.length&&t.imageMarkers.map(function(e){return void 0!==e.useDefaults&&"1"!==e.useDefaults||Object.assign(e,t.imageMarkerDefaults),e.coordinates&&(e.latitude=e.coordinates.latitude,e.longitude=e.coordinates.longitude),void 0!==e.nonScaling&&(e.nonScaling=iMapsManager.bool(e.nonScaling)),void 0===e.size&&(e.size=t.imageMarkerDefaults.size),void 0===e.horizontalCenter&&(e.horizontalCenter=t.imageMarkerDefaults.horizontalCenter),void 0===e.verticalCenter&&(e.verticalCenter=t.imageMarkerDefaults.verticalCenter),void 0===e.name&&(e.name=e.id),"default"!==e.action&&void 0!==e.action||(e.action=t.imageMarkerDefaults.action),void 0!==t.imageMarkerDefaults.triggerClickOnHover&&"1"===t.imageMarkerDefaults.triggerClickOnHover&&(e.triggerClickOnHover=!0),t.imageMarkersMobileSize&&100!==parseInt(t.imageMarkersMobileSize)&&window.innerWidth<=780&&(e.size=parseFloat(e.size)*parseFloat(t.imageMarkersMobileSize)/100),e.val=e.value,e.value=parseFloat(e.value),e.tooltipContent=iMapsModel.prepareTooltip(e.tooltipContent,t.tooltip),e.mapID=a,e}),Array.isArray(t.labels)&&t.labels.length&&t.labels.map(function(e){return void 0!==e.useDefaults&&"1"!==e.useDefaults||(Object.assign(e,t.labelDefaults),Object.assign(e,t.labelPosition)),e.coordinates&&(Object.assign(e,e.coordinates),delete e.coordinates),"default"===e.action&&(e.action=t.labelDefaults.action),void 0!==t.labelDefaults.triggerClickOnHover&&"1"===t.labelDefaults.triggerClickOnHover&&(e.triggerClickOnHover=!0),void 0!==e.size&&(e.fontSize=e.size),t.labelsMobileSize&&100!==parseInt(t.labelsMobileSize)&&window.innerWidth<=780&&(e.fontSize=parseInt(e.fontSize)*parseInt(t.labelsMobileSize)/100,e.size=e.fontSize),e.tooltipContent=iMapsModel.prepareTooltip(e.tooltipContent,t.tooltip),e.mapID=a,e}),Array.isArray(t.lines)&&t.lines.length&&t.lines.map(function(e){return void 0!==e.useDefaults&&"1"!==e.useDefaults||Object.assign(e,t.lineDefaults),e.curvature=parseFloat(e.curvature),e}),t},prepareExcludeIncludes:function(a){return void 0!==a.onlyIncludeActive&&1===parseInt(a.onlyIncludeActive)?(a.include=[],a.exclude=[],a.regions&&a.regions.forEach(function(e,t){a.include.push(e.id),isNaN(e.id)||a.include.push(parseInt(e.id))})):(a.exclude&&"string"==typeof a.exclude&&a.exclude.trim().length&&(a.exclude=a.exclude.split(",").map(function(e){return e.trim()})),a.include&&a.include.trim().length&&(a.include=a.include.split(",").map(function(e){return e.trim()}),a.include.map(function(e){isNaN(e)||a.include.push(parseInt(e))}))),a}},iMapsManager=(iMapsModel.coordinatesToInt=function(e){return function i(r){"object"===_typeof(r)&&null!==r&&Object.keys(r).map(function(e,t){var a,o;"object"===_typeof(r[e])&&("coordinates"===e||"homeGeoPoint"===e?((o=r)[a=e].latitude=Number(o[a].latitude),o[a].longitude=Number(o[a].longitude)):void 0===r.className&&i(r[e]))})}(e),e},iMapsModel.prepareColor=function(e){var r=["inactiveColor","activeColor","hoverColor","hover","inactiveHoverColor","backgroundColor","color","minColor","maxColor","fill","projectionBackgroundColor","borderColor","borderColorHover"],n=function(e){var e=e.split("|"),t="undefined"!=typeof igmGradientType?igmGradientType:"LinearGradient",a="undefined"!=typeof igmGradientOffset&&Array.isArray(igmGradientOffset)?igmGradientOffset:[],o=new am4core[t];return e.forEach(function(e,t){o.addColor(am4core.color(e),1,a[t])}),o.rotation="undefined"!=typeof igmGradientRotation?igmGradientRotation:0,o},l=function(e){var t=new am4core.Pattern,a=(t.width=150,t.height=150,t.strokeWidth=0,t.stroke=am4core.color("#6699cc"),new am4core.Image);return a.href=e,a.width=150,a.height=150,a.x=0,a.y=0,a.verticalCenter="middle",a.valign="middle",t.addElement(a.element),t.addElement(a.element),t.addElement(a.element),t};return function o(i){"object"===_typeof(i)&&null!==i&&Object.keys(i).map(function(e,t){var a;"object"===_typeof(i[e])?o(i[e]):void 0===i.className&&(e=e,a=i,r.includes(e))&&(a[e].includes("|")?a[e]=n(a[e]):a[e].startsWith("http")?a[e]=l(a[e]):"hover"!==e||"transparent"!==a[e]&&!a[e].endsWith(",0)")?"transparent"===a[e]?a[e]=am4core.color("rgba(0,0,0,0)"):a[e]=am4core.color(a[e]):a[e]=am4core.color("rgba(0,0,0,0.001)"))})}(e),e},iMapsModel.extractCodes=function(e){for(var t={},a=0;a<e.features.length;a++)t[e.features[a].properties.id]=e.features[a].properties.name;return t},{maps:{},init:function(e){this.addMap(e)},addMap:function(e){var t,a,o,i,r=this,n=iMapsData.data[e],l=n.id,s=document.getElementById(n.container);n.disabled||null!==s&&(i=s.closest(".map_aspect_ratio"),void 0!==r.maps[l]&&r.maps[l].map.dispose(),window.innerWidth<=780&&void 0!==n.visual.paddingTop&&""!==n.visual.paddingTop?i.style.paddingTop=String(n.visual.paddingTopMobile)+"%":i.style.paddingTop=String(n.visual.paddingTop)+"%",window.addEventListener("resize",function(){window.innerWidth<=780&&void 0!==n.visual.paddingTop&&""!==n.visual.paddingTop?i.style.paddingTop=String(n.visual.paddingTopMobile)+"%":i.style.paddingTop=String(n.visual.paddingTop)+"%"}),n.visual.maxWidth,""!==n.visual.fontFamily&&"inherit"!==n.visual.fontFamily&&(s.closest(".map_box").style.fontFamily=n.visual.fontFamily),r.maps[l]={map:am4core.create(n.container,am4maps.MapChart),series:[],clusterSeries:{},seriesIndex:{},seriesById:{},data:n,allBaseSeries:[],labelSeries:[],baseRegionSeries:{},groupedBaseRegionSeries:[],backgroundSeries:{}},(t=r.maps[l].map).readerTitle="Interactive Map",e=r.maps[l].clusterSeries,t.events.on("ready",function(e){var t=new Event("mapready");s.dispatchEvent(t),r.triggerOnReady(l,n)}),t.events.on("appeared",function(e){var t=new Event("mapappeared");s.dispatchEvent(t),r.triggerOnAppeared(l,n),s.classList.remove("map_loading")}),void 0!==iMapsData.options&&void 0!==iMapsData.options.locale&&iMapsData.options.locale&&void 0!==window["am4lang_"+iMapsData.options.locale]&&(t.language.locale=window["am4lang_"+iMapsData.options.locale]),n.zoom&&n.zoom.smallMap&&r.bool(n.zoom.smallMap)&&(t.smallMap=new am4maps.SmallMap),"custom"===n.map||r.bool(n.useGeojson)?t.geodataSource.url=n.mapURL:(o=iMapsRouter.getVarByName(n.map),t.geodata=window[o]),void 0!==iMapsData.options&&void 0!==iMapsData.options.lang&&iMapsData.options.lang&&void 0!==window["am4geodata_lang_"+iMapsData.options.lang]&&(t.geodataNames=window["am4geodata_lang_"+iMapsData.options.lang]),t.projection=new am4maps.projections[n.projection],n.map.startsWith("usaTerritories")&&t.events.on("ready",function(e){t.projection=new am4maps.projections[n.projection]}),t.fontFamily=n.visual.fontFamily,n.exportMenu&&r.bool(n.exportMenu.enable)&&(t.exporting.menu=new am4core.ExportMenu,t.exporting.menu.items[0].icon="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CiA8Zz4KICA8dGl0bGU+YmFja2dyb3VuZDwvdGl0bGU+CiAgPHJlY3QgeD0iLTEiIHk9Ii0xIiB3aWR0aD0iNS45NDQ3NzMiIGhlaWdodD0iNS45NDQ3NzMiIGlkPSJjYW52YXNfYmFja2dyb3VuZCIgZmlsbD0ibm9uZSIvPgogPC9nPgoKIDxnPgogIDx0aXRsZT5MYXllciAxPC90aXRsZT4KICA8cGF0aCBzdHJva2U9Im51bGwiIGQ9Im0xNC40MjcwMzEsMTUuNzQwNDAxcTAsLTAuMjU3NjQzIC0wLjE4ODI3NCwtMC40NDU5MTd0LTAuNDQ1OTE3LC0wLjE4ODI3NHQtMC40NDU5MTcsMC4xODgyNzR0LTAuMTg4Mjc0LDAuNDQ1OTE3dDAuMTg4Mjc0LDAuNDQ1OTE3dDAuNDQ1OTE3LDAuMTg4Mjc0dDAuNDQ1OTE3LC0wLjE4ODI3NHQwLjE4ODI3NCwtMC40NDU5MTd6bTIuNTM2NzgsMHEwLC0wLjI1NzY0MyAtMC4xODgyNzQsLTAuNDQ1OTE3dC0wLjQ0NTkxNywtMC4xODgyNzR0LTAuNDQ1OTE3LDAuMTg4Mjc0dC0wLjE4ODI3NCwwLjQ0NTkxN3QwLjE4ODI3NCwwLjQ0NTkxN3QwLjQ0NTkxNywwLjE4ODI3NHQwLjQ0NTkxNywtMC4xODgyNzR0MC4xODgyNzQsLTAuNDQ1OTE3em0xLjI2ODM5LC0yLjIxOTY4NWwwLDMuMTcwOTdxMCwwLjM5NjM3NCAtMC4yNzc0NjEsMC42NzM4MzR0LTAuNjczODM0LDAuMjc3NDYxbC0xNC41ODY0NywwcS0wLjM5NjM3NCwwIC0wLjY3MzgzNCwtMC4yNzc0NjF0LTAuMjc3NDYxLC0wLjY3MzgzNGwwLC0zLjE3MDk3cTAsLTAuMzk2Mzc0IDAuMjc3NDYxLC0wLjY3MzgzNHQwLjY3MzgzNCwtMC4yNzc0NjFsNC42MDc4MTYsMGwxLjMzNzc1MSwxLjM0NzY1OXEwLjU3NDczOCwwLjU1NDkyMSAxLjM0NzY1OSwwLjU1NDkyMXQxLjM0NzY1OSwtMC41NTQ5MjFsMS4zNDc2NTksLTEuMzQ3NjU5bDQuNTk3OTA4LDBxMC4zOTYzNzQsMCAwLjY3MzgzNCwwLjI3NzQ2MXQwLjI3NzQ2MSwwLjY3MzgzNGwwLjAwMDAxOCwwem0tMy4yMjA1MjMsLTUuNjM4MzlxMC4xNjg0NTYsMC40MDYyODIgLTAuMTM4NzMsMC42OTM2NTFsLTQuNDM5MzYsNC40MzkzNnEtMC4xNzgzNjUsMC4xODgyNzQgLTAuNDQ1OTE3LDAuMTg4Mjc0dC0wLjQ0NTkxNywtMC4xODgyNzRsLTQuNDM5MzYsLTQuNDM5MzZxLTAuMzA3MTg3LC0wLjI4NzM2OSAtMC4xMzg3MywtMC42OTM2NTFxMC4xNjg0NTYsLTAuMzg2NDY1IDAuNTg0NjQ3LC0wLjM4NjQ2NWwyLjUzNjc4LDBsMCwtNC40MzkzNnEwLC0wLjI1NzY0MyAwLjE4ODI3NCwtMC40NDU5MTd0MC40NDU5MTcsLTAuMTg4Mjc0bDIuNTM2NzgsMHEwLjI1NzY0MywwIDAuNDQ1OTE3LDAuMTg4Mjc0dDAuMTg4Mjc0LDAuNDQ1OTE3bDAsNC40MzkzNmwyLjUzNjc4LDBxMC40MTYxOTEsMCAwLjU4NDY0NywwLjM4NjQ2NXoiIGlkPSJzdmdfMSIvPgogPC9nPgo8L3N2Zz4=",t.exporting.menu.align=n.exportMenu.align||"right",t.exporting.menu.verticalAlign=n.exportMenu.verticalAlign||"top"),n.touchInterface&&(r.bool(n.touchInterface.tapToActivate)&&(t.tapToActivate=!0,t.tapTimeout=n.touchInterface.tapTimeout),r.bool(n.touchInterface.dragGrip))&&(t.dragGrip.disabled=!1,t.dragGrip.autoHideDelay=n.touchInterface.dragGripAutoHideDelay),t.background.fill=n.visual.backgroundColor,t.background.fillOpacity=n.visual.backgroundOpacity,t.backgroundSeries.mapPolygons.template.focusable=!1,t.background.focusable=!1,t.backgroundSeries.focusable=!1,void 0!==n.visual.bgImage&&void 0!==n.visual.bgImage.url&&""!==n.visual.bgImage.url&&((o=t.series.push(new am4maps.MapImageSeries)).toBack(),(a=o.mapImages.template.createChild(am4core.Image)).propertyFields.href="src",a.width=t.width,a.height=t.height,o.data=[{src:n.visual.bgImage.url}],r.maps[l].backgroundSeries=o),t.exporting.backgroundColor=n.visual.backgroundColor,t.exporting.filePrefix="interactive_map",t.exporting.useWebFonts=!1,"Orthographic"===n.projection&&n.grid&&((a=t.series.push(new am4maps.GraticuleSeries)).mapLines.template.line.stroke=n.grid.color,a.mapLines.template.line.strokeOpacity=1,a.fitExtent=!1,t.backgroundSeries.mapPolygons.template.polygon.fillOpacity=1,t.backgroundSeries.mapPolygons.template.polygon.fill=n.grid.projectionBackgroundColor),r.handleZoom(l),n.legend&&r.bool(n.legend.enabled)&&(t.legend=new am4maps.Legend,"top"===n.legend.position||"bottom"===n.legend.position?(t.legend.contentAlign=n.legend.align,t.legend.valign=n.legend.position):(t.legend.position=n.legend.position,t.legend.align=n.legend.position,t.legend.valign=n.legend.valign),void 0!==n.legend.style&&"default"!==n.legend.style&&r.setLegendStyle(l,t.legend,n.legend.style),void 0!==_typeof(n.legend.fill)&&(t.legend.labels.template.fill=n.legend.fill),"false"===n.legend.clickable&&(t.legend.itemContainers.template.interactionsEnabled=!1),"toggle"===n.legend.clickable&&t.legend.itemContainers.template.events.on("hit",function(e){iMapsManager.clearSelected(l)}),"select"===n.legend.clickable)&&(t.legend.itemContainers.template.togglable=!1,t.legend.itemContainers.template.events.on("hit",function(e){iMapsManager.clearSelected(l);var t=[];"MapPolygonSeries"===r.getTargetSeriesType(e.target.dataItem.dataContext)&&(e.target.dataItem.dataContext.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||(e.setState("active"),e.isActive=!0,e.isHover=!1,t.push(e))}),r.maps[l].selected=t)}),t.legend.itemContainers.template.events.on("over",function(e){var t=r.getTargetSeriesType(e.target.dataItem.dataContext);"MapImageSeries"===t?e.target.dataItem.dataContext.mapImages.each(function(e){e.setState("highlight")}):"MapPolygonSeries"===t&&e.target.dataItem.dataContext.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||e.setState("highlight")})}),t.legend.itemContainers.template.events.on("out",function(e){var t=r.getTargetSeriesType(e.target.dataItem.dataContext);"MapImageSeries"===t?e.target.dataItem.dataContext.mapImages.each(function(e){e.setState("default")}):"MapPolygonSeries"===t&&e.target.dataItem.dataContext.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||e.setState("default")})})),n.customLegend&&r.bool(n.customLegend.enabled)&&(o=void 0!==n.customLegend.type?n.customLegend.type:"internal",n.customLegend.data)&&Array.isArray(n.customLegend.data)&&"internal"===o&&((a=new am4maps.Legend).parent=t.chartContainer,a.data=n.customLegend.data,void 0!==n.customLegend.style&&"default"!==n.customLegend.style&&r.setLegendStyle(l,a,n.customLegend.style),a.itemContainers.template.clickable=!1,a.itemContainers.template.focusable=!1,a.itemContainers.template.hoverable=!1,a.itemContainers.template.cursorOverStyle=am4core.MouseCursorStyle.default,a.labels.template.truncate=!1,a.labels.template.wrap=!0,"top"===n.customLegend.position||"bottom"===n.customLegend.position?(a.contentAlign=n.customLegend.align,a.valign=n.customLegend.position):(a.position=n.customLegend.position,a.align=n.customLegend.position,a.valign=n.customLegend.valign),void 0!==_typeof(n.customLegend.fill))&&(a.labels.template.fill=n.customLegend.fill),o=r.pushRegionSeries(l,n),r.maps[l].baseRegionSeries=o,Array.isArray(n.regionGroups)&&n.regionGroups.length&&(a=r.pushGroupSeries(l,n),r.maps[l].groupedBaseRegionSeries=a),Array.isArray(n.overlay)&&n.overlay.length&&n.overlay.forEach(function(e){r.pushSeries(l,e)}),Array.isArray(n.lines)&&n.lines.length&&r.pushLineSeries(l,n),Array.isArray(n.roundMarkers)&&n.roundMarkers.length&&(o=r.pushRoundMarkerSeries(l,n),n.clusterMarkers)&&r.bool(n.clusterMarkers.enabled)&&(o.hidden=!0,r.setupClusters(n,l),e[l].zoomLevels[n.clusterMarkers.zoomLevel]=o,e[l].zoomLevels[1])&&(e[l].zoomLevels[1].hidden=!1,r.maps[l].allBaseSeries.push(e[l].zoomLevels[1])),Array.isArray(n.imageMarkers)&&n.imageMarkers.length&&(a=r.pushImageMarkerSeries(l,n),r.maps[l].allBaseSeries.push(a)),Array.isArray(n.iconMarkers)&&n.iconMarkers.length&&(o=r.pushIconMarkerSeries(l,n),r.maps[l].allBaseSeries.push(o)),Array.isArray(n.labels)&&n.labels.length&&(e=r.pushLabelSeries(l,n),r.maps[l].allBaseSeries.push(e)),r.handleInfoBox(l))},setLegendStyle:function(e,t,a){var a={xsmall:10,small:13,regular:16,large:19,larger:23}[a],o=t.markers.template;t.labels.template.fontSize=a,t.useDefaultMarker=!0,o.width=a,o.height=a},handleZoom:function(t){var e,a,d=this,o=d.maps[t].map,p=d.maps[t].data,i=(d.maps[t].series,d.maps[t].allBaseSeries,!0),r=!0;void 0!==p.viewport&&1<=parseFloat(p.viewport.zoomLevel)&&(o.homeZoomLevel=parseFloat(p.viewport.zoomLevel),o.seriesContainer.resizable=r=!1,o.seriesContainer.draggable=!1,o.chartContainer.wheelable=!1),void 0!==p.viewport&&p.viewport.homeGeoPoint&&0!==p.viewport.homeGeoPoint.latitude&&0!==p.viewport.homeGeoPoint.longitude&&(o.homeGeoPoint=p.viewport.homeGeoPoint),void 0!==p.viewport&&p.viewport.offset&&(""!==p.viewport.offset.longitude&&"0"!==p.viewport.offset.longitude&&(i=!1,o.deltaLongitude=p.viewport.offset.longitude),""!==p.viewport.offset.latitude&&"0"!==p.viewport.offset.latitude&&(i=!1,o.deltaLatitude=p.viewport.offset.latitude),i)&&iMapsManager.latlongOffsetFix(p,o,r),void 0===p.viewport&&iMapsManager.latlongOffsetFix(p,o,r),void 0===p.zoom?(void 0!==p.zoomMaster&&d.bool(p.zoomMaster)?(o.seriesContainer.draggable=!0,o.seriesContainer.resizable=!0,o.zoomControl=new am4maps.ZoomControl,o.zoomControl.focusable=!1,o.zoomControl.exportable=!1,o.zoomControl.children&&o.zoomControl.children.values&&o.zoomControl.children.values.forEach(function(e){e.focusable=!1}),o.zoomControl.align="right",o.zoomControl.valign="bottom"):(o.seriesContainer.resizable=!1,o.seriesContainer.draggable=!1),o.seriesContainer.events.disableType("doublehit"),o.chartContainer.background.events.disableType("doublehit"),o.chartContainer.wheelable=!1):("Orthographic"!==p.projection?(o.seriesContainer.draggable=!!p.zoom&&d.bool(p.zoom.draggable),o.seriesContainer.resizable=!!p.zoom&&d.bool(p.zoom.draggable),d.bool(p.zoom.draggable)&&(o.seriesContainer.cursorDownStyle=am4core.MouseCursorStyle.grabbing),o.centerMapOnZoomOut=!1,o.maxPanOut=0,d.bool(p.zoom.enabled)&&!d.bool(p.zoom.draggable)&&d.bool(p.zoom.mobileResizable)&&/Mobi|Android/i.test(navigator.userAgent)&&(o.seriesContainer.draggable=!0,o.seriesContainer.resizable=!0)):(o.seriesContainer.draggable=!1,o.seriesContainer.resizable=!1,o.panBehavior="rotateLongLat"),d.bool(p.zoom.enabled)?(o.chartContainer.wheelable=d.bool(p.zoom.wheelable),d.bool(p.zoom.doubleHitZoom)||(o.seriesContainer.events.disableType("doublehit"),o.chartContainer.background.events.disableType("doublehit")),void 0!==p.zoom.maxZoomLevel&&(o.maxZoomLevel=parseInt(p.zoom.maxZoomLevel)),d.bool(p.zoom.controls)&&(o.zoomControl=new am4maps.ZoomControl,o.zoomControl.exportable=!1,o.zoomControl.children&&o.zoomControl.children.values&&o.zoomControl.children.values.forEach(function(e){e.focusable=!1}),o.zoomControl.exportable=!1,o.zoomControl.align=p.zoom.controlsPositions?p.zoom.controlsPositions.align:"right",o.zoomControl.valign=p.zoom.controlsPositions?p.zoom.controlsPositions.valign:"bottom",void 0!==p.zoom.homeButton&&!d.bool(p.zoom.homeButton)||((e=new am4core.Button).focusable=!1,e.events.on("hit",function(){o.goHome(),iMapsManager.resetDrilldown(t),"undefined"!=typeof iMapsActions&&void 0!==iMapsActions.resetActions&&iMapsActions.resetActions(t)}),e.icon=new am4core.Sprite,e.padding(7,5,7,5),e.width=30,e.icon.path="M16,8 L14,8 L14,16 L10,16 L10,10 L6,10 L6,16 L2,16 L2,8 L0,8 L8,0 L16,8 Z M16,8",e.marginBottom=3,e.parent=o.zoomControl,e.insertBefore(o.zoomControl.plusButton),o.events.on("inited",function(){e.deepInvalidate()}))),d.bool(p.zoom.externalControls)&&iMapsManager.handleExternalZoom(p.id)):(o.maxZoomLevel=parseFloat(p.viewport.zoomLevel),o.seriesContainer.events.disableType("doublehit"),o.chartContainer.background.events.disableType("doublehit"),o.seriesContainer.draggable=!1,o.seriesContainer.resizable=!1,o.chartContainer.wheelable=!1),void 0!==p.fullScreen&&d.bool(p.fullScreen.enabled)&&((a=o.chartContainer.createChild(am4core.Button)).events.on("hit",function(e){var t=document.querySelector("#map_"+e.target.icon.mapID).closest(".map_wrapper");iMapsManager.toggleFullscreen(t),iMapsManager.isFullScreen=e.target}),a.align=p.fullScreen.align,a.valign=p.fullScreen.valign,a.margin(5,5,5,5),a.padding(5,0,5,0),a.width=30,a.icon=new am4core.Sprite,a.icon.path=iMapsManager.library.icons.goFullIconPath,a.icon.isFullScreen=!1,a.icon.mapID=t,d.bool(p.fullScreen.mobileOnly)?a.id="_fullscreen_button_only_mobile":a.id="_fullscreen_button",o.events.on("inited",function(){a.deepInvalidate()})),o.events.on("mappositionchanged",function(e){}),o.events.on("zoomlevelchanged",function(e){var a,o=d.maps[t].clusterSeries,i=e.target.zoomLevel,r=d.bool(d.maps[t].data.drillDownOnClick),n=d.maps[t].isDrilling,l=d.maps[t].drilledTo,s=d.filteredMap;o&&Object.keys(o).length&&Object.keys(o).forEach(function(t){r&&o[t].overlay||s?n&&l&&parseInt(l)===parseInt(o[t].overlay)||parseInt(s)===parseInt(o[t].overlay)||!r&&!d.bool(p.liveFilter.enabled)?(a=d.getClosest(o[t].zoomLevels,i),Object.keys(o[t].zoomLevels).forEach(function(e){o[t].zoomLevels[e].hide(),parseFloat(e)===a?o[t].zoomLevels[e].show():o[t].zoomLevels[e].hide()})):Object.keys(o[t].zoomLevels).forEach(function(e){o[t].zoomLevels[e].hide()}):(a=d.getClosest(o[t].zoomLevels,i),Object.keys(o[t].zoomLevels).forEach(function(e){o[t].zoomLevels[e].hide(),parseFloat(e)===a?o[t].zoomLevels[e].show():o[t].zoomLevels[e].hide()}))})}))},getClosest:function(e,a){return Object.keys(e).reduce(function(e,t){return e=parseInt(e),t=parseInt(t),Math.abs(t-a)<Math.abs(e-a)?t:e})},resetDrilldown:function(e){var t=this,a=t.maps[e].data,o=t.maps[e].series,i=t.maps[e].allBaseSeries,r=t.maps[e].backgroundSeries;if(t.bool(a.drillDownOnClick)){for(var n=0,l=o.length;n<l;n++)o[n].hide();for(var s=0,d=i.length;s<d;s++)i[s].show(),r.mapPolygons&&r.show();iMapsManager.maps[e].drilledTo=!1,iMapsManager.maps[e].isDrilling=!1}},latlongOffsetFix:function(e,t,a){var o=e.map;["russiaLow","russiaHigh","russiaCrimeaLow","russiaCrimeaHigh","region/world/asiaLow","region/world/asiaHigh","region/world/asiaUltra","region/world/asiaIndiaLow","region/world/asiaIndiaHigh","region/world/asiaIndiaUltra"].includes(o)&&e.exclude&&!e.exclude.includes("RU")&&(t.deltaLongitude=-100,a)&&(t.homeZoomLevel=1.5),"newZealandLow"!==o&&"newZealandHigh"!=o||(t.deltaLongitude=20)},pushGroupSeries:function(o,i){var r,n=[];return i.regionGroups.forEach(function(e){var t={},a=e.map(function(e){return e.id});(t=Object.assign({},i)).regionsGroupHover=!0,t.regions=e,t.include=a,r=iMapsManager.pushRegionSeries(o,t,!0),n.push(r)}),n},pushSeries:function(e,a){var t,o=this,i=o.maps[e].clusterSeries,r=o.maps[e].data,n=o.maps[e].seriesIndex,l=o.maps[e].seriesById,s=o.bool(o.maps[e].data.drillDownOnClick),d=iMapsRouter.getCleanMapName(a.map,a.id),p=!1;!1!==d&&void 0!==a.id&&(l[a.id]=[],void 0!==r.liveFilter&&parseInt(r.liveFilter.default)!==r.id&&(p=parseInt(r.liveFilter.default),o.filteredMap=p),Array.isArray(o.maps[e].seriesIndex[a.map])||(o.maps[e].seriesIndex[d]=[]),Array.isArray(a.regions)||(a.regions=[]),void 0===r.allowEmpty&&(r.allowEmpty=0),(a.regions.length||o.bool(r.allowEmpty))&&(o.bool(r.allowEmpty)||(a.include=[],a.regions.forEach(function(e,t){a.include.push(e.id),isNaN(e.id)||a.include.push(parseInt(e.id))})),t=iMapsManager.pushRegionSeries(e,a),n[d].push(t),l[a.id].push(t),s&&(t.hidden=!0,t.mapID=a.id),r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(t.hidden=!0),Array.isArray(a.regionGroups)&&a.regionGroups.length&&o.pushGroupSeries(e,a).forEach(function(e){n[d].push(e),l[a.id].push(e),s&&(e.hidden=!0,e.mapID=a.id),r.liveFilter&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(e.hidden=!0)}),Array.isArray(a.lines)&&a.lines.length&&(t=iMapsManager.pushLineSeries(e,a),n[d].push(t),l[a.id].push(t),s&&(t.hidden=!0),r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(t.hidden=!0),Array.isArray(a.roundMarkers)&&a.roundMarkers.length&&(t=iMapsManager.pushRoundMarkerSeries(e,a),n[d].push(t),l[a.id].push(t),s&&(t.hidden=!0,t.mapID=a.id),a.clusterMarkers&&o.bool(a.clusterMarkers.enabled)&&(t.hidden=!0,o.setupClusters(a,e,a.id),i[a.id].zoomLevels[a.clusterMarkers.zoomLevel]=t,!s)&&i[a.id].zoomLevels[1]&&(i[a.id].zoomLevels[1].hidden=!1,r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(i[a.id].zoomLevels[1].hidden=!0),r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(t.hidden=!0),Array.isArray(a.iconMarkers)&&a.iconMarkers.length&&(i=iMapsManager.pushIconMarkerSeries(e,a),n[d].push(i),l[a.id].push(i),s&&(i.hidden=!0),r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(i.hidden=!0),Array.isArray(a.imageMarkers)&&a.imageMarkers.length&&(t=iMapsManager.pushImageMarkerSeries(e,a),n[d].push(t),l[a.id].push(t),s&&(t.hidden=!0),r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(t.hidden=!0),Array.isArray(a.labels))&&a.labels.length&&(i=iMapsManager.pushLabelSeries(e,a),n[d].push(i),l[a.id].push(i),s&&(i.hidden=!0),r.liveFilter)&&o.bool(r.liveFilter.enabled)&&p&&p!==a.id&&(i.hidden=!0)},pushRegionSeries:function(t,i,a){var o,e,r=this,n=r.maps[t].map,l=i.tooltip||{},a=a||!1;if(i=i||{},o=n.series.push(new am4maps.MapPolygonSeries),"custom"===i.map||r.bool(i.useGeojson)?o.geodataSource.url=i.mapURL:(e=iMapsRouter.getVarByName(i.map),o.geodata=window[e]),o.name=(i.regionLegend&&""!==i.regionLegend.title?i.regionLegend:i).title,o.hiddenInLegend=!i.regionLegend||!r.bool(i.regionLegend.enabled),i.regionLegend&&"onlyGroups"===i.regionLegend.enabled&&a&&(o.hiddenInLegend=!1),i.regionLegend&&"onlyGroups"===i.regionLegend.enabled&&!a&&(o.hiddenInLegend=!0),i.regionLegend&&"ignoreGroups"===i.regionLegend.enabled&&a&&(o.hiddenInLegend=!0),i.regionLegend&&"ignoreGroups"===i.regionLegend.enabled&&!a&&(o.hiddenInLegend=!1),t===i.id&&(void 0===r.maps[t].baseSeries&&(r.maps[t].baseSeries=[]),r.maps[t].baseSeries.push(o),r.maps[t].allBaseSeries.push(o)),o.useGeodata=!0,Array.isArray(i.exclude)&&i.exclude.length&&(o.exclude=i.exclude),Array.isArray(i.include)&&i.include.length&&(o.include=i.include),i.heatMapRegions&&r.bool(i.heatMapRegions.enabled)&&r.setupHeatMap(o,t,i),o.data=i.regions,a&&(o.groupHover=!0),e=o.mapPolygons.template,r.setupTooltip(t,o,i),void 0!==i.regionsTooltipTemplate&&""!==i.regionsTooltipTemplate.trim()?(e.tooltipText=i.regionsTooltipTemplate,e.tooltipHTML=i.regionsTooltipTemplate):(e.tooltipText=l.template||"{tooltipContent}",e.tooltipHTML=l.template||"{tooltipContent}"),e.adapter.add("tooltipHTML",function(e,t,a){return"object"===_typeof(t.dataItem.dataContext)&&void 0!==l.onlyWithData&&r.bool(l.onlyWithData)&&!0===t.dataItem.dataContext.madeFromGeoData?(t.tooltip.tooltipText=void 0,t.tooltip.tooltipHTML=void 0,""):""===e?e:e.replace(/\\/g,"")}),e.adapter.add("tooltipText",function(e,t,a){return"object"===_typeof(t.dataItem.dataContext)&&void 0!==l.onlyWithData&&r.bool(l.onlyWithData)&&!0===t.dataItem.dataContext.madeFromGeoData?(t.tooltip.tooltipText=void 0,t.tooltip.tooltipHTML=void 0,""):""===e?e:e.replace(/\\/g,"")}),o.fill=i.regionDefaults.fill,e.fill=i.regionDefaults.inactiveColor,e.stroke=i.visual.borderColor,e.strokeWidth=i.visual.borderWidth,e.propertyFields.fill="fill",a||void 0!==i.heatMapRegions&&r.bool(i.heatMapRegions.enabled)&&r.bool(i.heatMapRegions.noHover)||(e.states.create("hover").propertyFields.fill="hover"),i.regionActiveState&&r.bool(i.regionActiveState.enabled)&&(d=e.states.create("active"),"custom"===i.regionActiveState.source?d.properties.fill=i.regionActiveState.fill:d.propertyFields.fill="hover"),e.states.create("highlight").propertyFields.fill="hover",a?(e.events.on("out",function(e){r.groupHoverOut(t,e)}),e.events.on("over",function(e){r.groupHover(t,e)}),e.events.on("hit",function(e){r.groupHit(t,e)})):(e.events.on("hit",function(e){r.singleHit(t,e)}),e.events.on("over",function(e){r.setupHoverEvents(t,e)})),e.focusable=!1,e.events.on("hit",function(e){r.setupHitEvents(t,e)}),r.bool(i.smallMap)&&n.smallMap.series.push(o),i.regionLabels&&r.bool(i.regionLabels.source)){o.calculateVisualCenter=!0;var s=n.series.push(new am4maps.MapImageSeries),d=s.mapImages.template.createChild(am4core.Label),a="undefined"!=typeof igmLabelsBackground&&igmLabelsBackground,p=("object"==typeof a&&(d.background=new am4core.RoundedRectangle,d.background.cornerRadius(...a.cornerRadius),d.background.fill=am4core.color(a.color),d.padding(...a.padding),d.background.stroke=am4core.color(a.stroke)),r.maps[t].labelSeries.push(s),d.horizontalCenter=i.regionLabels.horizontalCenter,d.verticalCenter=i.regionLabels.verticalCenter,d.fontSize=i.regionLabels.fontSize,d.fill=i.regionLabels.fill,d.fontFamily=i.regionLabels.fontFamily||"inherit",d.fontWeight=i.regionLabels.fontWeight||"normal",i.regionLabels.mobileFontSize&&100!==parseInt(i.regionLabels.mobileFontSize)&&window.innerWidth<=780&&(d.fontSize=parseInt(d.fontSize)*parseInt(i.regionLabels.mobileFontSize)/100,d.size=d.fontSize),o.events.on("hidden",function(e){s.hide()}),o.events.on("shown",function(e){s.show()}),d.events.on("hit",function(e){o.getPolygonById(e.target.parent.LabelForRegion).dispatchImmediately("hit")}),d.events.on("over",function(e){iMapsManager.hover(t,e.target.parent.LabelForRegion,!1)}),d.events.on("out",function(e){iMapsManager.clearHovered(t,e.target.parent.LabelForRegion)}),r.setupTooltip(t,s,i,d),d.interactionsEnabled=!0,d.nonScaling=r.bool(i.regionLabels.nonScaling),s.hiddenInLegend=!0,o.events.on("inited",function(){o.hidden&&(s.hide(),s.hidden=!0)}),r.bool(i.admin)&&(d.draggable=!0,d.cursorOverStyle=am4core.MouseCursorStyle.grab,d.events.on("dragstop",function(e){am4core.utils.spritePointToSvg({x:0,y:0},e.target);var t,a=am4core.utils.spritePointToSvg({x:0-e.target.maxLeft,y:0-e.target.maxTop},e.target),a=n.svgPointToGeo(a),o=document.querySelector("[data-depend-id="+i.regionLabelCustomCoordinates+"]");o&&((t=iMapsManager.isJSON(o.value)?JSON.parse(o.value):{})[e.target.parent.LabelForRegion]={latitude:a.latitude,longitude:a.longitude},o.value=JSON.stringify(t)),n.seriesContainer.draggable=r.bool(i.zoom.draggable),e.target.cursorOverStyle=am4core.MouseCursorStyle.grab}),d.events.on("down",function(e){n.seriesContainer.draggable=!1,e.target.cursorOverStyle=am4core.MouseCursorStyle.grabbing})),!!r.isJSON(i.regionLabels.regionLabelCustomCoordinates)&&JSON.parse(i.regionLabels.regionLabelCustomCoordinates));let e="inited";"custom"===i.map&&(e="datavalidated"),o.events.on(e,function(){o.mapPolygons.each(function(e){var t,a;"custom"!==i.map&&void 0===e.visualLatitude||(t=s.mapImages.create(),r.bool(i.regionLabels.activeOnly)&&e.dataItem.dataContext&&void 0===e.dataItem.dataContext.tooltipContent)||e.dataItem.dataContext.id.includes(",")||("code"===i.regionLabels.source&&(a=e.dataItem.dataContext.id.split("-").pop()),"{name}"===i.regionLabels.source&&(a=e.dataItem.dataContext.name),"{id}"===i.regionLabels.source&&(a=e.dataItem.dataContext.id),"custom"===i.regionLabels.source&&void 0!==i.regionLabels.customSource&&(a=e.dataItem.dataContext.autoLabel),t.LabelForRegion=e.dataItem.dataContext.id,void 0!==e.dataItem.dataContext.originalID&&(t.groupRegion=e.dataItem.dataContext.originalID),t.tooltipDataItem=e.tooltipDataItem,t.tooltip=e.tooltip,t.tooltipHTML=e.tooltipHTML,t.tooltipPosition=r.bool(i.tooltip.fixed)?"fixed":"pointer",e.dataItem.dataContext.action&&"none"!==e.dataItem.dataContext.action&&(t.cursorOverStyle=am4core.MouseCursorStyle.pointer),p&&p.hasOwnProperty(e.dataItem.dataContext.id)?(t.latitude=p[e.dataItem.dataContext.id].latitude,t.longitude=p[e.dataItem.dataContext.id].longitude):e.visualLatitude&&(t.latitude=e.visualLatitude,t.longitude=e.visualLongitude),t.children.getIndex(0)&&(t.children.getIndex(0).text=a))})})}return void 0!==i.externalDropdown&&r.bool(i.externalDropdown.enabled)&&(o.calculateVisualCenter=!0),r.maps[t].series.push(o),o},pushRoundMarkerSeries:function(t,e){var a,o,i,r,n=this,l=n.maps[t].map;return Array.isArray(e.roundMarkers)&&e.roundMarkers.length&&((r=l.series.push(new am4maps.MapImageSeries)).name=(e.roundMarkersLegend&&""!==e.roundMarkersLegend.title?e.roundMarkersLegend:e).title,r.hiddenInLegend=!!e.roundMarkersLegend&&!n.bool(e.roundMarkersLegend.enabled),o=(a=r.mapImages.template).createChild(am4core.Circle),n.setupTooltip(t,r,e,o),a.focusable=!1,o.radius=e.markerDefaults.radius,o.fill=e.markerDefaults.fill,o.stroke=am4core.color("#FFFFFF"),o.strokeWidth=1,o.nonScaling="undefined"==typeof igmRoundMarkersNonScaling||igmRoundMarkersNonScaling,(i=a.createChild(am4core.Label)).text="{label}",i.fill=am4core.color("#fff"),i.verticalCenter="middle",i.horizontalCenter="middle",i.nonScaling="undefined"==typeof igmRoundMarkersNonScaling||igmRoundMarkersNonScaling,i.fontSize="undefined"!=typeof igmClusterMarkerFontSize?igmClusterMarkerFontSize:e.markerDefaults.radius,i.clickable=!1,i.focusable=!1,i.hoverable=!1,void 0!==e.roundMarkersTooltipTemplate&&""!==e.roundMarkersTooltipTemplate.trim()?(a.tooltipText=e.roundMarkersTooltipTemplate,a.tooltipHTML=e.roundMarkersTooltipTemplate):(a.tooltipText=e.tooltip&&e.tooltip.template?e.tooltip.template:"{tooltipContent}",a.tooltipHTML=e.tooltip&&e.tooltip.template?e.tooltip.template:"{tooltipContent}"),a.propertyFields.tooltipText="tooltipTemplate",a.propertyFields.tooltipHTML="tooltipTemplate",e.heatMapMarkers&&n.bool(e.heatMapMarkers.enabled)&&(n.setupHeatMap(r,t,e),void 0===e.heatMapMarkers.type||"range"!==e.heatMapMarkers.type)||(o.propertyFields.radius="radius",o.propertyFields.fill="fill"),o.propertyFields.userClassName="customClass",a.propertyFields.radius="radius",a.propertyFields.latitude="latitude",a.propertyFields.longitude="longitude",a.setStateOnChildren=!0,(i=o.states.create("hover")).properties.fill=e.hover,i.propertyFields.fill="hover",(i=o.states.create("active")).properties.fill=e.hover,i.propertyFields.fill="hover",(i=o.states.create("highlight")).properties.fill=e.hover,i.propertyFields.fill="hover",e.roundMarkerLabels&&n.bool(e.roundMarkerLabels.enabled)&&(a.states.create("hover"),o=a.createChild(am4core.Label),i=void 0!==e.roundMarkerLabels.position&&""!==e.roundMarkerLabels.position?e.roundMarkerLabels.position:"bottom",o.text=void 0!==e.roundMarkerLabels.source&&""!==e.roundMarkerLabels.source?e.roundMarkerLabels.source:"{name}",o.fontSize=e.roundMarkerLabels.fontSize,o.setStateOnChildren=!0,e.roundMarkerLabels.mobileSize&&100!==parseInt(e.roundMarkerLabels.mobileSize)&&window.innerWidth<=780&&(o.fontSize=parseInt(e.roundMarkerLabels.fontSize)*parseInt(e.roundMarkerLabels.mobileSize)/100),o.nonScaling="undefined"==typeof igmRoundMarkersNonScaling||igmRoundMarkersNonScaling,o.fill=e.roundMarkerLabels.fill,o.clickable=!1,o.focusable=!1,o.hoverable=!1,o.padding(0,0,0,0),"bottom"===i&&(o.horizontalCenter="middle",o.verticalCenter="top",o.propertyFields.paddingTop="radius"),"top"===i&&(o.horizontalCenter="middle",o.verticalCenter="bottom",o.propertyFields.paddingBottom="radius"),"right"===i&&(o.horizontalCenter="left",o.verticalCenter="middle",o.propertyFields.paddingLeft="radius"),"left"===i)&&(o.horizontalCenter="right",o.verticalCenter="middle",o.propertyFields.paddingRight="radius"),r.data=e.roundMarkers,r.fill=e.markerDefaults.fill,a.events.on("hit",function(e){n.singleHit(t,e),n.setupHitEvents(t,e)}),a.events.on("over",function(e){n.setupHoverEvents(t,e)})),e.zoom&&e.zoom.smallMap&&n.bool(e.zoom.smallMap)&&l.smallMap.series.push(r),n.maps[t].series.push(r),t===e.id&&(e.clusterMarkers&&!n.bool(e.clusterMarkers.enabled)?n.maps[t].allBaseSeries.push(r):e.clusterMarkers&&n.bool(e.clusterMarkers.enabled)),r},pushImageMarkerSeries:function(t,e){var a,o,i,r=this,n=r.maps[t].map;return Array.isArray(e.imageMarkers)&&e.imageMarkers.length&&((a=n.series.push(new am4maps.MapImageSeries)).name=(e.imageMarkersLegend&&""!==e.imageMarkersLegend.title?e.imageMarkersLegend:e).title,a.hiddenInLegend=!!e.imageMarkersLegend&&!r.bool(e.imageMarkersLegend.enabled),(o=a.mapImages.template).focusable=!1,(i=o.createChild(am4core.Image)).propertyFields.href="href",i.propertyFields.width="size",i.propertyFields.height="size",i.propertyFields.userClassName="customClass",i.propertyFields.horizontalCenter="horizontalCenter",i.propertyFields.verticalCenter="verticalCenter",i.nonScaling=!0,i.propertyFields.nonScaling="nonScaling",r.setupTooltip(t,a,e,i),void 0!==e.imageMarkersTooltipTemplate&&""!==e.imageMarkersTooltipTemplate.trim()?(i.tooltipText=e.imageMarkersTooltipTemplate,i.tooltipHTML=e.imageMarkersTooltipTemplate):(i.tooltipText=e.tooltip.template||"{tooltipContent}",i.tooltipHTML=e.tooltip.template||"{tooltipContent}"),o.propertyFields.latitude="latitude",o.propertyFields.longitude="longitude",a.data=e.imageMarkers,o.events.on("hit",function(e){r.singleHit(t,e),r.setupHitEvents(t,e)}),o.events.on("over",function(e){r.setupHoverEvents(t,e)})),e.zoom&&e.zoom.smallMap&&r.bool(e.zoom.smallMap)&&n.smallMap.series.push(a),r.maps[t].series.push(a),a},pushIconMarkerSeries:function(t,e){var a,o,i,r,n=this,l=n.maps[t].map;return Array.isArray(e.iconMarkers)&&e.iconMarkers.length&&((r=l.series.push(new am4maps.MapImageSeries)).hiddenInLegend=!!e.iconMarkersLegend&&!n.bool(e.iconMarkersLegend.enabled),r.name=(e.iconMarkersLegend&&""!==e.iconMarkersLegend.title?e.iconMarkersLegend:e).title,(a=r.mapImages.template).nonScaling=!0,a.setStateOnChildren=!0,a.focusable=!1,a.states.create("hover"),(o=a.createChild(am4core.Sprite)).propertyFields.scale="scale",o.propertyFields.path="path",o.propertyFields.rotation="rotation",o.propertyFields.horizontalCenter="horizontalCenter",o.propertyFields.verticalCenter="verticalCenter",o.propertyFields.fill="fill",r.fill=e.iconMarkerDefaults.fill,(i=a.createChild(am4core.Sprite)).propertyFields.scale="scale",i.path="M-10,0a10,10 0 1,0 20,0a10,10 0 1,0 -20,0",i.opacity=0,i.propertyFields.horizontalCenter="horizontalCenter",i.propertyFields.verticalCenter="verticalCenter",a.tooltipText=e.tooltip.template||"{tooltipContent}",a.tooltipHTML=e.tooltip.template||"{tooltipContent}",n.setupTooltip(t,r,e,i),e.iconMarkerLabels&&n.bool(e.iconMarkerLabels.enabled)&&((i=a.createChild(am4core.Label)).text=void 0!==e.iconMarkerLabels.source&&""!==e.iconMarkerLabels.source?e.iconMarkerLabels.source:"{name}",i.horizontalCenter="middle",i.verticalCenter="top",i.fontSize=e.iconMarkerLabels.fontSize,i.nonScaling=!1,i.fill=e.iconMarkerLabels.fill,i.clickable=!1,i.focusable=!1,i.hoverable=!1,i.padding(0,0,0,0),i.adapter.add("dy",function(e,t){var a,t=t.parent.children.getIndex(0),o=t.scale;return"middle"===t.verticalCenter&&(a=10*o),"bottom"===t.verticalCenter&&(a=0),a="top"===t.verticalCenter?20*o+5:a})),o.states.create("hover").propertyFields.fill="hover",o.states.create("active").propertyFields.fill="hover",(i=o.states.create("highlight")).properties.fill=e.hover,i.propertyFields.fill="hover",a.propertyFields.latitude="latitude",a.propertyFields.longitude="longitude",r.data=e.iconMarkers,a.events.on("hit",function(e){n.singleHit(t,e),n.setupHitEvents(t,e)}),a.events.on("over",function(e){n.setupHoverEvents(t,e)})),e.zoom&&e.zoom.smallMap&&n.bool(e.zoom.smallMap)&&l.smallMap.series.push(r),n.maps[t].series.push(r),r},pushLineSeries:function(t,e){var a=this,o=a.maps[t].map,i={},r=[];return Array.isArray(e.lines)&&e.lines.length&&("Orthographic"===e.projection?(i=o.series.push(new am4maps.MapLineSeries)).mapLines.template.propertyFields.shortestDistance=!0:((i=o.series.push(new am4maps.MapArcSeries)).mapLines.template.line.propertyFields.controlPointDistance="curvature",i.mapLines.template.line.controlPointPosition=.5),i.name=(e.linesLegend&&""!==e.linesLegend.title?e.linesLegend:e).title,i.hiddenInLegend=!!e.linesLegend&&!a.bool(e.linesLegend.enabled),i.mapLines.template.nonScalingStroke=!0,i.mapLines.template.propertyFields.strokeWidth="strokeWidth",i.mapLines.template.propertyFields.strokeDasharray="strokeDash",i.mapLines.template.propertyFields.stroke="stroke",i.mapLines.template.arrow.position=1,i.mapLines.template.arrow.nonScaling=!0,i.mapLines.template.arrow.propertyFields.fill="stroke",i.mapLines.template.arrow.horizontalCenter="middle",i.mapLines.template.arrow.propertyFields.disabled="arrowDisabled",e.lines.forEach(function(e,t){e.multiGeoLine=[e.multiGeoLine],r.push(e)}),i.mapLines.template.events.on("hit",function(e){a.singleHit(t,e),a.setupHitEvents(t,e)}),i.mapLines.template.events.on("over",function(e){a.setupHoverEvents(t,e)}),i.data=r,e.zoom&&e.zoom.smallMap&&a.bool(e.zoom.smallMap)&&o.smallMap.series.push(i),a.maps[t].series.push(i),i.fill=e.lineDefaults.stroke,t===e.id)&&a.maps[t].allBaseSeries.push(i),i},pushLabelSeries:function(t,e){var a,o,i,r,n=this,l=n.maps[t].map;return Array.isArray(e.labels)&&e.labels.length&&((a=l.series.push(new am4maps.MapImageSeries)).name=(e.labelsLegend&&""!==e.labelsLegend.title?e.labelsLegend:e).title,a.hiddenInLegend=!!e.labelsLegend&&!n.bool(e.labelsLegend.enabled),(o=a.mapImages.template).setStateOnChildren=!0,(i=o.createChild(am4core.Label)).text="{id}",i.nonScaling="undefined"==typeof igmLabelsNonScaling||igmLabelsNonScaling,e.labelStyle&&(i.fontFamily=e.labelStyle.fontFamily,i.fontWeight=e.labelStyle.fontWeight),i.horizontalCenter=e.labelPosition.horizontalCenter,i.verticalCenter=e.labelPosition.verticalCenter,i.propertyFields.fill="fill",i.propertyFields.fontSize="fontSize",n.setupTooltip(t,a,e,i),void 0!==e.labelsTooltipTemplate&&""!==e.labelsTooltipTemplate.trim()?(i.tooltipText=e.labelsTooltipTemplate,i.tooltipHTML=e.labelsTooltipTemplate):(i.tooltipText=e.tooltip&&e.tooltip.template?e.tooltip.template:"{tooltipContent}",i.tooltipHTML=e.tooltip&&e.tooltip.template?e.tooltip.template:"{tooltipContent}"),o.propertyFields.latitude="latitude",o.propertyFields.longitude="longitude",o.propertyFields.fill="fill",o.propertyFields.fontSize="fontSize",i.propertyFields.verticalCenter="verticalCenter",i.propertyFields.horizontalCenter="horizontalCenter","object"==typeof(r="undefined"!=typeof igmLabelsBackground&&igmLabelsBackground)&&(i.background=new am4core.RoundedRectangle,i.background.cornerRadius(...r.cornerRadius),i.background.fill=am4core.color(r.color),i.padding(...r.padding),i.background.stroke=am4core.color(r.stroke)),(r=i.states.create("hover")).properties.fill=e.hover,r.propertyFields.fill="hover",(r=i.states.create("active")).properties.fill=e.hover,r.propertyFields.fill="hover",(r=i.states.create("highlight")).properties.fill=e.hover,r.propertyFields.fill="hover",a.data=e.labels,a.fill=e.labelDefaults.fill,o.events.on("hit",function(e){n.singleHit(t,e),n.setupHitEvents(t,e)}),o.events.on("over",function(e){n.setupHoverEvents(t,e)})),e.zoom&&e.zoom.smallMap&&n.bool(e.zoom.smallMap)&&l.smallMap.series.push(a),n.maps[t].labelSeries.push(a),n.maps[t].series.push(a),t===e.id&&n.maps[t].allBaseSeries.push(a),a},setupTooltip:function(e,t,a,o){var i=this,r=a.tooltip,e=i.maps[e].map;if(o=o||!1,void 0!==a.tooltip)return!i.bool(a.tooltip.enabled)||void 0!==_typeof(a.tooltip.disableMobile)&&i.bool(a.tooltip.disableMobile)&&window.innerWidth<=780?t.tooltip.disabled=!0:(t.tooltip.label.interactionsEnabled=i.bool(r.fixed),t.tooltip.background.cornerRadius=r.cornerRadius,r.pointerLength&&(t.tooltip.background.pointerLength=parseInt(r.pointerLength)),t.tooltip.getFillFromObject=!1,t.tooltip.getStrokeFromObject=!1,t.tooltip.label.fill=r.color,t.tooltip.background.fill=r.backgroundColor,t.tooltip.fontFamily=r.fontFamily,t.tooltip.fontSize=r.fontSize,t.tooltip.fontWeight=r.fontWeight,t.tooltip.animationDuration=0,"undefined"!==r.borderColor&&(t.tooltip.background.stroke=r.borderColor,t.tooltip.background.strokeWidth=r.borderWidth),void 0!==r.maxWidth&&""!==r.maxWidth&&(t.tooltip.maxWidth=parseInt(r.maxWidth),t.tooltip.contentWidth=parseInt(r.maxWidth)),t.tooltip.label.wrap=!0,void 0!==r.customShadow&&i.bool(r.customShadow)&&((a=t.tooltip.background.filters.getIndex(0)).dx=r.customShadowOpts.dx,a.dy=r.customShadowOpts.dy,a.blur=r.customShadowOpts.blur,a.opacity=r.customShadowOpts.opacity,a.color=r.customShadowOpts.color),i.bool(r.fixed)&&("always"===r.showTooltipOn&&(t.tooltip.ignoreBounds=!0,t.tooltip.pointerOrientation=function(){switch(r.toolTipPosition){case"horizontal":return"horizontal";case"below":return"up";case"above":return"down";case"right":return"left";case"left":return"right";default:return"vertical"}}()),t.mapPolygons?(t.calculateVisualCenter=!0,t.mapPolygons.template.tooltipPosition="fixed",t.groupHover&&(t.tooltip.getFillFromObject=!1,t.tooltip.events.on("over",function(e){e.target.dataItem.component.mapPolygons.each(function(e){e.setState("highlight")})}),t.tooltip.events.on("out",function(e){e.target.dataItem.component.mapPolygons.each(function(e){e.setState("default")})})),t.tooltip.keepTargetHover=!0,r.showTooltipOn&&(t.mapPolygons.template.showTooltipOn=r.showTooltipOn,"hit"===r.showTooltipOn)&&(t.tooltip.keepTargetHover=!1)):(t.mapImages.template.tooltipPosition="fixed",t.tooltip.keepTargetHover=!0,r.showTooltipOn&&o&&(t.mapImages.template.showTooltipOn=r.showTooltipOn,o.showTooltipOn=r.showTooltipOn,"hit"===r.showTooltipOn&&(t.tooltip.keepTargetHover=!1),"always"===r.showTooltipOn)&&(e.events.on("appeared",function(){o.clones.each(function(e){e.showTooltip()})}),e.events.on("mappositionchanged",function(e){o.clones.each(function(e){e.showTooltip()})}))))),t;t.tooltip.disabled=!1,t.tooltip.getFillFromObject=!1,t.tooltip.getStrokeFromObject=!1,t.tooltip.label.fill=am4core.color("#000000"),t.tooltip.background.fill=am4core.color("#FFFFFF")},prepareURL:function(e){if("string"!=typeof e)return e;var t;(e=e.replace(/&amp;/gi,"&")).replace(/&#(\d+);/g,function(e,t){return String.fromCharCode(t)});try{t=new URL(e)}catch(e){t=!1}return t&&![null,"http:","https:","mailto:","tel:"].includes(t.protocol)?(console.log("URL protocol not allowed"),""):e},setupHitEvents:function(e,t){var a=this,o=a.maps[e].data,i=a.maps[e].map,r=a.getTargetSeriesType(t.target),n=a.maps[e].clicked||!1,l=o.clusterMarkers?parseFloat(o.clusterMarkers.zoomLevel):1,s=document.getElementById(o.container),d=new Event("mapEntryClicked"),p=(t.target.isLabels?t.target.dataItems.first:t.target.dataItem).dataContext;if(i.lastClickedEntry!==t.target||a.maps[e].clicked){if(a.maps[e].clicked=null,i.lastClickedEntry=t.target,s.dispatchEvent(d),"MapImage"===r&&p.cluster&&(5<l-parseInt(i.zoomLevel)&&(l=parseInt(i.zoomLevel)+l/2),t.target.series.chart.zoomToMapObject(t.target,l)),console.log(p),o.zoom&&a.bool(o.zoom.enabled)&&a.bool(o.zoom.zoomOnClick)&&(t.zooming=!0,a.zoomToRegion(t,e)),"MapPolygon"===r&&a.bool(o.drillDownOnClick)&&a.drillDown(e,t),p.madeFromGeoData)s="igm_inactive_"+o.id,"function"==typeof window[s]&&(o=window[s](o));else if("MapImage"===r&&void 0!==_typeof(p.action)&&"igm_display_map"===p.action&&Array.isArray(iMapsManager.maps[e].seriesById[parseInt(p.content)])&&(d=iMapsManager.maps[e].seriesById[parseInt(p.content)],a.drillTo(e,t,d,!0)),!a.bool(o.admin)){if(o.tooltip&&void 0!==_typeof(o.tooltip.enabled)&&a.bool(o.tooltip.enabled)&&void 0!==_typeof(o.tooltip.disableMobile)&&!a.bool(o.tooltip.disableMobile)&&void 0!==_typeof(o.tooltip.holdAction)&&a.bool(o.tooltip.holdAction)&&window.innerWidth<=780){if(!n||n!==p)return console.log("Holding action for second tap."),void(a.maps[e].clicked=p);a.maps[e].clicked=n!==p&&p}"none"!==p.action&&("open_url"!==p.action&&"open_url_new"!==p.action||(p.content=iMapsManager.prepareURL(p.content)),"open_url"===p.action&&""!==p.content?document.location=p.content:"open_url_new"===p.action&&""!==p.content?window.open(p.content):p.action&&p.action.includes("custom")?(l=p.action+"_"+p.mapID,void 0!==window[l]&&window[l](p)):void 0!==window[p.action]&&window[p.action](e,p))}}else a.maps[e].clicked=p,setTimeout(function(){i.lastClickedEntry=null,a.maps[e].clicked=null},1e3)},zoomToMap:function(e,t,a){var o=this,i=!1;t.forEach(function(e){"MapPolygonSeries"==o.getTargetSeriesType(e)&&(i=e)}),i?(e.target.series.chart.zoomToRectangle(i.north,i.east,i.south,i.west,1,!0),console.log("zoomed to specific map")):console.log("failed to zoom to specific map")},zoomToRegion:function(e,t){var a=this.getTargetSeriesType(e.target),o=this.maps[t].data;this.maps[t].map;e.target.isLabels||(t=e.target.dataItem.dataContext,"MapImage"==a?t.cluster||(a="undefined"!=typeof igmMarkerZoomLevelOnClick?igmMarkerZoomLevelOnClick:2*e.target.parent.chart.zoomLevel,e.target.series.chart.zoomToMapObject(e.target,a,!0)):"asia"===t.id?(e.target.series.chart.deltaLongitudeOriginal=e.target.series.chart.deltaLongitude,e.target.series.chart.deltaLongitude=-10,e.target.series.chart.zoomToGeoPoint({latitude:34.076842,longitude:100.693068},1.7,!0)):"northAmerica"===t.id&&o.map.startsWith("region/world/worldRegion")?e.target.series.chart.zoomToGeoPoint({latitude:55.5,longitude:-105.5},3,!0):"ZA"===t.id&&o.map.startsWith("world")?e.target.series.chart.zoomToGeoPoint({latitude:-28.6,longitude:24.7},12.2,!0):"US"===t.id&&o.map.startsWith("world")?e.target.series.chart.zoomToGeoPoint({latitude:49,longitude:-119},2.6,!0):"RU"===t.id&&o.map.startsWith("world")?e.target.series.chart.zoomToGeoPoint({latitude:64.5,longitude:105},2.1,!0):(void 0!==e.target.series.chart.deltaLongitudeOriginal&&(e.target.series.chart.deltaLongitude=e.target.series.chart.deltaLongitude),e.target.series.chart.zoomToMapObject(e.target,2*e.target.zoomLevel)))},setupHoverEvents:function(t,e){var a=this,o=a.maps[t].selected||!1,i=(e.target.isLabels?e.target.dataItems.first:e.target.dataItem).dataContext;"MapImage"!==e.target.className&&"fixed"===e.target.tooltipPosition&&(Array.isArray(a.tempHover)&&0<=a.tempHover.length&&(a.tempHover[0].setState("default"),a.tempHover=[]),a.tempHover=[e.target]),i.action&&"none"!==i.action&&(e.target.cursorOverStyle=am4core.MouseCursorStyle.pointer),Array.isArray(o)&&!o.includes(e.target)&&e.target.dataItem&&void 0===e.target.dataItem.dataContext.madeFromGeoData&&o.forEach(function(e,t){"object"==typeof e&&void 0!==e.isHover&&(e.isHover=!1)}),!a.bool(i.triggerClickOnHover)||iMapsManager.isTouchScreendevice()&&"over"!==e.type||void 0!==iMaps.maps[t].mapClicked&&!1!==iMaps.maps[t].mapClicked||iMapsManager.select(t,i.id,!1,!0,i.mapID,!1),a.bool(i.triggerRegionHover)&&i.val&&""!==i.val&&(iMapsManager.hover(t,i.val),e.target.events.on("out",function(e){iMapsManager.clearHovered(t)}))},singleHit:function(t,a){var o=this.maps[t].data,i=(a.target.isLabels?a.target.dataItems.first:a.target.dataItem).dataContext;if(!i.madeFromGeoData){!0===iMaps.maps[t].activeStateControl&&i.activeState&&(iMaps.maps[t].mapClicked=!0);let e=!0;o.tooltip&&"hit"===o.tooltip.showTooltipOn&&(e=!1),iMapsManager.clearSelected(t,e,!0),a.target.isActive=!0,a.target.isHover=!0,a.target.setState("active"),this.maps[t].selected=[a.target]}},groupHit:function(e,t){var a=this.maps[e].selected||!1;t.target.dataItem.dataContext.madeFromGeoData||(!0===iMaps.maps[e].activeStateControl&&t.target.dataItem.dataContext.activeState&&(iMaps.maps[e].mapClicked=!0),iMapsManager.clearSelected(e),a=[],t.target.parent.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||(e.setState("active"),t.target===e&&(e.isHover=!0),e.isActive=!0,e.isGroupActive=!0,a.push(e))}),this.maps[e].selected=a)},groupHover:function(e,t){var a=(t.target.isLabels?t.target.dataItems.first:t.target.dataItem).dataContext;t.target.dataItem.dataContext.madeFromGeoData||(!this.bool(a.triggerClickOnHover)||void 0!==iMaps.maps[e].mapClicked&&!1!==iMaps.maps[e].mapClicked||iMapsManager.select(e,a.id,!1,!0,a.mapID,!1),t.target.dataItem.dataContext.action&&"none"!=t.target.dataItem.dataContext.action&&(t.target.cursorOverStyle=am4core.MouseCursorStyle.pointer),t.target.parent.mapPolygons.each(function(e){e.dataItem.dataContext.madeFromGeoData||e.isActive||e.setState("highlight")}))},groupHoverOut:function(e,t){t.target.dataItem.dataContext.madeFromGeoData||t.target.parent.mapPolygons.each(function(e){e.isGroupActive||(e.setState("default"),e.isActive=!1,e.isHover=!1)})},getRegionsByValue:function(e,t,a){var o,i=this,e=i.maps[e].series,r=[];return t=t||"*",a=a||"val",e.forEach(function(e){"MapPolygonSeries"===i.getTargetSeriesType(e)&&(o=e.mapPolygons.values.filter(function(e){if(e.dataItem.dataContext[a]===t||"*"===t)return!0}),r=r.concat(o))}),r},getMarkersByValue:function(e,t,a){var o,i=this,e=i.maps[e].series,r=[];return t=t||"*",a=a||"val",e.forEach(function(e){"MapImageSeries"===i.getTargetSeriesType(e)&&(o=e.mapImages.values.filter(function(e){if(e.dataItem.dataContext[a]===t||"*"===t)return!0}),r=r.concat(o))}),r},select:function(a,o,i,r,e,t){var n,l,s,d=this,p=d.maps[a],u=d.maps[a].data,c=p.series,m=[],p=iMaps.maps[a].seriesById,g=!1,h=!0,M=!1,v=!0;o=Number.isInteger(o)?o.toString():o;if(void 0===i&&(i=!0),void 0===r&&(r=!0),p.hasOwnProperty(e=void 0===e?a:e)&&(g=p[e]),u.tooltip&&"hit"===u.tooltip.showTooltipOn&&(v=!1),iMapsManager.clearSelected(a,v,!(t=void 0===t)),iMaps.maps[a].activeStateControl=!!t,g&&(c=g),Array.isArray(c))for(var f,b=0,y=c.length;b<y&&!M;b++)if(void 0===c[b].isCluster||!c[b].isCluster){if(c[b].mapPolygons)if((n=c[b].getPolygonById(o))&&void 0!==n.dataItem.dataContext.originalID&&n.dataItem.dataContext.originalID.includes(",")&&(o=n.dataItem.dataContext.originalID),n&&c[b].show(),o.includes(","))void 0!==n&&n&&(n.tooltip=!1,n.dispatchImmediately("hit"),n.hideTooltip(),h=!1,iMaps.maps[a].activeStateControl=!0),o.split(",").forEach(function(e,t){void 0===(n=c[b].getPolygonById(e.trim()))||!n||n.dataItem.dataContext.madeFromGeoData||n.dataItem.dataContext.originalID!==o&&!h||(0===t&&r&&(M=!0,i?(l=void 0!==n&&void 0!==n.tooltipPosition?n.tooltipPosition:"hover",n.tooltipPosition="fixed",s=n.showTooltipOn,n.showTooltipOn="always",iMaps.maps[a].activeStateControl=!0,n.tooltipPosition=l,n.showTooltipOn=s):n.isHover=!0),u.regionActiveState&&d.bool(u.regionActiveState.enabled)?n.setState("active"):n.setState("highlight"),m.push(n))});else if(void 0!==(n=c[b].getPolygonById(o))&&n){let e=0;"Orthographic"===u.projection&&((f=iMaps.maps[a].map).animate({property:"deltaLongitude",to:-n.longitude},500,am4core.ease.linear),f.animate({property:"deltaLatitude",to:-n.latitude},550,am4core.ease.linear),e=550),setTimeout(function(e){console.log(e.dataItem.dataContext),i&&e.dataItem.dataContext&&"igm_display_map"!==e.dataItem.dataContext.action?(l=void 0!==e&&void 0!==e.tooltipPosition?e.tooltipPosition:"hover",e.tooltipPosition="fixed",s=e.showTooltipOn,e.showTooltipOn="always",e.dispatchImmediately("hit"),M=!0,e.tooltipPosition=l,e.showTooltipOn=s):M=(e.dataItem.dataContext&&"igm_display_map"===e.dataItem.dataContext.action?(e.dispatchImmediately("hit"),e.hideTooltip()):e.dispatchImmediately("hit"),!0),m.push(e)},e,n)}if(c[b].mapImages)if(o.includes(","))o.split(",").forEach(function(e,t){void 0!==(n=c[b].getImageById(e))&&n&&(c[b].show(),i?(s=n.showTooltipOn,n.showTooltipOn="always",l=void 0!==n.tooltipPosition?n.tooltipPosition:"hover",n.tooltipPosition="fixed",n.dispatchImmediately("hit"),M=!0,n.tooltipPosition=l,n.showTooltipOn=s):(n.dispatchImmediately("hit"),M=!0),m.push(n))});else{let t=c[b].getImageById(o);if(t){c[b].show();let e=0;"Orthographic"===u.projection&&((f=iMaps.maps[a].map).animate({property:"deltaLongitude",to:-t.longitude},500,am4core.ease.linear),f.animate({property:"deltaLatitude",to:-t.latitude},550,am4core.ease.linear),e=550),setTimeout(function(){i?(l=t.tooltipPosition,s=t.showTooltipOn,t.tooltipPosition="fixed",t.showTooltipOn="always",t.isHover=!0,t.isActive=!0,t.dispatchImmediately("hit"),t.setState("active"),t.children.each(function(e){e.showTooltip(0)}),M=!0,t.tooltipPosition=l,t.showTooltipOn=s):(t.dispatchImmediately("hit"),M=!0),m.push(t)},e)}}}return d.maps[a].selected=m,n},setupRangeHeatMap:function(e,t,r){var n,a=r.regions,o=r.roundMarkers,e=this.getTargetSeriesType(e);"MapImageSeries"===e?Array.isArray(r.heatMapMarkers.range)&&0!==r.heatMapMarkers.range.length&&((n=r.heatMapMarkers.range.slice(0)).sort(function(e,t){var a,o;return isNaN(e.rule)?(a=e.rule.toLowerCase())<(o=t.rule.toLowerCase())?-1:o<a?1:0:parseFloat(e.rule)-parseFloat(t.rule)}),Array.isArray(o))&&0<o.length&&o.forEach(function(a,e){var o,i;void 0!==a[r.heatMapMarkers.source]&&("value"===r.heatMapMarkers.source&&(r.heatMapMarkers.source="val"),o=a[r.heatMapMarkers.source],isNaN(o)||(o=parseFloat(o)),n.forEach(function(e,t){isNaN(e.rule)?(i=e.rule.trim(),o==i&&(a.fill=e.fill,a.radius=parseFloat(e.radius))):(i=parseFloat(e.rule))<=o&&(a.fill=e.fill,a.radius=parseFloat(e.radius))}))}):"MapPolygonSeries"===e&&Array.isArray(r.heatMapRegions.range)&&0!==r.heatMapRegions.range.length&&((n=r.heatMapRegions.range.slice(0)).sort(function(e,t){var a,o;return isNaN(e.rule)?(a=e.rule.toLowerCase())<(o=t.rule.toLowerCase())?-1:o<a?1:0:parseFloat(e.rule)-parseFloat(t.rule)}),Array.isArray(a))&&0<a.length&&(isNaN(r.heatMapRegions.source)||(r.heatMapRegions.source=parseInt(r.heatMapRegions.source)),a.forEach(function(a,e){var o,i;void 0!==a[r.heatMapRegions.source]&&("value"===r.heatMapRegions.source&&(r.heatMapRegions.source="val"),o=a[r.heatMapRegions.source],isNaN(o)||(o=parseFloat(o)),n.forEach(function(e,t){isNaN(e.rule)?(i=e.rule.trim(),o==i&&(a.fill=e.fill)):(i=parseFloat(e.rule))<=o&&(a.fill=e.fill)}))}))},setupHeatMap:function(t,e,a){var o,i,r,n,l,s=this,e=s.maps[e].map,d=s.getTargetSeriesType(t);if("MapImageSeries"===d){if(void 0!==a.heatMapMarkers.type&&"range"===a.heatMapMarkers.type)return void s.setupRangeHeatMap(t,a.id,a);o=t.mapImages.template.children.values[0],n=["fill","radius"],l=a.heatMapMarkers}else{if("MapPolygonSeries"!==d)return;if(void 0!==a.heatMapRegions.type&&"range"===a.heatMapRegions.type)return void s.setupRangeHeatMap(t,a.id,a);o=t.mapPolygons.template,n=["fill"],l=a.heatMapRegions}t.dataFields.value=l.source,(n=Array.isArray(n)?n:[n]).map(function(e){"fill"===e?(i=l.minColor,r=l.maxColor):"radius"===e&&(i=l.minRadius,r=l.maxRadius),t.heatRules.push({property:e,target:o,min:i,max:r})}),s.bool(l.legend)&&((d=e.createChild(am4core.Container)).align=void 0!==l.legendAlign?l.legendAlign:"right",d.valign=void 0!==l.legendValign?l.legendValign:"bottom",d.userClassName="mapLegendContainer",d.marginRight=am4core.percent(4),window.innerWidth<=780?d.width=am4core.percent(40):d.width=am4core.percent(25),void 0!==l.label&&""!==l.label&&((a=d.createChild(am4core.Label)).text=l.label,a.horizontalCenter="left",a.verticalCenter="top",a.fontSize=12,a.paddingBottom=40,window.innerWidth<=780?a.fontSize=10:a.fontSize=12,a.paddingBottom=48,a.nonScaling=!1,a.clickable=!1,a.focusable=!1,a.hoverable=!1),(n=d.createChild(am4maps.HeatLegend)).series=t,n.align="right",n.valign="bottom",n.width=am4core.percent(100),n.minValue=0,n.maxValue=99999999999999,(s=n.valueAxis.axisRanges.create()).value=n.minValue,s.label.text=l.minLabel,(e=n.valueAxis.axisRanges.create()).value=n.maxValue,e.label.text=l.maxLabel,s.label.fontSize=12,e.label.fontSize=12,window.innerWidth<=780?(s.label.fontSize=10,e.label.fontSize=10):(s.label.fontSize=12,e.label.fontSize=12),n.valueAxis.renderer.labels.template.adapter.add("text",function(){return""}))},drillTo:function(e,t,a,o){var i,r,n=iMapsManager,l=(n.maps[e].map,n.maps[e].data),s=iMapsManager.maps[e].series,d=iMapsManager.maps[e].baseSeries,p=iMapsManager.maps[e].allBaseSeries,u=n.maps[e].backgroundSeries,c="undefined"!=typeof igmDrilldownBaseMapOpacity?igmDrilldownBaseMapOpacity:.3;for(o=o||!1,i=0,r=s.length;i<r;i++)d.includes(s[i])?void 0!==l.alwaysKeepBase&&n.bool(l.alwaysKeepBase)||(s[i].opacity=c,u.opacity=c):p.includes(s[i])&&void 0!==l.alwaysKeepBase&&n.bool(l.alwaysKeepBase)||s[i].hide();for(i=0,r=a.length;i<r;i++)a[i].show();iMapsManager.maps[e].isDrilling=!0,t.zooming||(o?(console.log("drill to specific map"),n.zoomToMap(t,a)):n.zoomToRegion(t,e))},drillDown:function(t,e){var a,o,i,r=iMapsRouter.iso2cleanName(e.target.dataItem.dataContext.id,t),n=e.target.dataItem.dataContext.id,l=iMapsManager.maps[t].series,s=e.target.dataItem.dataContext,d=!1,p=iMapsManager.maps[t].baseSeries,u=iMapsManager.maps[t].allBaseSeries,c=[],m=!1;if(console.log("Map Name:",r),console.log("Available Series:",iMapsManager.maps[t].seriesIndex),console.log("Available Series by ID: ",iMapsManager.maps[t].seriesById),!(r&&isNaN(n)||void 0!==_typeof(s)&&"igm_display_map"===s.action))return!1;if(e.target.polygon)if(c.push(r),c.forEach(function(e){void 0!==_typeof(s)&&"igm_display_map"==s.action?(console.log("Display custom map "+s.content),Array.isArray(iMapsManager.maps[t].seriesById[parseInt(s.content)])&&(m=!0,a=iMapsManager.maps[t].seriesById[parseInt(s.content)],d=!0)):Array.isArray(iMapsManager.maps[t].seriesIndex[e])&&(m=!0,a=iMapsManager.maps[t].seriesIndex[e])}),m)iMapsManager.drillTo(t,e,a,d),iMapsManager.maps[t].drilledTo=a[0].mapID;else if(a===e.target.series)iMapsManager.maps[t].isDrilling=!1;else if(p.includes(e.target.series))for(iMapsManager.maps[t].isDrilling=!1,iMapsManager.maps[t].drilledTo=!1,o=0,i=l.length;o<i;o++)u.includes(l[o])?l[o].show():l[o].hide()},getSelected:function(e){var e=this.maps[e].selected||!1,t=[];return!!e&&(Array.isArray(e)?(e.forEach(function(e){t.push(e.dataItem.dataContext)}),t):e.dataItem.dataContext)},getHovered:function(e){var e=this.maps[e].hovered||!1,t=[];return!!e&&(Array.isArray(e)?(e.forEach(function(e){t.push(e.dataItem.dataContext)}),t):void 0)},getHighlighted:function(e){var e=this.maps[e].highlighted||!1,t=[];return!!e&&(Array.isArray(e)?(e.forEach(function(e){t.push(e.dataItem.dataContext)}),t):e.dataItem.dataContext)},clearSelected:function(e,a,t){var e=this.maps[e],o=e.selected||[];return a=a||!1,Array.isArray(o)&&0<o.length&&(o.forEach(function(e,t){e!==a&&"object"==typeof e&&void 0!==e.isHover&&(e.isHover=!1,e.isActive=!1,e.isGroupActive=!1,a||e.hideTooltip(0),e.setState("default"))}),o=[]),a||"undefined"==typeof iMapsActions?e.selected=[a]:e.selected=[],e.selected},clearHighlighted:function(e){e=this.maps[e].highlighted||[];return Array.isArray(e)&&0<e.length&&(e.forEach(function(e,t){e.isHover=!1,e.isActive=!1,e.setState("default")}),e=[]),e},hover:function(e,t,a){var o,i,r,n=this.maps[e],l=(n.data,n.series),s=n.hovered||[];if(Number.isInteger(t)&&(t=t.toString()),void 0===a&&(a=!0),iMapsManager.clearHovered(e),s=[],Array.isArray(l))for(var d=0,p=l.length;d<p;d++)l[d].mapPolygons&&(t.includes(",")?t.split(",").forEach(function(e,t){(o=l[d].getPolygonById(e.trim()))&&(a?(r=void 0!==o.tooltipPosition?o.tooltipPosition:"fixed",i=void 0!==o.showTooltipOn?o.showTooltipOn:"hover",o.tooltipPosition="fixed",o.showTooltipOn="always",s.push(o),o.dispatchImmediately("over"),o.isHover=!0,o.tooltipPosition=r,o.showTooltipOn=i):(s.push(o),o.dispatchImmediately("over"),o.isHover=!0))}):(o=l[d].getPolygonById(t))&&(a?(r=o.tooltipPosition,o.tooltipPosition="fixed",s=[o],o.dispatchImmediately("over"),o.isHover=!0,o.tooltipPosition=r):(s=[o],o.dispatchImmediately("over"),o.isHover=!0))),l[d].mapImages&&(t.includes(",")?t.split(",").forEach(function(e,t){(o=l[d].getImageById(e))&&(a?(r=o.tooltipPosition,i=o.showTooltipOn,o.tooltipPosition="fixed",o.showTooltipOn="always",s=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover"),o.children.each(function(e){"Circle"===e.className&&e.showTooltip(0)}),o.tooltipPosition=r,o.showTooltipOn=i):(s=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover")))}):(o=l[d].getImageById(t))&&(a?(r=o.tooltipPosition,o.tooltipPosition="fixed",s=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover"),o.children.each(function(e){"Circle"===e.className&&e.showTooltip(0)}),o.tooltipPosition=r):(s=[o],o.dispatchImmediately("over"),o.isHover=!0,o.setState("hover"))));return n.hovered=s,o},clearHovered:function(e,t){var a,e=this.maps[e],o=e.hovered||!1,i=e.series;if(t=t||!1){if(Array.isArray(i))for(var r=0,n=i.length;r<n;r++)i[r].mapPolygons&&(a=i[r].getPolygonById(t))&&(a.dispatchImmediately("out"),a.isHover=!1),i[r].mapImages&&(a=i[r].getImageById(t))&&(a.isHover=!1,a.setState("default"),a.dispatchImmediately("out"))}else if(o)return o.forEach(function(e){e.dispatchImmediately("out"),void 0!==e.isGroupActive&&e.isGroupActive||(e.setState("default"),e.isHover=!1),void 0!==e.children&&e.children.each(function(e){"Circle"===e.className&&e.hideTooltip(0)})}),e.hovered=[],!0;return!1},highlight:function(e,t){var a,e=this.maps[e],o=e.series,i=e.highlighted||[];if(Number.isInteger(t)&&(t=t.toString()),Array.isArray(o))for(var r=0,n=o.length;r<n;r++)o[r].mapPolygons&&(t.includes(",")?t.split(",").forEach(function(e,t){void 0!==(a=o[r].getPolygonById(e.trim()))&&a&&!a.dataItem.dataContext.madeFromGeoData&&(a.setState("highlight"),i.push(a))}):void 0!==(a=o[r].getPolygonById(t))&&a&&(a.setState("highlight"),i.push(a))),o[r].mapImages&&(t.includes(",")?t.split(",").forEach(function(e,t){void 0!==(a=o[r].getImageById(e))&&a&&(a.setStateOnChildren=!0,a.setState("highlight"),i.push(a))}):void 0!==(a=o[r].getImageById(t))&&a&&(a.setStateOnChildren=!0,a.setState("highlight"),i.push(a)));return e.highlighted=i,a},getTargetSeriesType:function(e){return e.className},setupClusters:function(a,o,e){for(var i,r=this,n=r.maps[o],l={},t=[],s=[],d=0,p=parseFloat(a.clusterMarkers.maxBias),u=parseFloat(a.clusterMarkers.zoomLevel)||20,c=void 0!==a.clusterMarkers.tooltipTemplate&&a.clusterMarkers.tooltipTemplate,m=(e=e||!1)||o;d<=4;)t.push(p),p/=2,s.push(u),u=3==d?1:Math.ceil(u/2),d++;return s.reverse().pop(),t.pop(),void 0===n.clusterSeries[m]&&(n.clusterSeries[m]={zoomLevels:{},overlay:e}),Array.isArray(a.roundMarkers)&&t.forEach(function(e,t){i=geocluster(a.roundMarkers,e,a.markerDefaults,c),(l=Object.assign({},a)).roundMarkers=i,(i=r.pushRoundMarkerSeries(o,l)).name=l.title||"Map",i.hiddenInLegend=!0,i.isCluster=!0,(n.clusterSeries[m].zoomLevels[s[t]]=i).hidden=!0}),!0},triggerOnReady:function(e,t){var t="custom"==t.map,a=new URLSearchParams(window.location.search).get("mregion");a&&!t&&iMapsManager.select(e,a,!0,!0)},triggerOnAppeared:function(e,t){t="custom"==t.map;let a=new URLSearchParams(window.location.search).get("mregion");a&&t&&setTimeout(function(){iMapsManager.select(e,a,!0,!0)},500)},addGeoFileSeries:function(t,e,a){var o,i=iMapsRouter.getGeoFiles(e);return new Promise(function(e,t){var a=document.createElement("script");document.body.appendChild(a),a.onload=e,a.onerror=t,a.async=!0,a.src=i.src}).then(function(){var e={title:i.title,map:i.map,regions:[],config:void 0};return iMapsManager.maps[t].seriesIndex[i.map]=[],o=iMapsManager.pushRegionSeries(t,e),iMapsManager.maps[t].seriesIndex[i.map].push(o),o}),!1},handleInfoBox:function(t){var n=this.maps[t].map,a=document.getElementById("map_visual_info"),l=document.getElementById("map_click_events_coordinates");this.maps[t].series;a&&(iMapsManager.populateInfo(t,a),["ready","mappositionchanged","zoomlevelchanged"].forEach(function(e){n.events.on(e,function(e){iMapsManager.populateInfo(t,a)},this)})),l&&n.events.on("hit",function(e){var e=n.svgPointToGeo(e.svgPoint),t=Number(e.latitude).toFixed(6),e=Number(e.longitude).toFixed(6),a=document.createElement("div"),o=document.createElement("span"),i=document.createElement("span"),o=(i.classList.add("map_clicked_lat"),o.innerHTML="LAT: ",i.innerHTML=t,a.appendChild(o),a.appendChild(i),document.createElement("div")),i=document.createElement("span"),r=document.createElement("span"),i=(r.classList.add("map_clicked_long"),i.innerHTML="LON: ",r.innerHTML=e,o.appendChild(i),o.appendChild(r),l.innerHTML="",l.appendChild(a),l.appendChild(o),l.parentElement.style.display="block",new CustomEvent("mapPointClicked",{detail:{latitude:t,longitude:e}}));document.dispatchEvent(i)},this)},populateInfo:function(e,t){var e=this.maps[e].map,a="",a=(a=(a+="Zoom Level: "+parseFloat(Number(e.zoomLevel).toFixed(2))+"<br>")+("Center Coordinates: <br>LAT "+Number(e.zoomGeoPoint.latitude).toFixed(6)+"<br>LONG "+Number(e.zoomGeoPoint.longitude).toFixed(6)+"<br>"),t.innerHTML=a,{zoom:parseFloat(Number(e.zoomLevel).toFixed(2)),lat:Number(e.zoomGeoPoint.latitude).toFixed(6),long:Number(e.zoomGeoPoint.longitude).toFixed(6)});t.setAttribute("data-visual",JSON.stringify(a))},hideAllSeries:function(e,t){if(e=parseInt(e)){t=t||!1;for(var a=iMaps.maps[e],o=(a.baseRegionSeries,a.groupedBaseRegionSeries),i=a.allBaseSeries,r=0;r<a.series.length;r++){var n=a.series[r];o.includes(n)||t&&i.includes(n)||n.hide()}}},showAllSeries:function(e){if(e=parseInt(e))for(var t=iMaps.maps[e],a=0;a<t.series.length;a++){var o=t.series[a];void 0!==o.isCluster&&!1!==o.isCluster||o.show()}},bool:function(e){return 0!==Number(e)&&"false"!==e&&void 0!==e},isJSON:function(e){try{JSON.parse(e)}catch(e){return!1}return!0}}),iMaps=(Element.prototype.matches||(Element.prototype.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector),Element.prototype.closest||(Element.prototype.closest=function(e){var t=this;do{if(t.matches(e))return t}while(null!==(t=t.parentElement||t.parentNode)&&1===t.nodeType);return null}),iMapsManager.library={icons:{goFullIconPath:"m15.78742,5.93715l-3.95414,3.95414l3.95414,3.95414l1.60393,-1.60393q0.32301,-0.34529 0.77969,-0.15594q0.4344,0.18935 0.4344,0.65717l0,4.99002q0,0.2896 -0.21163,0.50123t-0.50123,0.21163l-4.99002,0q-0.46781,0 -0.65717,-0.44554q-0.18935,-0.4344 0.15594,-0.76855l1.60393,-1.60393l-3.95414,-3.95414l-3.95414,3.95414l1.60393,1.60393q0.34529,0.33415 0.15594,0.76855q-0.18935,0.44554 -0.65717,0.44554l-4.99002,0q-0.2896,0 -0.50123,-0.21163t-0.21163,-0.50123l0,-4.99002q0,-0.46781 0.44554,-0.65717q0.4344,-0.18935 0.76855,0.15594l1.60393,1.60393l3.95414,-3.95414l-3.95414,-3.95414l-1.60393,1.60393q-0.21163,0.21163 -0.50123,0.21163q-0.13366,0 -0.26732,-0.05569q-0.44554,-0.18935 -0.44554,-0.65717l0,-4.99002q0,-0.2896 0.21163,-0.50123t0.50123,-0.21163l4.99002,0q0.46781,0 0.65717,0.44554q0.18935,0.4344 -0.15594,0.76855l-1.60393,1.60393l3.95414,3.95414l3.95414,-3.95414l-1.60393,-1.60393q-0.34529,-0.33415 -0.15594,-0.76855q0.18935,-0.44554 0.65717,-0.44554l4.99002,0q0.2896,0 0.50123,0.21163t0.21163,0.50123l0,4.99002q0,0.46781 -0.4344,0.65717q-0.1448,0.05569 -0.27846,0.05569q-0.2896,0 -0.50123,-0.21163l-1.60393,-1.60393z",exitFullIconPath:"m10.04411,10.81638l0,5.40556q0,0.31372 -0.22925,0.54297t-0.54297,0.22925t-0.54297,-0.22925l-1.7375,-1.7375l-4.00591,4.00591q-0.12066,0.12066 -0.27752,0.12066t-0.27752,-0.12066l-1.37552,-1.37552q-0.12066,-0.12066 -0.12066,-0.27752t0.12066,-0.27752l4.00591,-4.00591l-1.7375,-1.7375q-0.22925,-0.22925 -0.22925,-0.54297t0.22925,-0.54297t0.54297,-0.22925l5.40556,0q0.31372,0 0.54297,0.22925t0.22925,0.54297zm9.10982,-8.10834q0,0.15686 -0.12066,0.27752l-4.00591,4.00591l1.7375,1.7375q0.22925,0.22925 0.22925,0.54297t-0.22925,0.54297t-0.54297,0.22925l-5.40556,0q-0.31372,0 -0.54297,-0.22925t-0.22925,-0.54297l0,-5.40556q0,-0.31372 0.22925,-0.54297t0.54297,-0.22925t0.54297,0.22925l1.7375,1.7375l4.00591,-4.00591q0.12066,-0.12066 0.27752,-0.12066t0.27752,0.12066l1.37552,1.37552q0.12066,0.12066 0.12066,0.27752z"}},iMapsManager.handleExternalZoom=function(e){var t,a,o,i,r=document.getElementById("map_wrapper_"+e),n=this,l=n.maps[e].data,s=n.maps[e].series,d=n.maps[e].allBaseSeries;r&&(t=r.querySelector(".map_box"),r.classList.add("map_has_external_controls"),(r=document.createElement("div")).setAttribute("id","map_home_buttom_"+e),r.setAttribute("data-map-id",e),r.classList.add("map_home_button"),r.innerHTML='<svg height="20" width="20"><path d="M16,8 L14,8 L14,16 L10,16 L10,10 L6,10 L6,16 L2,16 L2,8 L0,8 L8,0 L16,8 Z M16,8" /></svg>',r.addEventListener("click",function(e){var t=this.getAttribute("data-map-id");if(iMaps.maps[t].map.goHome(),n.bool(l.drillDownOnClick)){for(var a=0,o=s.length;a<o;a++)s[a].hide();for(var i=0,r=d.length;i<r;i++)d[i].show();iMapsManager.maps[t].drilledTo=!1,iMapsManager.maps[t].isDrilling=!1}"undefined"!=typeof iMapsActions&&void 0!==iMapsActions.resetActions&&iMapsActions.resetActions(t)}),(o=document.createElement("div")).setAttribute("id","map_zoomin_buttom_"+e),o.setAttribute("data-map-id",e),o.classList.add("map_zoomin_button"),o.innerHTML="+",o.addEventListener("click",function(e){var t=this.getAttribute("data-map-id");iMaps.maps[t].map.zoomIn()}),(i=document.createElement("div")).setAttribute("id","map_zoomout_buttom_"+e),i.setAttribute("data-map-id",e),i.classList.add("map_zoomout_button"),i.innerHTML="-",i.addEventListener("click",function(e){var t=this.getAttribute("data-map-id");iMaps.maps[t].map.zoomOut()}),(a=document.createElement("div")).setAttribute("id","map_controls_"+e),a.classList.add("map_controls"),a.appendChild(r),a.appendChild(o),a.appendChild(i),t.parentNode.insertBefore(a,t.nextSibling))},iMapsManager.toggleFullscreen=function(e){document.fullscreen||document.webkitIsFullScreen?(document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen?document.webkitExitFullscreen():document.msExitFullscreen&&document.msExitFullscreen(),iMapsManager.isFullScreen=!1):e.requestFullscreen?e.requestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen?e.webkitRequestFullscreen():e.msRequestFullscreen&&e.msRequestFullscreen()},iMapsManager.isTouchScreendevice=function(){return"ontouchstart"in window||0<navigator.maxTouchPoints||0<navigator.msMaxTouchPoints},iMapsManager.nl2br=function(e){return(e+"").replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g,"HI<br>HI")},iMapsManager.isFullScreen=!1,{originalData:JSON.parse(JSON.stringify(iMapsData)),reset:function(){iMaps.maps&&Object.keys(iMaps.maps).forEach(function(e){iMaps.maps[e].map.dispose()}),iMapsData=iMaps.originalData,iMaps.init()},init:function(e){(e=void 0===e&&void 0!==iMapsData.options&&void 0!==iMapsData.options.hold&&"1"===iMapsData.options.hold?!0:e)||("undefined"==typeof am4core?(console.log("Map files not loaded properly."),(e=document.querySelector(".oxygen-body .map_wrapper .map_render"))&&(e.innerHTML='Map Container. <br> Map will not render in Oxygen preview, but will render in live page.<br>Consider enabling the "Async Loading" option in the Settings > Performance page.')):am4core.ready(function(){am4core.options.autoSetClassName=!0,am4core.options.classNamePrefix="imaps",am4core.options.commercialLicense=!0,am4core.options.queue=!0,void 0!==iMapsData.options&&void 0!==iMapsData.options.lazyLoad&&"1"===iMapsData.options.lazyLoad&&(am4core.options.onlyShowOnViewport=!0),void 0===iMapsData.options||void 0===iMapsData.options.animations||"1"!==iMapsData.options.animations&&!0!==iMapsData.options.animations||am4core.useTheme(am4themes_animated),iMapsModel.prepareData(iMapsData.data).forEach(function(e,t){t.disabled||iMapsManager.init(t)}),iMaps.maps=iMapsManager.maps}))},loadScript:function(e,t){var a=document.createElement("script");a.type="text/javascript",a.src=e,a.onreadystatechange=t,a.onload=t,document.head.appendChild(a)},loadScripts:function(e,t){function a(){++o>=e.length&&t.call(this,arguments)}var o=0;e.forEach(function(e,t){iMaps.loadScript(e,a)})}});void 0!==iMapsData.async&&Array.isArray(iMapsData.async)&&0<iMapsData.async.length?iMaps.loadScript(iMapsData.async[0],function(){iMapsData.async.shift(),iMaps.loadScripts(iMapsData.async,function(){iMaps.init()})}):iMaps.init();